/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    private ColorSpace srccs;
    private ColorSpace dstcs;
    private RenderingHints hints;
    private ICC_Profile[] profiles;
    private ColorSpace[] spaces;
    private boolean rasterValid;

    public final BufferedImage filter(BufferedImage transparency, BufferedImage bufferedImage) {
        Transparency transparency2;
        if (bufferedImage == null && this.spaces.length == 0) {
            throw new IllegalArgumentException();
        }
        if (transparency.isAlphaPremultiplied()) {
            transparency2 = this.createCompatibleDestImage((BufferedImage)transparency, transparency.getColorModel());
            this.copyimage((BufferedImage)transparency, (BufferedImage)transparency2);
            ((BufferedImage)transparency2).coerceData(false);
            transparency = transparency2;
        }
        transparency2 = transparency.getColorModel();
        int n = 0;
        while (n < this.spaces.length) {
            ColorModel colorModel = ((ColorModel)transparency2).cloneColorModel(this.spaces[n]);
            BufferedImage bufferedImage2 = this.createCompatibleDestImage((BufferedImage)transparency, colorModel);
            this.copyimage((BufferedImage)transparency, bufferedImage2);
            transparency = bufferedImage2;
            ++n;
        }
        if (bufferedImage == null) {
            return transparency;
        }
        this.copyimage((BufferedImage)transparency, bufferedImage);
        return bufferedImage;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isPremultiplied, null);
    }

    public final ICC_Profile[] getICC_Profiles() {
        return this.profiles;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (!this.rasterValid) {
            throw new IllegalArgumentException();
        }
        int n = 1;
        while (n < this.spaces.length - 1) {
            WritableRaster writableRaster2 = this.createCompatibleDestRaster(raster);
            this.copyraster(raster, this.spaces[n - 1], writableRaster2, this.spaces[n]);
            raster = writableRaster2;
            ++n;
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        this.copyraster(raster, this.spaces[this.spaces.length - 2], writableRaster, this.spaces[this.spaces.length - 1]);
        return writableRaster;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    private final void copyimage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHints(this.hints);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    private final void copyraster(Raster raster, ColorSpace colorSpace, WritableRaster writableRaster, ColorSpace colorSpace2) {
        float[] fArray = new float[raster.getNumBands()];
        if (this.hints.get(RenderingHints.KEY_COLOR_RENDERING) == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            int n = raster.getMinY();
            while (n < raster.getHeight() + raster.getMinY()) {
                int n2 = raster.getMinX();
                while (n2 < raster.getWidth() + raster.getMinX()) {
                    writableRaster.setPixel(n2, n, colorSpace2.fromCIEXYZ(colorSpace.toCIEXYZ(raster.getPixel(n2, n, fArray))));
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = raster.getMinY();
            while (n < raster.getHeight() + raster.getMinY()) {
                int n3 = raster.getMinX();
                while (n3 < raster.getWidth() + raster.getMinX()) {
                    writableRaster.setPixel(n3, n, colorSpace2.fromRGB(colorSpace.toRGB(raster.getPixel(n3, n, fArray))));
                    ++n3;
                }
                ++n;
            }
        }
    }

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace};
        this.hints = renderingHints;
        this.rasterValid = false;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace, colorSpace2};
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException();
        }
        this.hints = renderingHints;
        this.profiles = iCC_ProfileArray;
        this.spaces = new ColorSpace[iCC_ProfileArray.length];
        int n = 0;
        while (n < iCC_ProfileArray.length) {
            this.spaces[n] = new ICC_ColorSpace(iCC_ProfileArray[n]);
            ++n;
        }
    }

    public ColorConvertOp(RenderingHints renderingHints) {
        this.hints = renderingHints;
        this.srccs = null;
        this.dstcs = null;
        this.rasterValid = false;
    }
}

