/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    private static final long serialVersionUID = 1614381073220130939L;
    public static final int SCROLL_TAB_LAYOUT = 1;
    public static final int WRAP_TAB_LAYOUT = 0;
    protected ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    protected SingleSelectionModel model;
    protected int tabPlacement;
    private transient int layoutPolicy;
    transient Vector tabs;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TabbedPaneUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JTabbedPane.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])super.getListeners(clazz);
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        if (singleSelectionModel != this.model) {
            SingleSelectionModel singleSelectionModel2 = this.model;
            this.model.removeChangeListener(this.changeListener);
            this.model = singleSelectionModel;
            this.model.addChangeListener(this.changeListener);
            this.firePropertyChange("model", singleSelectionModel2, this.model);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 3 && n != 4 && n != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (n != this.tabPlacement) {
            int n2 = this.tabPlacement;
            this.tabPlacement = n;
            this.firePropertyChange("tabPlacement", n2, this.tabPlacement);
        }
    }

    public int getTabLayoutPolicy() {
        return this.layoutPolicy;
    }

    public void setTabLayoutPolicy(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        if (n != this.layoutPolicy) {
            int n2 = this.layoutPolicy;
            this.layoutPolicy = n;
            this.firePropertyChange("tabLayoutPolicy", n2, this.layoutPolicy);
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    private final void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n >= n3) {
            throw new IndexOutOfBoundsException("Index < " + n2 + " || Index >= " + n3);
        }
    }

    public void setSelectedIndex(int n) {
        this.checkIndex(n, -1, this.tabs.size());
        if (n != this.getSelectedIndex()) {
            if (this.getSelectedIndex() != -1 && this.getSelectedComponent() != null) {
                this.getSelectedComponent().hide();
            }
            if (n != -1 && this.getComponentAt(n) != null) {
                this.getComponentAt(n).show();
            }
            this.model.setSelectedIndex(n);
        }
    }

    public Component getSelectedComponent() {
        return this.getComponentAt(this.getSelectedIndex());
    }

    public void setSelectedComponent(Component component) {
        if (component.getParent() == this) {
            this.setSelectedIndex(this.indexOfComponent(component));
        } else {
            this.setComponentAt(this.getSelectedIndex(), component);
        }
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (string == null) {
            string = "";
        }
        Page page = new Page(string, icon, component, string2);
        this.tabs.insertElementAt(page, n);
        if (component != null) {
            component.hide();
            super.add(component);
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        this.revalidate();
        this.repaint();
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.tabs.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.tabs.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.tabs.size());
    }

    public Component add(Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(string, null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(Component component, int n) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, n);
        }
        return component;
    }

    public void add(Component component, Object object) {
        this.add(component, object, this.tabs.size());
    }

    public void add(Component component, Object object, int n) {
        if (component instanceof UIResource) {
            super.add(component);
        } else if (object instanceof String) {
            this.insertTab((String)object, null, component, null, n);
        } else {
            this.insertTab(component.getName(), object instanceof Icon ? (Icon)object : null, component, null, n);
        }
    }

    public void removeTabAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        this.tabs.remove(n);
        this.getComponentAt(n).show();
    }

    public void remove(Component component) {
        super.remove(component);
    }

    public void remove(int n) {
        super.remove(n);
        this.removeTabAt(n);
    }

    public void removeAll() {
        int n = this.tabs.size() - 1;
        while (n >= 0) {
            this.removeTabAt(n);
            --n;
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getTabRunCount() {
        return ((TabbedPaneUI)this.ui).getTabRunCount(this);
    }

    public String getTitleAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getTitle();
    }

    public Icon getIconAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getIcon();
    }

    public Icon getDisabledIconAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getDisabledIcon();
    }

    public String getToolTipTextAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getTip();
    }

    public Color getForegroundAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getForeground();
    }

    public Color getBackgroundAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getBackground();
    }

    public Component getComponentAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getComponent();
    }

    public boolean isEnabledAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).isEnabled();
    }

    public int getMnemonicAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((TabbedPaneUI)this.ui).getTabBounds(this, n);
    }

    public void setTitleAt(int n, String string) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setTitle(string);
    }

    public void setIconAt(int n, Icon icon) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setIcon(icon);
    }

    public void setDisabledIconAt(int n, Icon icon) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setDisabledIcon(icon);
    }

    public void setToolTipTextAt(int n, String string) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setTip(string);
    }

    public void setBackgroundAt(int n, Color color) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setBackground(color);
    }

    public void setForegroundAt(int n, Color color) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setForeground(color);
    }

    public void setEnabledAt(int n, boolean bl) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setEnabled(bl);
    }

    public void setComponentAt(int n, Component component) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setComponent(component);
    }

    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setDisplayedMnemonicIndex(n2);
    }

    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setMnemonic(n2);
    }

    public int indexOfTab(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(n2)).getTitle().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int indexOfTab(Icon icon) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(n2)).getIcon() == icon) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int indexOfComponent(Component component) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.tabs.size()) {
            if (((Page)this.tabs.elementAt(n2)).getComponent() == component) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int indexAtLocation(int n, int n2) {
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n, n2);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
        return ((Page)this.tabs.elementAt(n)).getTip();
    }

    protected String paramString() {
        return "JTabbedPane";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.tabPlacement = 1;
        this.tabs = new Vector();
    }

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int n) {
        this(n, 0);
    }

    public JTabbedPane(int n, int n2) {
        this.this();
        if (n != 1 && n != 3 && n != 4 && n != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        this.tabPlacement = n;
        this.layoutPolicy = n2;
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = this.createChangeListener();
        this.model = new DefaultSingleSelectionModel();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ModelListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 497359819958114132L;

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
        }

        protected ModelListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Page
    extends AccessibleContext
    implements Accessible {
        private static final long serialVersionUID = 1614381073220130939L;
        private String tip;
        private Component component;
        private transient Icon icon;
        private transient Icon disabledIcon;
        private transient boolean enabled;
        private transient String title;
        private transient Color bg;
        private transient Color fg;
        private transient int mnemonicKey;
        private transient int underlinedChar;

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component component) {
            int n = JTabbedPane.this.indexOfComponent(this.component);
            JTabbedPane.this.insertTab(this.title, this.icon, component, this.tip, n);
            this.component = component;
            JTabbedPane.this.removeTabAt(n);
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String string) {
            this.tip = string;
        }

        public Color getBackground() {
            Color color = this.bg == null ? this.component.getBackground() : this.bg;
            return color;
        }

        public void setBackground(Color color) {
            this.bg = color;
        }

        public Color getForeground() {
            Color color = this.fg == null ? this.component.getForeground() : this.fg;
            return color;
        }

        public void setForeground(Color color) {
            this.fg = color;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
            if (this.title != null && this.title.length() <= this.underlinedChar) {
                this.setDisplayedMnemonicIndex(this.title.length() - 1);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getDisabledIcon() {
            if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
                this.setDisabledIcon(this.icon);
            }
            return this.disabledIcon;
        }

        public void setDisabledIcon(Icon icon) {
            this.disabledIcon = icon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public int getMnemonic() {
            return this.mnemonicKey;
        }

        public void setMnemonic(int n) {
            this.setMnemonic((char)n);
        }

        public void setMnemonic(char c) {
            this.mnemonicKey = c;
            if (this.title != null) {
                this.setDisplayedMnemonicIndex(this.title.indexOf(this.mnemonicKey));
            }
        }

        public int getDisplayedMnemonicIndex() {
            return this.underlinedChar;
        }

        public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
            if (n < -1 || this.title != null && n >= this.title.length()) {
                throw new IllegalArgumentException();
            }
            if (this.title == null || this.mnemonicKey == 0 || n > -1 && this.title.charAt(n) != this.mnemonicKey) {
                n = -1;
            }
            this.underlinedChar = n;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return 0;
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            return (Accessible)((Object)this.component);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        private final /* synthetic */ void this() {
            this.enabled = true;
            this.underlinedChar = -1;
        }

        protected Page(String string, Icon icon, Component component, String string2) {
            this.this();
            this.title = string;
            this.icon = icon;
            this.component = component;
            this.tip = string2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = 7610530885966830483L;

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            Page page = null;
            if (n >= 0 && n < JTabbedPane.this.tabs.size()) {
                page = (Page)JTabbedPane.this.tabs.get(n);
            }
            return page;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

