/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class BasicSeparatorUI
extends SeparatorUI {
    protected Color shadow;
    protected Color highlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSeparatorUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JSeparator) {
            JSeparator jSeparator = (JSeparator)jComponent;
            this.installDefaults(jSeparator);
            this.installListeners(jSeparator);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent instanceof JSeparator) {
            JSeparator jSeparator = (JSeparator)jComponent;
            this.uninstallListeners(jSeparator);
            this.uninstallDefaults(jSeparator);
        }
    }

    protected void installDefaults(JSeparator jSeparator) {
        this.shadow = UIManager.getColor("Separator.shadow");
        this.highlight = UIManager.getColor("Separator.highlight");
        jSeparator.setOpaque(false);
    }

    protected void uninstallDefaults(JSeparator jSeparator) {
        this.shadow = null;
        this.highlight = null;
    }

    protected void installListeners(JSeparator jSeparator) {
    }

    protected void uninstallListeners(JSeparator jSeparator) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(jComponent, rectangle);
        Color color = graphics.getColor();
        if (!(jComponent instanceof JSeparator)) {
            return;
        }
        JSeparator jSeparator = (JSeparator)jComponent;
        if (jSeparator.getOrientation() == 0) {
            int n = rectangle.height / 2;
            graphics.setColor(this.shadow);
            graphics.drawLine(rectangle.x, rectangle.y + n - 1, rectangle.x + rectangle.width, rectangle.y + n - 1);
            graphics.setColor(this.highlight);
            graphics.fillRect(rectangle.x, rectangle.y + n, rectangle.x + rectangle.width, rectangle.y + n);
        } else {
            int n = rectangle.height / 2 + rectangle.y;
            graphics.setColor(this.shadow);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            graphics.setColor(this.highlight);
            graphics.fillRect(rectangle.x + n, rectangle.y + rectangle.height, rectangle.x + n, rectangle.y + rectangle.height);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JSeparator jSeparator;
        Dimension dimension = new Dimension(2, 0);
        if (jComponent instanceof JSeparator && (jSeparator = (JSeparator)jComponent).getOrientation() == 0) {
            dimension = new Dimension(0, 2);
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }
}

