/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Section;

public class Header {
    private static Random random = new Random();
    public static final int LENGTH = 12;
    private int id;
    private int flags;
    private int[] counts;

    private final void init() {
        this.counts = new int[4];
        this.flags = 0;
        this.id = -1;
    }

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.getID());
        dNSOutput.writeU16(this.flags);
        int n = 0;
        while (n < this.counts.length) {
            dNSOutput.writeU16(this.counts[n]);
            ++n;
        }
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static final boolean validFlag(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 15 && Flags.isFlag(n)) {
            bl = true;
        }
        return bl;
    }

    private static final void checkFlag(int n) {
        if (!Header.validFlag(n)) {
            throw new IllegalArgumentException("invalid flag bit " + n);
        }
    }

    public void setFlag(int n) {
        Header.checkFlag(n);
        this.flags |= 1 << 15 - n;
    }

    public void unsetFlag(int n) {
        Header.checkFlag(n);
        this.flags &= ~(1 << 15 - n);
    }

    public boolean getFlag(int n) {
        Header.checkFlag(n);
        boolean bl = false;
        if ((this.flags & 1 << 15 - n) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean[] getFlags() {
        boolean[] blArray = new boolean[16];
        int n = 0;
        while (n < blArray.length) {
            if (Header.validFlag(n)) {
                blArray[n] = this.getFlag(n);
            }
            ++n;
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getID() {
        if (this.id >= 0) {
            return this.id;
        }
        Header header = this;
        synchronized (header) {
            if (this.id < 0) {
                this.id = random.nextInt((char)-1);
            }
            return this.id;
        }
    }

    public void setID(int n) {
        if (n < 0 || n > (char)-1) {
            throw new IllegalArgumentException("DNS message ID " + n + " is out of range");
        }
        this.id = n;
    }

    public void setRcode(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("DNS Rcode " + n + " is out of range");
        }
        this.flags &= 0xFFFFFFF0;
        this.flags |= n;
    }

    public int getRcode() {
        return this.flags & 0xF;
    }

    public void setOpcode(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("DNS Opcode " + n + "is out of range");
        }
        this.flags &= 0x87FF;
        this.flags |= n << 11;
    }

    public int getOpcode() {
        return this.flags >> 11 & 0xF;
    }

    void setCount(int n, int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("DNS section count " + n2 + " is out of range");
        }
        this.counts[n] = n2;
    }

    void incCount(int n) {
        if (this.counts[n] == 255) {
            throw new IllegalStateException("DNS section count cannot be incremented");
        }
        int n2 = n;
        this.counts[n2] = this.counts[n2] + 1;
    }

    void decCount(int n) {
        if (this.counts[n] == 0) {
            throw new IllegalStateException("DNS section count cannot be decremented");
        }
        int n2 = n;
        this.counts[n2] = this.counts[n2] - 1;
    }

    public int getCount(int n) {
        return this.counts[n];
    }

    public String printFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            if (Header.validFlag(n) && this.getFlag(n)) {
                stringBuffer.append(Flags.string(n));
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    String toStringWithRcode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(";; ->>HEADER<<- ");
        stringBuffer.append("opcode: " + Opcode.string(this.getOpcode()));
        stringBuffer.append(", status: " + Rcode.string(n));
        stringBuffer.append(", id: " + this.getID());
        stringBuffer.append("\n");
        stringBuffer.append(";; flags: " + this.printFlags());
        stringBuffer.append("; ");
        int n2 = 0;
        while (n2 < 4) {
            stringBuffer.append(Section.string(n2) + ": " + this.getCount(n2) + ' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header header = new Header();
        header.id = this.id;
        header.flags = this.flags;
        System.arraycopy(this.counts, 0, header.counts, 0, this.counts.length);
        return header;
    }

    public Header(int n) {
        this.init();
        this.setID(n);
    }

    public Header() {
        this.init();
    }

    Header(DNSInput dNSInput) throws IOException {
        this(dNSInput.readU16());
        this.flags = dNSInput.readU16();
        int n = 0;
        while (n < this.counts.length) {
            this.counts[n] = dNSInput.readU16();
            ++n;
        }
    }

    public Header(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }
}

