<?php

class ChangePasswordAction  extends SOY2Action{

    protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
    	
    	//パスワード一致チェック
    	if($form->getPassword() != $form->getPasswordConfirm()){
    		$form->setError("passwordConfirm",new ActionFormError("","","","","パスワードが一致しません。"));
    	}
    	
    	$this->setAttribute("ChangePassword",$form);
    	
    	if($form->hasError()){
			return SOY2Action::FAILED;
		}
		
    	return SOY2Action::SUCCESS;
   	
    }
}

class ChangePasswordActionForm extends SOY2ActionForm{

	var $password;
	var $passwordConfirm;
	
	function getPassword() {
		return $this->password;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 20, "min" : 1, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "この項目は必須です。",
	 *		"max" : "パスワードが長すぎます。"
	 *	}
	 * }
	 */
	function setPassword($password) {
		$this->password = $password;
	}
	
	function getPasswordConfirm() {
		return $this->passwordConfirm;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 20, "min" : 1, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"min" : "この項目は必須です。",
	 *		"max" : "パスワードが長すぎます。"
	 *	}
	 * }
	 */
	function setPasswordConfirm($passwordConfirm) {
		$this->passwordConfirm = $passwordConfirm;
	}
}
?>