# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "10.5.0",
                "commands": "gcc",
            },
            "cython": {
                "name": "cython",
                "linker": "cython",
                "version": "3.0.6",
                "commands": "cython-3.12",
            },
            "c++": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "10.5.0",
                "commands": "c++",
            },
            "fortran": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "10.5.0",
                "commands": "gfortran",
            },
            "pythran": {
                "version": "0.14.0",
                "include directory": r"../../../../../../pkg/lib/python3.12/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "powerpc",
                "family": "ppc",
                "endian": "big",
                "system": "netbsd",
            },
            "build": {
                "cpu": "powerpc",
                "family": "ppc",
                "endian": "big",
                "system": "netbsd",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.11.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": "unknown",
                "pc file directory": r"/usr/pkgsrc/math/py-scipy/work/.buildlink/lib/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.11.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": "unknown",
                "pc file directory": r"/usr/pkgsrc/math/py-scipy/work/.buildlink/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.11.1",
                "detection method": "config-tool",
                "include directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/usr/pkg/bin/python3.12",
            "version": "3.12",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
