/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Hashtable;
import java.util.Vector;
import org.sablecc.sablecc.CharSet;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.NFA;

public class DFA {
    public NFA nfa;
    public final Vector states = new Vector(0);
    public final Hashtable finder = new Hashtable(1);
    private IntSet[] eclosures;

    public DFA(NFA nFA) {
        this.nfa = nFA;
        this.construct();
        this.optimize();
    }

    private void computeEClosures() {
        this.eclosures = new IntSet[this.nfa.states.length];
        int n = 0;
        while (n < this.nfa.states.length) {
            System.out.print(".");
            IntSet intSet = new IntSet();
            this.eclosure(n, intSet);
            this.eclosures[n] = intSet;
            ++n;
        }
        System.out.println();
    }

    private void construct() {
        this.computeEClosures();
        IntSet intSet = new IntSet();
        intSet.or(this.eclosure(0));
        State state = new State(intSet);
        this.states.addElement(state);
        this.finder.put(state.nfaStates, new Integer(0));
        int n = -1;
        while (++n < this.states.size()) {
            System.out.print(".");
            state = (State)this.states.elementAt(n);
            CharSet.Interval interval = new CharSet.Interval('\u0000', '\uffff');
            do {
                Object object;
                IntSet intSet2 = new IntSet();
                interval.end = (char)65535;
                boolean bl = false;
                int[] nArray = state.nfaStates.elements();
                int n2 = 0;
                while (n2 < nArray.length) {
                    int n3 = nArray[n2];
                    if (this.nfa.states[n3].transitions[0] != null && this.nfa.states[n3].transitions[0].chars != null && (object = this.nfa.states[n3].transitions[0].chars.findOverlap(interval)) != null) {
                        if (((CharSet.Interval)object).start > interval.start) {
                            interval.end = (char)(((CharSet.Interval)object).start - '\u0001');
                        } else {
                            intSet2.set(this.nfa.states[n3].transitions[0].destination);
                            bl = true;
                            if (((CharSet.Interval)object).end < interval.end) {
                                interval.end = ((CharSet.Interval)object).end;
                            }
                        }
                    }
                    if (this.nfa.states[n3].transitions[1] != null && this.nfa.states[n3].transitions[1].chars != null && (object = this.nfa.states[n3].transitions[1].chars.findOverlap(interval)) != null) {
                        if (((CharSet.Interval)object).start > interval.start) {
                            interval.end = (char)(((CharSet.Interval)object).start - '\u0001');
                        } else {
                            intSet2.set(this.nfa.states[n3].transitions[1].destination);
                            if (((CharSet.Interval)object).end < interval.end) {
                                interval.end = ((CharSet.Interval)object).end;
                            }
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    Integer n4 = (Integer)this.finder.get(intSet2 = this.eclosure(intSet2));
                    if (n4 != null) {
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), n4));
                    } else {
                        object = new State(intSet2);
                        this.states.addElement(object);
                        this.finder.put(((State)object).nfaStates, new Integer(this.states.size() - 1));
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), this.states.size() - 1));
                    }
                }
                interval.start = (char)(interval.end + '\u0001');
            } while (interval.end != '\uffff');
        }
    }

    private IntSet eclosure(int n) {
        return this.eclosures[n];
    }

    private void eclosure(int n, IntSet intSet) {
        if (this.eclosures[n] != null) {
            intSet.or(this.eclosures[n]);
            return;
        }
        intSet.set(n);
        if (this.nfa.states[n].transitions[0] != null && this.nfa.states[n].transitions[0].chars == null && !intSet.get(this.nfa.states[n].transitions[0].destination)) {
            this.eclosure(this.nfa.states[n].transitions[0].destination, intSet);
        }
        if (this.nfa.states[n].transitions[1] != null && this.nfa.states[n].transitions[1].chars == null && !intSet.get(this.nfa.states[n].transitions[1].destination)) {
            this.eclosure(this.nfa.states[n].transitions[1].destination, intSet);
        }
    }

    private IntSet eclosure(IntSet intSet) {
        IntSet intSet2 = new IntSet();
        int[] nArray = intSet.elements();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            intSet2.or(this.eclosure(n2));
            ++n;
        }
        return intSet2;
    }

    private int match(int n, int n2, int n3) {
        State state = (State)this.states.elementAt(n);
        State state2 = (State)this.states.elementAt(n3);
        Transition transition = (Transition)state.transitions.elementAt(n2);
        int n4 = -1;
        int n5 = 0;
        while (n5 < state2.transitions.size()) {
            Transition transition2 = (Transition)state2.transitions.elementAt(n5);
            if (transition2.match(transition)) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            return 0;
        }
        int n6 = 0;
        int n7 = n2;
        while (n7 < state.transitions.size() && n4 < state2.transitions.size()) {
            Transition transition3;
            Transition transition4 = (Transition)state.transitions.elementAt(n7);
            if (!transition4.match(transition3 = (Transition)state2.transitions.elementAt(n4))) {
                return n6;
            }
            ++n6;
            ++n7;
            ++n4;
        }
        return n6;
    }

    private void optimize() {
        Vector vector = new Vector(0);
        int n = 0;
        while (n < this.states.size()) {
            State state = (State)this.states.elementAt(n);
            vector.addElement(new Vector(0));
            int n2 = 0;
            while (n2 < state.transitions.size()) {
                int n3 = 0;
                int n4 = -1;
                int n5 = 0;
                while (n5 < n) {
                    int n6 = this.match(n, n2, n5);
                    if (n6 > n3) {
                        n3 = n6;
                        n4 = n5;
                    }
                    ++n5;
                }
                if (n3 < 2) {
                    ((Vector)vector.elementAt(n)).addElement(state.transitions.elementAt(n2));
                } else {
                    Transition transition = (Transition)state.transitions.elementAt(n2);
                    Transition transition2 = (Transition)state.transitions.elementAt(n2 + n3 - 1);
                    Transition transition3 = new Transition(new CharSet.Interval(transition.interval().start, transition2.interval().end), -2 - n4);
                    ((Vector)vector.elementAt(n)).addElement(transition3);
                    n2 += n3 - 1;
                }
                ++n2;
            }
            ++n;
        }
        int n7 = 0;
        while (n7 < this.states.size()) {
            State state = (State)this.states.elementAt(n7);
            state.transitions = (Vector)vector.elementAt(n7);
            ++n7;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.states.size()) {
            stringBuffer.append(String.valueOf(n) + ": " + this.states.elementAt(n) + System.getProperty("line.separator"));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class State {
        public IntSet nfaStates = new IntSet();
        public Vector transitions = new Vector(0);
        public int accept;

        public State(IntSet intSet) {
            this.nfaStates = intSet;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.transitions.size()) {
                stringBuffer.append(String.valueOf(String.valueOf(this.transitions.elementAt(n))) + ",");
                ++n;
            }
            return String.valueOf(String.valueOf(stringBuffer));
        }
    }

    public static class Transition {
        private char start;
        private char end;
        public int destination;

        public Transition(CharSet.Interval interval, int n) {
            this.start = interval.start;
            this.end = interval.end;
            this.destination = n;
        }

        public Transition(Transition transition) {
            this.start = transition.start;
            this.end = transition.end;
            this.destination = transition.destination;
        }

        public CharSet.Interval interval() {
            return new CharSet.Interval(this.start, this.end);
        }

        public boolean match(Transition transition) {
            return this.start == transition.start && this.end == transition.end && this.destination == transition.destination;
        }

        public String toString() {
            return String.valueOf(this.destination) + ":[" + this.interval() + "]";
        }
    }
}

