/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.util.WeakHashMap;

public class ClassMapping {
    private WeakHashMap classes;
    private WeakHashMap instances;
    private Class defaultClass;
    private Object defaultInstance;

    public ClassMapping(Class defaultClass, Object defaultInstance) {
        this.defaultClass = defaultClass;
        this.defaultInstance = defaultInstance;
        this.classes = new WeakHashMap(4);
        this.instances = new WeakHashMap(4);
    }

    public void addClassMapping(Object obj, Class value) {
        Class<?> key = obj == null ? null : obj.getClass();
        this.addClassMapping(key, value);
    }

    public void addClassMapping(Class key, Class value) {
        this.addClassMapping(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassMapping(Class key, Class value, Object instance) {
        if (key == null || value == null) {
            return;
        }
        WeakHashMap weakHashMap = this.classes;
        synchronized (weakHashMap) {
            this.classes.put(key, value);
        }
        if (instance != null) {
            weakHashMap = this.instances;
            synchronized (weakHashMap) {
                this.instances.put(key, instance);
            }
        }
    }

    public Class removeClassMapping(Object obj) {
        Class<?> key = obj == null ? null : obj.getClass();
        return this.removeClassMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class removeClassMapping(Class key) {
        if (key == null) {
            return null;
        }
        Class c = null;
        WeakHashMap weakHashMap = this.classes;
        synchronized (weakHashMap) {
            c = (Class)this.classes.remove(key);
        }
        weakHashMap = this.instances;
        synchronized (weakHashMap) {
            this.instances.remove(key);
        }
        return c;
    }

    public Class getClassMapping(Object obj) {
        Class<?> key = obj == null ? null : obj.getClass();
        return this.getClassMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClassMapping(Class key) {
        if (key == null) {
            return this.defaultClass;
        }
        Class value = null;
        WeakHashMap weakHashMap = this.classes;
        synchronized (weakHashMap) {
            for (Class c = key; c != null && value == null; c = c.getSuperclass()) {
                value = (Class)this.classes.get(c);
            }
        }
        return value == null ? this.defaultClass : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClassInstance(Class key) {
        if (key == null) {
            return this.defaultInstance;
        }
        Object value = null;
        WeakHashMap weakHashMap = this.instances;
        synchronized (weakHashMap) {
            for (Class c = key; c != null && value == null; c = c.getSuperclass()) {
                value = this.instances.get(c);
            }
        }
        return value == null ? this.defaultInstance : value;
    }

    public Class getDefaultMapping() {
        return this.defaultClass;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }
}

