/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.Utils;

public class Operand
extends Scope {
    private static final Logger logger = Logger.getLogger(Operand.class.getName());
    private OperandType operandType = OperandType.NONE;
    private ScopeLevel scopeLevel = ScopeLevel.NONE;
    private Integer value = null;
    private static final String OPERAND_TYPE_TAG = "operand-type";
    private static final String SCOPE_LEVEL_TAG = "scope-level";
    private static final String OLD_OPERAND_TYPE_TAG = "operandType";
    private static final String OLD_SCOPE_LEVEL_TAG = "scopeLevel";

    public Operand() {
    }

    public Operand(int value) {
        this.value = value;
    }

    public Operand(OperandType operandType, ScopeLevel scopeLevel) {
        this.operandType = operandType;
        this.scopeLevel = scopeLevel;
    }

    protected Operand(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final OperandType getOperandType() {
        return this.operandType;
    }

    public final void setOperandType(OperandType newOperandType) {
        this.operandType = newOperandType;
    }

    public final ScopeLevel getScopeLevel() {
        return this.scopeLevel;
    }

    public final void setScopeLevel(ScopeLevel newScopeLevel) {
        this.scopeLevel = newScopeLevel;
    }

    public final Integer getValue() {
        return this.value;
    }

    public final void setValue(Integer newValue) {
        this.value = newValue;
    }

    public Integer getValue(Game game) {
        return this.value != null ? this.value : (this.scopeLevel == ScopeLevel.GAME ? this.calculateGameValue(game) : null);
    }

    private Integer calculateGameValue(Game game) {
        String methodName = this.getMethodName();
        switch (this.operandType) {
            case NONE: {
                return game.invokeMethod(methodName, Integer.class, 0);
            }
            case YEAR: {
                return game.getTurn().getYear();
            }
            case OPTION: {
                return game.getSpecification().getInteger(this.getType());
            }
        }
        LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
        block11: for (Player player : game.getLivePlayers(null)) {
            switch (this.operandType) {
                case UNITS: {
                    list.addAll(player.getUnits());
                    break;
                }
                case BUILDINGS: {
                    for (Colony colony : player.getColonies()) {
                        list.addAll(colony.getBuildings());
                    }
                    continue block11;
                }
                case SETTLEMENTS: {
                    list.addAll(player.getSettlements());
                    break;
                }
                case FOUNDING_FATHERS: {
                    list.addAll(player.getFathers());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return this.count(list);
    }

    public Integer getValue(Player player) {
        if (this.value != null) {
            return this.value;
        }
        switch (this.scopeLevel) {
            case GAME: {
                return this.getValue(player.getGame());
            }
            case PLAYER: {
                break;
            }
            default: {
                return null;
            }
        }
        Specification spec = player.getSpecification();
        String methodName = this.getMethodName();
        LinkedList<FreeColObject> list = new LinkedList<FreeColObject>();
        switch (this.operandType) {
            case UNITS: {
                return this.count(player.getUnits());
            }
            case BUILDINGS: {
                for (Colony colony : player.getColonies()) {
                    list.addAll(colony.getBuildings());
                }
                return this.count(list);
            }
            case SETTLEMENTS: {
                if (methodName == null) {
                    return this.count(player.getSettlements()) + spec.getInteger("model.option.settlementLimitModifier");
                }
                String methodValue = this.getMethodValue();
                int result = 0;
                for (Settlement settlement : player.getSettlements()) {
                    Boolean b = settlement.invokeMethod(methodName, Boolean.class, Boolean.FALSE);
                    if (!String.valueOf(b).equals(methodValue)) continue;
                    ++result;
                }
                return result;
            }
            case FOUNDING_FATHERS: {
                list.addAll(player.getFathers());
                return this.count(list);
            }
        }
        return player.invokeMethod(methodName, Integer.class, null);
    }

    public Integer getValue(Settlement settlement) {
        if (this.value == null) {
            if (this.scopeLevel == ScopeLevel.SETTLEMENT && settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                LinkedList<UnitLocation> list = new LinkedList<UnitLocation>();
                switch (this.operandType) {
                    case UNITS: {
                        list.addAll(colony.getUnitList());
                        break;
                    }
                    case BUILDINGS: {
                        list.addAll(colony.getBuildings());
                        break;
                    }
                    default: {
                        return colony.invokeMethod(this.getMethodName(), Integer.class, null);
                    }
                }
                return this.count(list);
            }
            return null;
        }
        return this.value;
    }

    private int count(List<? extends FreeColObject> objects) {
        int result = 0;
        for (FreeColObject freeColObject : objects) {
            if (!this.appliesTo(freeColObject)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Operand && this.operandType == ((Operand)o).operandType && this.scopeLevel == ((Operand)o).scopeLevel && Utils.equals(this.value, ((Operand)o).value) && super.equals(o);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OPERAND_TYPE_TAG, this.operandType);
        xw.writeAttribute(SCOPE_LEVEL_TAG, this.scopeLevel);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.operandType = xr.hasAttribute(OLD_OPERAND_TYPE_TAG) ? xr.getAttribute(OLD_OPERAND_TYPE_TAG, OperandType.class, OperandType.NONE) : xr.getAttribute(OPERAND_TYPE_TAG, OperandType.class, OperandType.NONE);
        this.scopeLevel = xr.hasAttribute(OLD_SCOPE_LEVEL_TAG) ? xr.getAttribute(OLD_SCOPE_LEVEL_TAG, ScopeLevel.class, ScopeLevel.NONE) : xr.getAttribute(SCOPE_LEVEL_TAG, ScopeLevel.class, ScopeLevel.NONE);
        int val = xr.getAttribute("value", Integer.MAX_VALUE);
        if (val != Integer.MAX_VALUE) {
            this.value = val;
        }
    }

    @Override
    public String toString() {
        if (this.value != null) {
            return Integer.toString(this.value);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[Operand type=").append((Object)this.operandType).append(" scopeLevel=").append((Object)this.scopeLevel);
        return super.toString().replaceFirst("^[^ ]*", sb.toString());
    }

    public static enum ScopeLevel {
        SETTLEMENT,
        PLAYER,
        GAME,
        NONE;

    }

    public static enum OperandType {
        UNITS,
        BUILDINGS,
        SETTLEMENTS,
        FOUNDING_FATHERS,
        YEAR,
        OPTION,
        NONE;

    }
}

