;;;
;;; irchat-pj-specific-mule2.el
;;; last modify : Thu, 28 Oct 1999 00:04:46 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

;;; for irchat-pj-coding-system.el

;; define service / set process

(defsubst irchat-pj-define-service-coding-system (service)
  (define-service-coding-system service nil (cons *noconv* *noconv*)))

(defsubst irchat-pj-set-process-coding-system (proc)
  (set-process-coding-system proc *noconv* *noconv*))

;; output functions

(defsubst irchat-pj-string-out-iso-2022-7bit-ss2 (str)
  (code-convert-string str *internal* *iso-2022-ss2-7*))

(defsubst irchat-pj-string-out-iso-2022-jp (str)
  (code-convert-string str *internal* *iso-2022-jp*))

(defsubst irchat-pj-string-out-euc-jp (str)
  (code-convert-string str *internal* *euc-japan*))

(defsubst irchat-pj-string-out-sjis (str)
  (code-convert-string str *internal* *sjis*))

;; input functions

(defun irchat-pj-decode-coding-string (string coding-system)
  (let (ret (len (length string)))
    (catch 'ok
      (while (< 0 len)
	(and (setq ret (code-convert-string (substring string 0 len) coding-system *internal*))
	     (throw 'ok t))
	(setq len (1- len))))
    (or ret string)))

(defsubst irchat-pj-string-in-iso-2022-7bit-ss2 (str)
  (irchat-pj-decode-coding-string str *iso-2022-ss2-7*))

(defsubst irchat-pj-string-in-iso-2022-jp (str)
  (irchat-pj-decode-coding-string str *iso-2022-jp*))

(defsubst irchat-pj-string-in-euc-jp-internal (str)
  (irchat-pj-decode-coding-string str *euc-japan*))

(defsubst irchat-pj-string-in-sjis-internal (str)
  (irchat-pj-decode-coding-string str *sjis*))

;;; for irchat-pj-version-string.el

(defun irchat-pj-set-emacs-version-string ()
  "Set Emacs version string for CTCP VERSION"
  (cond ((and (boundp 'mc-flag) mc-flag)
	 (concat "MULE "
		 (if (boundp 'rail-ja-mule-version)
		     rail-ja-mule-version
		   mule-version)
		 " GNU Emacs " emacs-version
		 " (" system-configuration ")"))
	(t
	 (concat "MULE " mule-version " based on Emacs " emacs-version
		 " (" system-configuration ")"))))

(provide 'irchat-pj-specific-mule2)

;;;
;;; end
;;;
