/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    private static final long serialVersionUID = 7515723908773894738L;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('S');
    public static final int SIZE = 16;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Short[] shortCache = new Short[256];
    private final short value;

    public static final String toString(short s) {
        return String.valueOf(s);
    }

    public static final short parseShort(String string) {
        return Short.parseShort(string, 10);
    }

    public static final short parseShort(String string, int n) {
        int n2 = Integer.parseInt(string, n, false);
        if ((short)n2 != n2) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public static final Short valueOf(String string, int n) {
        return new Short(Short.parseShort(string, n));
    }

    public static final Short valueOf(String string) {
        return new Short(Short.parseShort(string, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Short valueOf(short s) {
        if (s < -128 || s > 127) {
            return new Short(s);
        }
        Short[] shortArray = shortCache;
        synchronized (shortCache) {
            if (shortCache[s - -128] == null) {
                Short.shortCache[s - -128] = new Short(s);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return shortCache[s - -128];
        }
    }

    public static final Short decode(String string) {
        int n = Integer.parseInt(string, 10, true);
        if ((short)n != n) {
            throw new NumberFormatException();
        }
        return new Short((short)n);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Short && this.value == ((Short)object).value) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Short s) {
        return this.value - s.value;
    }

    public final int compareTo(Object object) {
        return this.compareTo((Short)object);
    }

    public static final short reverseBytes(short s) {
        return (short)(s >> 8 & 0xFF | s << 8 & 0xFF00);
    }

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) {
        this.value = Short.parseShort(string, 10);
    }
}

