/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;
    static /* synthetic */ Class class$javax$swing$JRootPane;
    static /* synthetic */ Class class$java$awt$Window;

    public static Rectangle calculateInnerArea(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return null;
        }
        rectangle = jComponent.getBounds(rectangle);
        Insets insets = jComponent.getInsets();
        rectangle.x = insets.left;
        rectangle.width = rectangle.width - insets.left - insets.right;
        rectangle.y = insets.top;
        rectangle.height = rectangle.height - insets.top - insets.bottom;
        return rectangle;
    }

    public static Component findFocusOwner(Component component) {
        Component component2;
        Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (component3 != null) {
            if (component3 == component) {
                return component2;
            }
            component3 = component3.getParent();
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        return component.getAccessibleContext().getAccessibleComponent().getAccessibleAt(point);
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        return component.getAccessibleContext().getAccessibleChild(n);
    }

    public static int getAccessibleChildrenCount(Component component) {
        return component.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component component) {
        return component.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        return component.getAccessibleContext().getAccessibleStateSet();
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        Class clazz = class$javax$swing$JRootPane;
        if (clazz == null) {
            clazz = class$javax$swing$JRootPane = SwingUtilities.class("[Ljavax.swing.JRootPane;", false);
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(clazz, component);
    }

    public static Container getAncestorNamed(String string, Component component) {
        while (component != null && component.getName() != string) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        while (component != null && !clazz.isInstance(component)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Window getWindowAncestor(Component component) {
        Class clazz = class$java$awt$Window;
        if (clazz == null) {
            clazz = class$java$awt$Window = SwingUtilities.class("[Ljava.awt.Window;", false);
        }
        return (Window)SwingUtilities.getAncestorOfClass(clazz, component);
    }

    public static Window windowForComponent(Component component) {
        Class clazz = class$java$awt$Window;
        if (clazz == null) {
            clazz = class$java$awt$Window = SwingUtilities.class("[Ljava.awt.Window;", false);
        }
        return (Window)SwingUtilities.getAncestorOfClass(clazz, component);
    }

    public static Component getRoot(Component component) {
        Applet applet = null;
        Window window = null;
        while (component != null) {
            if (window == null && component instanceof Window) {
                window = (Window)component;
            } else if (component instanceof Applet) {
                applet = (Applet)component;
            }
            component = component.getParent();
        }
        if (window != null) {
            return window;
        }
        return applet;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null && component2 != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentAt(n, n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null) {
            component = SwingUtilities.getRoot(component2);
        }
        if (component2 == null) {
            component2 = SwingUtilities.getRoot(component);
        }
        if (component.isShowing() && component2.isShowing()) {
            SwingUtilities.convertPointToScreen(point, component);
            SwingUtilities.convertPointFromScreen(point, component2);
        }
        return point;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        return SwingUtilities.convertPoint(component, point.x, point.y, component2);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = SwingUtilities.convertPoint(component, rectangle.x, rectangle.y, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = SwingUtilities.convertPoint(component, mouseEvent.getX(), mouseEvent.getY(), component2);
        return new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static void updateComponentTreeUI(Component component) {
        SwingUtilities.updateComponentTreeUIImpl(component);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.revalidate();
        } else {
            component.invalidate();
            component.validate();
        }
        component.repaint();
    }

    private static final void updateComponentTreeUIImpl(Component component) {
        Component[] componentArray;
        if (component instanceof JComponent) {
            componentArray = (Component[])component;
            componentArray.updateUI();
        }
        componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                SwingUtilities.updateComponentTreeUIImpl(componentArray[n]);
                ++n;
            }
        }
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (n4 == 10) {
            n4 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (n4 == 11) {
            n4 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        if (n2 == 10) {
            n2 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (n2 == 11) {
            n2 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        return SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        if (icon == null) {
            n5 = 0;
            rectangle2.width = 0;
            rectangle2.height = 0;
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (string == null || string.equals("")) {
            n5 = 0;
            rectangle3.width = 0;
            rectangle3.height = 0;
        } else {
            n6 = 0;
            rectangle3.width = fontMetrics.stringWidth(string);
            rectangle3.height = fontMetrics.getHeight();
            while (string.indexOf(10, n6) != -1) {
                rectangle3.height += fontMetrics.getHeight();
                n6 = string.indexOf(10, n6) + 1;
            }
        }
        switch (n4) {
            case 2: {
                rectangle3.x = 0;
                rectangle2.x = rectangle3.width + n5;
                break;
            }
            case 4: {
                rectangle2.x = 0;
                rectangle3.x = rectangle2.width + n5;
                break;
            }
            case 0: {
                n6 = Math.max(rectangle3.width, rectangle2.width) / 2;
                rectangle3.x = n6 - rectangle3.width / 2;
                rectangle2.x = n6 - rectangle2.width / 2;
                break;
            }
        }
        switch (n3) {
            case 1: {
                rectangle3.y = 0;
                int n7 = 0;
                if (n4 == 0) {
                    n7 = rectangle3.height + n5;
                }
                rectangle2.y = n7;
                break;
            }
            case 3: {
                rectangle2.y = 0;
                rectangle3.y = n4 == 0 ? rectangle2.height + n5 : Math.max(rectangle2.height - rectangle3.height, 0);
                break;
            }
            case 0: {
                n6 = Math.max(rectangle3.height, rectangle2.height) / 2;
                rectangle3.y = n6 - rectangle3.height / 2;
                rectangle2.y = n6 - rectangle2.height / 2;
                break;
            }
        }
        Rectangle rectangle4 = rectangle3.union(rectangle2);
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        switch (n) {
            case 1: {
                break;
            }
            case 3: {
                n9 += rectangle.height - rectangle4.height;
                break;
            }
            case 0: {
                n9 += rectangle.height / 2 - rectangle4.height / 2;
                break;
            }
        }
        switch (n2) {
            case 2: {
                break;
            }
            case 4: {
                n8 += rectangle.width - rectangle4.width;
                break;
            }
            case 0: {
                n8 += rectangle.width / 2 - rectangle4.width / 2;
                break;
            }
        }
        rectangle2.x += n8;
        rectangle2.y += n9;
        rectangle3.x += n8;
        rectangle3.y += n9;
        return string;
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        Container container2 = component.getParent();
        if (container2 != null) {
            container2.remove(component);
        }
        if (container != null) {
            container.add(component);
        }
        Shape shape = graphics.getClip();
        graphics.setClip(n, n2, n3, n4);
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
        graphics.setClip(shape);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static Window getOwnerFrame(Window window) {
        Window window2 = window;
        if (window2 == null) {
            if (ownerFrame == null) {
                ownerFrame = new OwnerFrame();
            }
            window2 = ownerFrame;
        }
        return window2;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        boolean bl = false;
        if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        boolean bl = false;
        if ((mouseEvent.getModifiersEx() & 0x800) == 2048) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        boolean bl = false;
        if ((mouseEvent.getModifiersEx() & 0x1000) == 4096) {
            bl = true;
        }
        return bl;
    }

    public static boolean notifyAction(Action action, KeyStroke keyStroke, KeyEvent keyEvent, Object object, int n) {
        if (action != null && action.isEnabled()) {
            String string = (String)action.getValue("ActionCommandKey");
            if (string == null && keyEvent.getKeyChar() != (char)-1) {
                string = new String(new char[]{keyEvent.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(object, 1001, string, n));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent jComponent, ActionMap actionMap) {
        ActionMap actionMap2 = jComponent.getActionMap();
        if (actionMap2 == null) {
            jComponent.setActionMap(actionMap);
        } else {
            ActionMap actionMap3 = actionMap2.getParent();
            while (actionMap3 != null && !(actionMap3 instanceof ActionMapUIResource)) {
                actionMap2 = actionMap3;
                actionMap3 = actionMap2.getParent();
            }
            if (actionMap2 != actionMap) {
                actionMap2.setParent(actionMap);
            }
        }
    }

    public static void replaceUIInputMap(JComponent jComponent, int n, InputMap inputMap) {
        InputMap inputMap2 = jComponent.getInputMap(n);
        if (inputMap2 == null) {
            jComponent.setInputMap(n, inputMap);
        } else {
            InputMap inputMap3 = inputMap2.getParent();
            while (inputMap3 != null && !(inputMap3 instanceof InputMapUIResource)) {
                inputMap2 = inputMap3;
                inputMap3 = inputMap3.getParent();
            }
            if (inputMap2 != inputMap) {
                inputMap2.setParent(inputMap);
            }
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[4];
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        int n7 = rectangle2.width;
        int n8 = rectangle2.height;
        int n9 = 0;
        if (n6 > n2) {
            n9 = n6 - n2;
        }
        int n10 = n9;
        int n11 = 0;
        if (n6 + n8 < n2 + n4) {
            n11 = n2 + n4 - n6 - n8;
        }
        int n12 = n11;
        int n13 = 0;
        if (n5 > n) {
            n13 = n5 - n;
        }
        int n14 = n13;
        int n15 = 0;
        if (n + n3 > n5 + n7) {
            n15 = n + n3 - n5 - n7;
        }
        int n16 = n15;
        int n17 = 0;
        if (n10 + n12 < n4) {
            n17 = n4 - n10 - n12;
        }
        int n18 = n17;
        rectangleArray[0] = n10 > 0 ? new Rectangle(n, n2, n3, n10) : null;
        rectangleArray[1] = n14 > 0 && n18 > 0 ? new Rectangle(n, n2 + n10, n14, n18) : null;
        rectangleArray[2] = n16 > 0 && n18 > 0 ? new Rectangle(n5 + n7, n2 + n10, n16, n18) : null;
        rectangleArray[3] = n12 > 0 ? new Rectangle(n, n2 + n10 + n18, n3, n12) : null;
        int n19 = 0;
        int n20 = 0;
        while (n20 < 4) {
            if (rectangleArray[n20] != null) {
                ++n19;
            }
            ++n20;
        }
        Rectangle[] rectangleArray2 = new Rectangle[n19];
        int n21 = 3;
        while (n21 >= 0) {
            if (rectangleArray[n21] != null) {
                rectangleArray2[--n19] = rectangleArray[n21];
            }
            --n21;
        }
        return rectangleArray2;
    }

    public static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static Rectangle computeUnion(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n < n6 ? n : n6;
        int n11 = n2 < n7 ? n2 : n7;
        int n12 = n + n3 > n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 > n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    public static boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        boolean bl = false;
        if (rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            bl = true;
        }
        return bl;
    }

    public static InputMap getUIInputMap(JComponent jComponent, int n) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getInputMap(n).getParent();
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent jComponent) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getActionMap().getParent();
        }
        return null;
    }

    public static boolean processKeyBindings(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        return keyboardManager.processKeyStroke(component, keyStroke, keyEvent);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private SwingUtilities() {
    }

    private static class OwnerFrame
    extends Frame {
        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return true;
        }

        private OwnerFrame() {
        }
    }
}

