/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.awt.geom.Point2D;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.PointBehaviourListener;
import uk.ac.ic.doc.scenebeans.behaviour.PointActivityBase;

public class MovePoint
extends PointActivityBase
implements Serializable {
    private Point2D _from;
    private Point2D _to;
    private double _x_len;
    private double _y_len;
    private double _duration;
    private double _timeout;

    public MovePoint() {
        this._from = new Point2D.Double(0.0, 0.0);
        this._to = new Point2D.Double(0.0, 0.0);
        this._timeout = 1.0;
        this._duration = 1.0;
        this.setDistances();
    }

    public MovePoint(Point2D point2D, Point2D point2D2, double d) {
        this._from = point2D;
        this._to = point2D2;
        this._duration = this._timeout = d;
        this.setDistances();
    }

    public Point2D getFrom() {
        return this._from;
    }

    public void setFrom(Point2D point2D) {
        this._from = point2D;
        this.setDistances();
    }

    public Point2D getTo() {
        return this._to;
    }

    public void setTo(Point2D point2D) {
        this._to = point2D;
        this.setDistances();
    }

    public double getDuration() {
        return this._duration;
    }

    public void setDuration(double d) {
        this._duration = this._timeout = d;
    }

    public Point2D getValue() {
        double d = 1.0 - this._timeout / this._duration;
        double d2 = this._from.getX() + d * this._x_len;
        double d3 = this._from.getY() + d * this._y_len;
        return new Point2D.Double(d2, d3);
    }

    public boolean isFinite() {
        return true;
    }

    public void reset() {
        this._timeout = this._duration;
        this.postUpdate(this.getValue());
    }

    public void performActivity(double d) {
        if (this._timeout > 0.0) {
            this._timeout -= d;
            if (this._timeout <= 0.0) {
                this._timeout = 0.0;
                this.postActivityComplete();
            }
            this.postUpdate(this.getValue());
        }
    }

    private void setDistances() {
        this._x_len = this._to.getX() - this._from.getX();
        this._y_len = this._to.getY() - this._from.getY();
    }

    public final PointBehaviourListener newFromAdapter() {
        return new FromAdapter();
    }

    public final PointBehaviourListener newToAdapter() {
        return new ToAdapter();
    }

    public final DoubleBehaviourListener newDurationAdapter() {
        return new DurationAdapter();
    }

    class DurationAdapter
    implements DoubleBehaviourListener,
    Serializable {
        DurationAdapter() {
        }

        public void behaviourUpdated(double d) {
            MovePoint.this.setDuration(d);
        }
    }

    class ToAdapter
    implements PointBehaviourListener,
    Serializable {
        ToAdapter() {
        }

        public void behaviourUpdated(Point2D point2D) {
            MovePoint.this.setTo(point2D);
        }
    }

    class FromAdapter
    implements PointBehaviourListener,
    Serializable {
        FromAdapter() {
        }

        public void behaviourUpdated(Point2D point2D) {
            MovePoint.this.setFrom(point2D);
        }
    }
}

