package ONVIF::Device::Types::RemoteUser;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Username_of :ATTR(:get<Username>);
my %Password_of :ATTR(:get<Password>);
my %UseDerivedPassword_of :ATTR(:get<UseDerivedPassword>);

__PACKAGE__->_factory(
    [ qw(        Username
        Password
        UseDerivedPassword

    ) ],
    {
        'Username' => \%Username_of,
        'Password' => \%Password_of,
        'UseDerivedPassword' => \%UseDerivedPassword_of,
    },
    {
        'Username' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Password' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'UseDerivedPassword' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'Username' => 'Username',
        'Password' => 'Password',
        'UseDerivedPassword' => 'UseDerivedPassword',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RemoteUser

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RemoteUser from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Username


=item * Password


=item * UseDerivedPassword




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RemoteUser
   Username =>  $some_value, # string
   Password =>  $some_value, # string
   UseDerivedPassword =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

