/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Vector;

public class ChoiceFormat
extends NumberFormat {
    private static final int mantissaBits = 52;
    private static final int exponentBits = 11;
    private static final long serialVersionUID = 1795184449645032964L;
    private String[] choiceFormats;
    private double[] choiceLimits;

    public void applyPattern(String string) {
        Double d;
        int n;
        int n2 = 0;
        int n3 = string.length();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            n = ++n2;
            while (n2 < n3) {
                char c = string.charAt(n2);
                if (c == '#' || c == '\u2064' || c == '<') break;
                ++n2;
            }
            if (n2 == n3) {
                throw new IllegalArgumentException("unexpected end of text");
            }
            d = new Double(string.substring(n, n2));
            if (string.charAt(n2) == '<') {
                d = new Double(ChoiceFormat.nextDouble(d));
            }
            vector2.addElement(d);
            ++n2;
            stringBuffer.setLength(0);
            while (n2 < n3) {
                char c = string.charAt(n2);
                if (c == '\'' && n2 < n3 + 1 && string.charAt(n2 + 1) == '\'') {
                    stringBuffer.append(c);
                    ++n2;
                } else if (c == '\'' && n2 < n3 + 2) {
                    stringBuffer.append(string.charAt(n2 + 1));
                    n2 += 2;
                } else {
                    if (c == '|') break;
                    stringBuffer.append(c);
                }
                ++n2;
            }
            vector.addElement(stringBuffer.toString());
            if (n2 == n3) break;
        }
        this.choiceFormats = new String[vector.size()];
        vector.copyInto(this.choiceFormats);
        this.choiceLimits = new double[vector2.size()];
        n = 0;
        while (n < this.choiceLimits.length) {
            d = (Double)vector2.elementAt(n);
            this.choiceLimits[n] = d;
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        if (this.choiceLimits.length != choiceFormat.choiceLimits.length) {
            return false;
        }
        int n = this.choiceLimits.length - 1;
        while (n >= 0) {
            if (this.choiceLimits[n] != choiceFormat.choiceLimits[n] || !this.choiceFormats[n].equals(choiceFormat.choiceFormats[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.choiceLimits.length == 0) {
            return stringBuffer;
        }
        int n = 0;
        if (!Double.isNaN(d) && d >= this.choiceLimits[0]) {
            while (n < this.choiceLimits.length - 1) {
                if (this.choiceLimits[n] <= d && d < this.choiceLimits[n + 1]) break;
                ++n;
            }
        }
        return stringBuffer.append(this.choiceFormats[n]);
    }

    public Object[] getFormats() {
        return (Object[])this.choiceFormats.clone();
    }

    public double[] getLimits() {
        return (double[])this.choiceLimits.clone();
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.choiceLimits.length) {
            long l = Double.doubleToLongBits(this.choiceLimits[n2]);
            n = (int)((long)n ^ (l ^ l >>> 32));
            n ^= this.choiceFormats[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static double nextDouble(double d, boolean bl) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = 0xFFFFFFFFFFFFFL;
        long l3 = l & l2;
        long l4 = 2047L;
        long l5 = l >>> 52 & l4;
        boolean bl2 = false;
        if (l < 0L) {
            bl2 = true;
        }
        if (bl != bl2) {
            if (l3 == 0xFFFFFFFFFFFFFL) {
                l3 = 0L;
                if (++l5 >= 0x10000000000000L) {
                    return l > 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
            } else {
                ++l3;
            }
        } else {
            if (l5 == 0L && l3 == 0L) {
                return bl ? Double.MIN_VALUE : -4.9E-324;
            }
            if (l3 == 0L) {
                l3 = 0xFFFFFFFFFFFFFL;
                --l5;
            } else {
                --l3;
            }
        }
        int n = 0;
        if (l < 0L) {
            n = 1;
        }
        long l6 = n;
        l6 = l6 << 11 | l5;
        l6 = l6 << 52 | l3;
        return Double.longBitsToDouble(l6);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = 0;
        while (n2 < this.choiceLimits.length) {
            if (string.startsWith(this.choiceFormats[n2], n)) {
                parsePosition.setIndex(n + this.choiceFormats[n2].length());
                return new Double(this.choiceLimits[n2]);
            }
            ++n2;
        }
        parsePosition.setErrorIndex(n);
        return new Double(Double.NaN);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        if (dArray == null || stringArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        this.choiceFormats = (String[])stringArray.clone();
        this.choiceLimits = (double[])dArray.clone();
    }

    private final void quoteString(StringBuffer stringBuffer, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\'') {
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '#' || c == '|' || c == '\u2064' || c == '<') {
                stringBuffer.append('\'');
                stringBuffer.append(c);
                stringBuffer.append('\'');
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.choiceLimits.length) {
            stringBuffer.append(this.choiceLimits[n]);
            stringBuffer.append('#');
            this.quoteString(stringBuffer, this.choiceFormats[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }
}

