/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.internal.Cast;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.Jdk;
import org.gradle.plugins.ide.idea.model.Path;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.ProjectLibrary;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class Project
extends XmlPersistableConfigurationObject {
    private final PathFactory pathFactory;
    private List<IdeaModule> modules;
    private JavaVersion bytecodeVersion;
    private Set<Path> modulePaths = Sets.newLinkedHashSet();
    private Set<String> wildcards = Sets.newLinkedHashSet();
    private Jdk jdk;
    private String vcs;
    private Set<ProjectLibrary> projectLibraries = Sets.newLinkedHashSet();

    public Project(XmlTransformer xmlTransformer, Object pathFactory) {
        super(xmlTransformer);
        this.pathFactory = (PathFactory)pathFactory;
    }

    public Set<Path> getModulePaths() {
        return this.modulePaths;
    }

    public void setModulePaths(Set<Path> modulePaths) {
        this.modulePaths = modulePaths;
    }

    public void addModulePath(File moduleFile) {
        this.modulePaths.add(this.pathFactory.relativePath("PROJECT_DIR", moduleFile));
    }

    public Set<String> getWildcards() {
        return this.wildcards;
    }

    public void setWildcards(Set<String> wildcards) {
        this.wildcards = wildcards;
    }

    public Jdk getJdk() {
        return this.jdk;
    }

    public void setJdk(Jdk jdk) {
        this.jdk = jdk;
    }

    public String getVcs() {
        return this.vcs;
    }

    public void setVcs(String vcs) {
        this.vcs = vcs;
    }

    public Set<ProjectLibrary> getProjectLibraries() {
        return this.projectLibraries;
    }

    public void setProjectLibraries(Set<ProjectLibrary> projectLibraries) {
        this.projectLibraries = projectLibraries;
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultProject.xml";
    }

    public void configure(List<IdeaModule> modules, String jdkName, IdeaLanguageLevel languageLevel, JavaVersion bytecodeVersion, Collection<String> wildcards, Collection<ProjectLibrary> projectLibraries, String vcs) {
        if (!Strings.isNullOrEmpty((String)jdkName)) {
            this.jdk = new Jdk(jdkName, languageLevel);
        }
        this.bytecodeVersion = bytecodeVersion;
        this.modules = modules;
        for (IdeaModule module : modules) {
            this.addModulePath(module.getOutputFile());
        }
        this.wildcards.addAll(wildcards);
        this.projectLibraries = Sets.newLinkedHashSet(projectLibraries);
        this.vcs = vcs;
    }

    @Override
    protected void load(Node xml) {
        this.loadModulePaths();
        this.loadWildcards();
        this.loadJdk();
        this.loadProjectLibraries();
    }

    @Override
    protected void store(Node xml) {
        this.storeModulePaths();
        this.storeWildcards();
        this.storeJdk();
        this.storeBytecodeLevels();
        this.storeVcs();
        this.storeProjectLibraries();
    }

    private void loadModulePaths() {
        for (Node moduleNode : Project.getChildren(this.findOrCreateModules(), "module")) {
            String fileurl = (String)moduleNode.attribute((Object)"fileurl");
            String filepath = (String)moduleNode.attribute((Object)"filepath");
            this.modulePaths.add(this.pathFactory.path(fileurl, filepath));
        }
    }

    private void loadWildcards() {
        List<Node> wildcardsNodes = Project.getChildren(this.findCompilerConfiguration(), "wildcardResourcePatterns");
        for (Node wildcardsNode : wildcardsNodes) {
            for (Node entry : Project.getChildren(wildcardsNode, "entry")) {
                this.wildcards.add((String)entry.attribute((Object)"name"));
            }
        }
    }

    private void loadJdk() {
        Node projectRoot = this.findProjectRootManager();
        boolean assertKeyword = Boolean.parseBoolean((String)projectRoot.attribute((Object)"assert-keyword"));
        boolean jdk15 = Boolean.parseBoolean((String)projectRoot.attribute((Object)"jdk-15"));
        String languageLevel = (String)projectRoot.attribute((Object)"languageLevel");
        String jdkName = (String)projectRoot.attribute((Object)"project-jdk-name");
        this.jdk = new Jdk(assertKeyword, jdk15, languageLevel, jdkName);
    }

    private void loadProjectLibraries() {
        Node libraryTable = this.findOrCreateLibraryTable();
        for (Node library : Project.getChildren(libraryTable, "library")) {
            ProjectLibrary projectLibrary = new ProjectLibrary();
            projectLibrary.setName((String)library.attribute((Object)"name"));
            projectLibrary.setClasses(this.collectRootUrlAsFiles(Project.getChildren(library, "CLASSES")));
            projectLibrary.setJavadoc(this.collectRootUrlAsFiles(Project.getChildren(library, "JAVADOC")));
            projectLibrary.setSources(this.collectRootUrlAsFiles(Project.getChildren(library, "SOURCES")));
            this.projectLibraries.add(projectLibrary);
        }
    }

    private Set<File> collectRootUrlAsFiles(List<Node> nodes) {
        LinkedHashSet files = Sets.newLinkedHashSet();
        for (Node node : nodes) {
            for (Node root : Project.getChildren(node, "root")) {
                String url = (String)root.attribute((Object)"url");
                files.add(new File(url));
            }
        }
        return files;
    }

    private void storeModulePaths() {
        Node modulesNode = new Node(null, (Object)"modules");
        for (Path modulePath : this.modulePaths) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("fileurl", modulePath.getUrl());
            attributes.put("filepath", modulePath.getRelPath());
            modulesNode.appendNode((Object)"module", (Map)attributes);
        }
        this.findOrCreateModules().replaceNode(modulesNode);
    }

    private void storeWildcards() {
        Node compilerConfigNode = this.findCompilerConfiguration();
        Node existingNode = Project.findOrCreateFirstChildNamed(compilerConfigNode, "wildcardResourcePatterns");
        Node wildcardsNode = new Node(null, (Object)"wildcardResourcePatterns");
        for (String wildcard : this.wildcards) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("name", wildcard);
            wildcardsNode.appendNode((Object)"entry", (Map)attributes);
        }
        existingNode.replaceNode(wildcardsNode);
    }

    private void storeJdk() {
        Node projectRoot = this.findProjectRootManager();
        Project.setNodeAttribute(projectRoot, "assert-keyword", this.jdk.isAssertKeyword());
        Project.setNodeAttribute(projectRoot, "assert-jdk-15", this.jdk.isJdk15());
        Project.setNodeAttribute(projectRoot, "languageLevel", this.jdk.getLanguageLevel());
        Project.setNodeAttribute(projectRoot, "project-jdk-name", this.jdk.getProjectJdkName());
    }

    private void storeBytecodeLevels() {
        Node bytecodeLevelConfiguration = this.findOrCreateBytecodeLevelConfiguration();
        Project.setNodeAttribute(bytecodeLevelConfiguration, "target", this.bytecodeVersion.toString());
        for (IdeaModule module : this.modules) {
            List<Node> bytecodeLevelModules = Project.getChildren(bytecodeLevelConfiguration, "module");
            Node moduleNode = Project.findFirstWithAttributeValue(bytecodeLevelModules, "name", module.getName());
            JavaVersion moduleBytecodeVersionOverwrite = module.getTargetBytecodeVersion();
            if (moduleBytecodeVersionOverwrite == null) {
                if (moduleNode == null) continue;
                bytecodeLevelConfiguration.remove(moduleNode);
                continue;
            }
            if (moduleNode == null) {
                moduleNode = bytecodeLevelConfiguration.appendNode((Object)"module");
                Project.setNodeAttribute(moduleNode, "name", module.getName());
            }
            Project.setNodeAttribute(moduleNode, "target", moduleBytecodeVersionOverwrite.toString());
        }
    }

    private void storeVcs() {
        if (!Strings.isNullOrEmpty((String)this.vcs)) {
            Project.setNodeAttribute(this.findVcsDirectoryMappings(), "vcs", this.vcs);
        }
    }

    private void storeProjectLibraries() {
        Node libraryTable = this.findOrCreateLibraryTable();
        if (this.projectLibraries.isEmpty()) {
            this.getXml().remove(libraryTable);
            return;
        }
        libraryTable.setValue((Object)new NodeList());
        for (ProjectLibrary library : this.projectLibraries) {
            library.addToNode(libraryTable, this.pathFactory);
        }
    }

    private Node findProjectRootManager() {
        return Project.findFirstWithAttributeValue(Project.getChildren(this.getXml(), "component"), "name", "ProjectRootManager");
    }

    private Node findOrCreateModules() {
        Node moduleManager = Project.findFirstWithAttributeValue(Project.getChildren(this.getXml(), "component"), "name", "ProjectModuleManager");
        Preconditions.checkNotNull((Object)moduleManager);
        Node modules = Project.findFirstChildNamed(moduleManager, "modules");
        if (modules == null) {
            modules = moduleManager.appendNode((Object)"modules");
        }
        return modules;
    }

    private Node findCompilerConfiguration() {
        return Project.findFirstWithAttributeValue(Project.getChildren(this.getXml(), "component"), "name", "CompilerConfiguration");
    }

    private Node findOrCreateBytecodeLevelConfiguration() {
        Node compilerConfiguration = this.findCompilerConfiguration();
        if (compilerConfiguration == null) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("name", "CompilerConfiguration");
            compilerConfiguration = this.getXml().appendNode((Object)"component", (Map)attributes);
        }
        return Project.findOrCreateFirstChildNamed(compilerConfiguration, "bytecodeTargetLevel");
    }

    private Node findVcsDirectoryMappings() {
        Node vcsDirMappings = Project.findFirstWithAttributeValue(Project.getChildren(this.getXml(), "component"), "name", "VcsDirectoryMappings");
        return Project.findFirstChildNamed(vcsDirMappings, "mapping");
    }

    private Node findOrCreateLibraryTable() {
        Node libraryTable = Project.findFirstWithAttributeValue(Project.getChildren(this.getXml(), "component"), "name", "libraryTable");
        if (libraryTable == null) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("name", "libraryTable");
            libraryTable = this.getXml().appendNode((Object)"component", (Map)attributes);
        }
        return libraryTable;
    }

    private static void setNodeAttribute(Node node, String key, Object value) {
        Map attributes = (Map)Cast.uncheckedCast((Object)node.attributes());
        attributes.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equal((Object)this.jdk, (Object)project.jdk) && Objects.equal(this.modulePaths, project.modulePaths) && Objects.equal(this.projectLibraries, project.projectLibraries) && Objects.equal(this.wildcards, project.wildcards) && Objects.equal((Object)this.vcs, (Object)project.vcs);
    }

    public int hashCode() {
        int result = this.modulePaths != null ? this.modulePaths.hashCode() : 0;
        result = 31 * result + (this.wildcards != null ? this.wildcards.hashCode() : 0);
        result = 31 * result + (this.projectLibraries != null ? this.projectLibraries.hashCode() : 0);
        result = 31 * result + (this.jdk != null ? this.jdk.hashCode() : 0);
        result = 31 * result + (this.vcs != null ? this.vcs.hashCode() : 0);
        return result;
    }
}

