/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.kotlin.dsl.support.ClassBytesRepository;
import org.gradle.kotlin.dsl.support.ClassBytesRepositoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0007\u001a&\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0007\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0006*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n*4\b\u0002\u0010\u0019\"\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u0001`\u001b0\u001a2\u001c\u0012\u0004\u0012\u00020\u0001\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cj\u0004\u0018\u0001`\u001b0\u001a*\u0018\b\u0002\u0010\u001e\"\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a8\u0006\u001f"}, d2={"classFileExtension", "", "compilerGeneratedClassFilePath", "Lkotlin/text/Regex;", "slashOrDollar", "isClassFilePath", "", "(Ljava/lang/String;)Z", "isClassPathArchive", "Ljava/io/File;", "(Ljava/io/File;)Z", "candidateClassFiles", "Lkotlin/sequences/Sequence;", "path", "classFilePathCandidatesFor", "sourceName", "classPathBytesRepositoryFor", "Lorg/gradle/kotlin/dsl/support/ClassBytesRepository;", "classPath", "", "classPathDependencies", "kotlinSourceNameOf", "classFilePath", "nestedClassFilePathCandidatesFor", "nestedClassNameFor", "ClassBytesIndex", "Lkotlin/Function1;", "Lorg/gradle/kotlin/dsl/support/ClassBytesSupplier;", "Lkotlin/Function0;", "", "ClassBytesSupplier", "kotlin-dsl"})
public final class ClassBytesRepositoryKt {
    private static final String classFileExtension = ".class";
    private static final Regex compilerGeneratedClassFilePath = new Regex(".*\\$\\d+\\.class$");
    private static final Regex slashOrDollar = new Regex("[/$]");

    @VisibleForTesting
    @NotNull
    public static final ClassBytesRepository classPathBytesRepositoryFor(@NotNull List<? extends File> classPath, @NotNull List<? extends File> classPathDependencies) {
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter(classPathDependencies, (String)"classPathDependencies");
        ClassPath classPath2 = DefaultClassPath.of((Collection)classPath);
        Intrinsics.checkNotNullExpressionValue((Object)classPath2, (String)"DefaultClassPath.of(classPath)");
        ClassPath classPath3 = DefaultClassPath.of((Collection)classPathDependencies);
        Intrinsics.checkNotNullExpressionValue((Object)classPath3, (String)"DefaultClassPath.of(classPathDependencies)");
        return new ClassBytesRepository(classPath2, classPath3);
    }

    public static /* synthetic */ ClassBytesRepository classPathBytesRepositoryFor$default(List list2, List list3, int n, Object object) {
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        return ClassBytesRepositoryKt.classPathBytesRepositoryFor(list2, list3);
    }

    private static final boolean isClassPathArchive(File $this$isClassPathArchive) {
        String string2 = FilesKt.getExtension((File)$this$isClassPathArchive);
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string2;
        boolean bl3 = false;
        return StringsKt.equals((String)$this$run, (String)"jar", (boolean)true) || StringsKt.equals((String)$this$run, (String)"zip", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassFilePath(String $this$isClassFilePath) {
        if (!StringsKt.endsWith$default((String)$this$isClassFilePath, (String)classFileExtension, (boolean)false, (int)2, null)) return false;
        if (StringsKt.endsWith$default((String)$this$isClassFilePath, (String)"package-info.class", (boolean)false, (int)2, null)) return false;
        CharSequence charSequence = $this$isClassFilePath;
        Regex regex = compilerGeneratedClassFilePath;
        boolean bl = false;
        if (regex.matches(charSequence)) return false;
        return true;
    }

    @VisibleForTesting
    @NotNull
    public static final String kotlinSourceNameOf(@NotNull String classFilePath) {
        Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
        CharSequence charSequence = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)classFilePath, (CharSequence)classFileExtension), (CharSequence)"Kt");
        Regex regex = slashOrDollar;
        String string2 = ".";
        boolean bl = false;
        return regex.replace(charSequence, string2);
    }

    @VisibleForTesting
    @NotNull
    public static final Sequence<String> classFilePathCandidatesFor(@NotNull String sourceName) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        String string2 = StringsKt.replace$default((String)sourceName, (String)".", (String)"/", (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String path2 = string2;
        boolean bl3 = false;
        return SequencesKt.plus(ClassBytesRepositoryKt.candidateClassFiles(path2), ClassBytesRepositoryKt.nestedClassFilePathCandidatesFor(path2));
    }

    private static final Sequence<String> nestedClassFilePathCandidatesFor(String path2) {
        return SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(path2){
            final /* synthetic */ String $path;

            @Nullable
            public final String invoke() {
                return ClassBytesRepositoryKt.access$nestedClassNameFor(this.$path);
            }
            {
                this.$path = string2;
                super(0);
            }
        }), (Function1)nestedClassFilePathCandidatesFor.2.INSTANCE), (Function1)nestedClassFilePathCandidatesFor.3.INSTANCE);
    }

    private static final Sequence<String> candidateClassFiles(String path2) {
        return SequencesKt.sequenceOf((Object[])new String[]{path2 + classFileExtension, path2 + "Kt.class"});
    }

    private static final String nestedClassNameFor(String path2) {
        String string2;
        String string3 = path2;
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string3;
        boolean bl3 = false;
        Integer n = StringsKt.lastIndexOf$default((CharSequence)$this$run, (char)'/', (int)0, (boolean)false, (int)6, null);
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = it > 0 ? n : null;
        if (n2 != null) {
            n = n2;
            bl4 = false;
            bl5 = false;
            int index = ((Number)n).intValue();
            boolean bl7 = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = $this$run;
            int n3 = 0;
            boolean bl8 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n3, index);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string6).append('$');
            string4 = $this$run;
            n3 = index + 1;
            bl8 = false;
            String string7 = string4;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string8).toString();
        } else {
            string2 = null;
        }
        return string2;
    }

    public static final /* synthetic */ boolean access$isClassPathArchive$p(File $this$access_u24isClassPathArchive_u24p) {
        return ClassBytesRepositoryKt.isClassPathArchive($this$access_u24isClassPathArchive_u24p);
    }

    public static final /* synthetic */ boolean access$isClassFilePath$p(String $this$access_u24isClassFilePath_u24p) {
        return ClassBytesRepositoryKt.isClassFilePath($this$access_u24isClassFilePath_u24p);
    }

    public static final /* synthetic */ String access$nestedClassNameFor(String path2) {
        return ClassBytesRepositoryKt.nestedClassNameFor(path2);
    }

    public static final /* synthetic */ Sequence access$candidateClassFiles(String path2) {
        return ClassBytesRepositoryKt.candidateClassFiles(path2);
    }
}

