/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoInitializationException;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;

public final class CollectionComponentParameter
implements Parameter {
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class<?> componentKeyType;
    private final Class<?> componentValueType;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean emptyCollection) {
        this(Void.TYPE, emptyCollection);
    }

    public CollectionComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(Object.class, componentValueType, emptyCollection);
    }

    public CollectionComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this.emptyCollection = emptyCollection;
        this.componentKeyType = componentKeyType;
        this.componentValueType = componentValueType;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        Object result2 = null;
        Class collectionType = CollectionComponentParameter.getCollectionType(expectedType2);
        if (collectionType != null) {
            Map<Object, ComponentAdapter> adapterMap = CollectionComponentParameter.getMatchingComponentAdapters(container, adapter, this.componentKeyType, this.getValueType(expectedType2));
            if (Array.class.isAssignableFrom(collectionType)) {
                result2 = CollectionComponentParameter.getArrayInstance(container, expectedType2, adapterMap);
            } else if (Map.class.isAssignableFrom(collectionType)) {
                result2 = CollectionComponentParameter.getMapInstance(container, expectedType2, adapterMap);
            } else if (Collection.class.isAssignableFrom(collectionType)) {
                result2 = CollectionComponentParameter.getCollectionInstance(container, expectedType2, adapterMap);
            } else {
                throw new PicoIntrospectionException(expectedType2.getName() + " is not a collective type");
            }
        }
        return result2;
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        Class collectionType = CollectionComponentParameter.getCollectionType(expectedType2);
        Class valueType = this.getValueType(expectedType2);
        return collectionType != null && (this.emptyCollection || CollectionComponentParameter.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).size() > 0);
    }

    private static Map<Object, ComponentAdapter> getMatchingComponentAdapters(PicoContainer container, ComponentAdapter adapter, Class<?> keyType, Class<?> valueType) {
        LinkedHashMap<Object, ComponentAdapter> adapterMap = new LinkedHashMap<Object, ComponentAdapter>();
        PicoContainer parent2 = container.getParent();
        if (parent2 != null) {
            adapterMap.putAll(CollectionComponentParameter.getMatchingComponentAdapters(parent2, adapter, keyType, valueType));
        }
        Collection<ComponentAdapter> allAdapters = container.getComponentAdapters();
        Iterator<ComponentAdapter> iterator2 = allAdapters.iterator();
        while (iterator2.hasNext()) {
            ComponentAdapter allAdapter;
            ComponentAdapter componentAdapter = allAdapter = iterator2.next();
            adapterMap.remove(componentAdapter.getComponentKey());
        }
        List<ComponentAdapter> adapterList = container.getComponentAdaptersOfType(valueType);
        Iterator<ComponentAdapter> iterator3 = adapterList.iterator();
        while (iterator3.hasNext()) {
            ComponentAdapter o;
            ComponentAdapter componentAdapter = o = iterator3.next();
            Object key = componentAdapter.getComponentKey();
            if (adapter != null && key.equals(adapter.getComponentKey()) || !keyType.isAssignableFrom(key.getClass())) continue;
            adapterMap.put(key, componentAdapter);
        }
        return adapterMap;
    }

    private static Class getCollectionType(Class collectionType) {
        Class collectionClass = null;
        if (collectionType.isArray()) {
            collectionClass = Array.class;
        } else if (Map.class.isAssignableFrom(collectionType)) {
            collectionClass = Map.class;
        } else if (Collection.class.isAssignableFrom(collectionType)) {
            collectionClass = Collection.class;
        }
        return collectionClass;
    }

    private Class getValueType(Class collectionType) {
        Class<?> valueType = this.componentValueType;
        if (collectionType.isArray()) {
            valueType = collectionType.getComponentType();
        }
        return valueType;
    }

    private static Object[] getArrayInstance(PicoContainer container, Class expectedType2, Map adapterList) {
        Object[] result2 = (Object[])Array.newInstance(expectedType2.getComponentType(), adapterList.size());
        int i = 0;
        for (Object o : adapterList.values()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)o;
            result2[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            ++i;
        }
        return result2;
    }

    private static Collection getCollectionInstance(PicoContainer container, Class<?> expectedType2, Map<Object, ComponentAdapter> adapterList) {
        Class<Object> collectionType = expectedType2;
        if (collectionType.isInterface()) {
            if (List.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            } else if (SortedSet.class.isAssignableFrom(collectionType)) {
                collectionType = TreeSet.class;
            } else if (Set.class.isAssignableFrom(collectionType)) {
                collectionType = HashSet.class;
            } else if (Collection.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            }
        }
        try {
            Collection result2 = (Collection)collectionType.newInstance();
            for (ComponentAdapter o : adapterList.values()) {
                result2.add(container.getComponentInstance(o.getComponentKey()));
            }
            return result2;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    private static Map getMapInstance(PicoContainer container, Class<?> expectedType2, Map<Object, ComponentAdapter> adapterList) {
        Class<Object> collectionType = expectedType2;
        if (collectionType.isInterface()) {
            if (SortedMap.class.isAssignableFrom(collectionType)) {
                collectionType = TreeMap.class;
            } else if (Map.class.isAssignableFrom(collectionType)) {
                collectionType = HashMap.class;
            }
        }
        try {
            Map result2 = (Map)collectionType.newInstance();
            for (Object key : adapterList.keySet()) {
                result2.put(key, container.getComponentInstance(key));
            }
            return result2;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }
}

