/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import net.claribole.zvtm.lens.FixedSizeLens;

public class FSStepLens
extends FixedSizeLens {
    int nbSteps = 5;
    int[] Ri;
    float[] Ai;
    float[] Bi;
    double d = 0.0;

    public FSStepLens() {
        this.MM = 2.0f;
        this.updateMagBufferWorkingDimensions();
        this.nbSteps = 2;
        this.Ri = new int[this.nbSteps];
        this.Ai = new float[this.nbSteps];
        this.Bi = new float[this.nbSteps];
        this.updateSteps();
    }

    public FSStepLens(float mm, int ns) {
        this.MM = mm;
        this.updateMagBufferWorkingDimensions();
        this.nbSteps = ns * 2 + 1;
        this.Ri = new int[this.nbSteps];
        this.Ai = new float[this.nbSteps];
        this.Bi = new float[this.nbSteps];
        this.updateSteps();
    }

    public FSStepLens(float mm, int outerRadius, int innerRadius, int ns) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.nbSteps = ns * 2 + 1;
        this.Ri = new int[this.nbSteps];
        this.Ai = new float[this.nbSteps];
        this.Bi = new float[this.nbSteps];
        this.updateSteps();
    }

    public FSStepLens(float mm, int outerRadius, int innerRadius, int ns, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.nbSteps = ns * 2 + 1;
        this.Ri = new int[this.nbSteps];
        this.Ai = new float[this.nbSteps];
        this.Bi = new float[this.nbSteps];
        this.updateSteps();
        this.lx = x;
        this.ly = y;
    }

    void updateSteps() {
        float stepRadius = (float)(this.LR1 - this.LR2) / (float)this.nbSteps;
        float stepMM = (this.MM - 1.0f) / ((float)(this.nbSteps - 1) / 2.0f + 1.0f);
        boolean flat = false;
        float lMM = this.MM;
        float lR = this.LR2;
        for (int i = 0; i < this.Ri.length; ++i) {
            this.Ri[i] = this.LR2 + Math.round((float)(i + 1) * stepRadius);
            if (flat) {
                this.Ai[i] = 0.0f;
                this.Bi[i] = lMM;
            } else {
                this.Ai[i] = -stepMM / stepRadius;
                this.Bi[i] = lMM + lR * stepMM / stepRadius;
                lMM -= stepMM;
            }
            lR += stepRadius;
            flat = !flat;
        }
    }

    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.updateSteps();
    }

    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.updateSteps();
    }

    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.updateSteps();
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.updateSteps();
    }

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.updateSteps();
    }

    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            for (int i = 0; i < this.Ri.length; ++i) {
                if (!(this.d <= (double)this.Ri[i])) continue;
                g[0] = g[1] = this.Ai[i] * (float)this.d + this.Bi[i];
                break;
            }
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }
}

