set doc_section Internal

doc add "How To/Use Help" "For various information about performing certain tasks, consult the How To section.

If you would like to expand your knowledge of QuIRC or find tidbits of useful information, check out the Tips section.

The other sections are divided into two types, server and global.  The global sections are applicable anywhere, even if a server window isn't open.  The server sections apply to a single server only, the one that's currently active, or the one that an event is received from.
"

doc add "How To/Add a Popup Menu Item" "FIXME"

doc add "How To/Create an Alias" "FIXME"

doc add "How To/Deal with Themes" "FIXME"

doc add "How To/Add a Nick to your Notify List" "If you want to be notified when a particular nick comes online, you can add them to your notify list.  There are a couple ways of doing so.

The first is via the GUI configuration tool.  Run /config or choose \"Configuration System\" from the Menu.  Then, scroll down to notify_list.  Add any nicks you want, seperated with spaces, and then hit the Set button.  If you want to save your settings for the next time you use QuIRC, also hit the Save button.

Alternatively, you can add to the notify list from the command line by doing:

    /append notify_list <nick>

To store your settings for future use, use:

    /store

To remove nicks, go to the configuration system, remove them from the list, hit Set, and optionally hit Save."


doc add "Tips/Calculator" "For quick calculation or evaluation of scripts, try:

    /calc 4*8+10
    /calc \[info patchlevel]
"

doc add "Events (Global)/event_client_start" "event_client_start

This event is called after all of the normal initialization has occured.  It will not be called if the first_time variable is set."

doc add "Events (Global)/event_echo" "event_echo <message> <pathname> <new>

This event is called everytime text is to be echoed.  You must return the text that you actually want to be echoed.  If you return nothing, it will not echo anything.  You can use echotags from within this proc for very customized echoing.  The pathname parameter indicates which window the message is being echoed to.  The new parameter indicates whether or not the window list should light up indicating there is new text."

doc add "Events (Global)/event_first_time" "event_first_time

This event is called when the client is started if the first_time variable is set."

doc add "Events (Global)/event_windowchanged" "event_windowchanged <old_pathname> <old_name> <old_server> <old_index> <pathname> <name> <server> <index>

This Is called whenever the user switches windows.  The pathname parameters are the internal window reference names.  The names are the names displayed in the window list.  The server parameters are the indexes of the servers.  The index parameters are the indexes of the window list items in the window list itself.  The old parameters are those before the change, the others are those after the change."

doc add "Procedures (Global)/$doc_section/activebutton" "activebutton <windowindex>

Makes the window list item windowindex colored indicating there is new text in that window."

doc add "Procedures (Global)/$doc_section/alias" "alias <name> <script>

Creates an alias with the given name in the appropriate namespace.  Using this command more than once with the same name in the same namespace will cause the previous version to be overwritten."

doc add "Procedures (Global)/$doc_section/bgerror" "bgerror \[<message>\]

The internal implementation of the tcl bgerror procedure.  Called to report errors."

doc add "Procedures (Global)/$doc_section/callproc" "callproc <procname> <args> <serverindex>

Calls procname with the first argument being serverindex and the rest of the arguments being the arguments contained in the list args.  It is used internally by QuIRC in order to set up the ::template::name functions."

doc add "Procedures (Global)/$doc_section/channel" "channel

Returns the current channel name, or \"\" if there is none."

doc add "Procedures (Global)/$doc_section/closewindow" "closewindow <pathname>

Closes the given window in the same manner as the close button does.  It sends part messages or disconnects from servers as needed."

doc add "Procedures (Global)/$doc_section/configtags" "configtags <pathname> <normal> <bold>

Configures the tags, for colors, bold, underline, in the given text window with the given fonts for normal and bold text.  The tags will come out with the format 'fg,bgbu' where fg is the foreground color between 0 and 15, bg is the background color between 0 and 15, b is a part of the tag if the text should be bold, and u is a part of the tag if the text should be underlined."

doc add "Procedures (Global)/$doc_section/connect" "connect \[<severindex>\]

Connect either the currently active server or the given server."

doc add "Procedures (Global)/$doc_section/currentindex" "currentindex

Returns the index of the current server or -1 if there isn't one."

doc add "Procedures (Global)/$doc_section/currentwindow" "currentwindow

Returns the pathname to the current window."

doc add "Procedures (Global)/$doc_section/die" "die

The renamed tcl exit command."

doc add "Procedures (Global)/$doc_section/disconnect" "disconnect \[<serverindex>\]

Disconnects either the currently active server or the given server."

doc add "Procedures (Global)/$doc_section/domainloop" "domainloop

Is called at the start of the client and handles an event loop internal to QuIRC that works within the main Tk event loop.  This will probably not be changed or used by users but I stuck it here just cause it's a tcl proc created by QuIRC."

doc add "Procedures (Global)/$doc_section/echo" "echo <text> \[<pathname(s)>\] \[<new>\]

Prints text (including colors) into the window(s) given by the pathname list.  If new is 1, it will make the list item for that window turn the color it turns when new text enters the window, so the user will know that there is new text in that window.  If new is 0, it will not change the color of the list item.  If pathname is not specified then it will use the current window.  If new is not specified then it will assume you want the list to change colors."

doc add "Procedures (Global)/$doc_section/echotags" "echotags <text/tags> \[<pathname(s)>\] \[<new>\]

Is similar to echo only the text/tags argument is a list of text/tag pairs, for example: {\"hi \" 4,0 there 7,8} produces a hideous looking set of color output.  No newline is inserted.  echotags does no color parsing, but relies on the tag values themselves.  If you want parsed tags to pass to echotags, you can use gettags. The color tags are of the form: FG,BG\[b\]\[u\] Which produce text with the given foreground and background colors (between 0 and 15) and if you include the letters b or u, or both, the text will be underlined or bold.  event_echo is not called from within echotags, so it can be safely used from within an event_echo.  echotags scrolls the text up as well, except for when text is inserted into the current window and the scrollbar is not at the bottom of the window."

doc add "Procedures (Global)/$doc_section/escape" "escape <data>

Returns the escaped version of the given data."

doc add "Procedures (Global)/$doc_section/exit" "exit

Runs shutdown then the die command."

doc add "Procedures (Global)/$doc_section/fdisplay" "fdisplay <type> \[<argument> \[<argument> ...\]\]

Displays the previously fset type, filling in the given arguments.  Can only use global flocation types."

doc add "Procedures (Global)/$doc_section/fgetformat" "fgetformat <type>

type
    The fset format type.

This procedure returns the format string for the given fset format type.  See fset for more details."

doc add "Procedures (Global)/$doc_section/fgetpathnames" "fgetpathnames <type> \[<argument> \[<argument> ...]]

type
    The fset format type.

This procedure is invoked in the same manner as fparse.  It returns a list of pathnames when given a type and the associated arguments.  If no location was set, the main status window pathname (.main) is returned.  There is a server version of this procedure as well."

doc add "Procedures (Global)/$doc_section/flocation" "flocation <type> \[<argument>\]

Is used with the fset statement as a convenient method to set the location of where the message will be displayed.  % is the argument number to be used as passed to fparse.

        Global Types       Destination
        main               Main Status
        current            Current window
        all                Every window
        none               Nowhere (Not displayed or flocation field ignored)

        Server Types       Destination
        currentorstatus    If the message is from the currently visible server, it will be displayed in the current window.  Otherwise, it will be displayed in the status window of the server it originated from.
        status             Status window (server window)
        serverall          All windows belonging to the originating server.
        files              The DCC files window of the originating server.
        onchannel %        If you are on %, the message will be displayed in that window.
        channelorstatus %  The % window if you are on that channel, otherwise it will be placed in the status window.
        pathname %         The window with the pathname of %.
        chat %             The DCC window where % is the =nick or nick."

doc add "Procedures (Global)/$doc_section/fparse" "fparse <type> \[<argument> \[<argument> ...\]\]

Returns the filled in format for the given type and arguments.  See fset for more details.  Can only use global flocation types."

doc add "Procedures (Global)/$doc_section/fset" "fset <type> <format> \[<location> \[<new>]]

This is used to set various formats used throughout the client and can be used for a variety of output tasks.  The type is an arbitrary name for the type, usually in all capitals.  The format is a string that indicates the format of the message.  The format will be evaluated as TCL before it is displayed, so it must be legal TCL.  As well, the format can contain special characters which will be replaced with arguments.  %0 is the first argument, %1 is the second argument, %2- is everything past and including the third argument.  %-3 is the first three arguments.  %- is all the arguments.  %% is used to represent a literal %.  If you want to insert a literal character after %X combo without having it be interpreted, you can insert a \\ in there, which will be evaluated out when it is evaluated as a tcl statement.  (Use \\\\ if your format is in quotes.) The location is something returned by an flocation command.  New changes whether or not that particular output activates the window list when it is displayed, same as echo."

doc add "Procedures (Global)/$doc_section/gettags" "gettags <text> \[<pathname>\]

Given text with control codes, it returns a list of text/tag pairs that is acceptable to echotags.  The pathname is necessary to determine which default colors to use.  If no pathname is given, the current window will be used."

doc add "Procedures (Global)/$doc_section/hist" "hist

Lists the current command history information."

doc add "Procedures (Global)/$doc_section/histdown" "histdown

Sets the command line to the next entry in the history list."

doc add "Procedures (Global)/$doc_section/histup" "histup

Sets the command line to the previous entry in the history list."

doc add "Procedures (Global)/$doc_section/ic" "ic <color number> <window type>

Fills up a color value using the given information.  If the color number does not have a comma in it, the background color for the given window type will be inserted.  If there is a comma, the portion after the comma will be packed with zeros, producing exactly two digits.  If the color is blank, the default colors will be filled in."

doc add "Procedures (Global)/$doc_section/idle" "idle

Returns the number of seconds since parseentry was last called.  This is used within the CTCP FINGER reply."

doc add "Procedures (Global)/$doc_section/index" "index

Returns -1, representing the fact that the script is executing in the global namespace.  This command is intended to be used in combination with the server based index command to figure out where the current script is executing."

doc add "Procedures (Global)/$doc_section/ischannel" "ischannel <test>

Returns true if test is a channel, false if not.  (Checks for #,&,+)"

doc add "Procedures (Global)/$doc_section/microtime" "microtime

Returns the time as a floating point number with microseconds taken into account."

doc add "Procedures (Global)/$doc_section/n_complete" "n_complete

Is called to do \"nick\" complete when the tab key is pressed."

doc add "Procedures (Global)/$doc_section/newserver" "newserver \[<server>\[:\[<port>\]\[:<password>\]\]\]

Starts a new server using the given server, and port if specified.  If no port is specified, uses the default_port.  If no server is specified, it uses the default_server.  It returns the index of the server created."

doc add "Procedures (Global)/$doc_section/nextwindow" "nextwindow

Makes the next window in the window list active."

doc add "Procedures (Global)/$doc_section/parseentry" "parseentry <pathname>

This proc is called when text is entered from a window and the pathname of that window is passed in.  It then sends info to the server or passes it to the command handler as appropriate."

doc add "Procedures (Global)/$doc_section/popup" "popup add item <type> <submenu> <title> <command>
popup add submenu <type> <submenu> <title>
popup clear <type> <submenu>

This is the global version of the popup command.  There is also a server-specific version.  This command is used to manipulate the various popup menus available.

<type> is one of the following (erroneous types will be ignored): 
    maintext  
    mainentry 

<submenu> is the submenu this entry will be placed in.  It should either be \"\" for no submenu, or it should start with a \".\", such as \".mysub\" or \".mysub1.mysub2\"  Submenus must be children of their parent menus.

<title> is the name for the menu item.

<command> is the tcl code to run when the item is picked.  It will be run within the global namespace.

COMMAND VARIATIONS

popup add item <type> <submenu> <title> <command>
    Adds an item to the given menu.

popup add submenu <type> <submenu> <title>
    Creates a submenu.

popup clear <type> <submenu>
    Clears the given menu with paramters the same as popup add."

doc add "Procedures (Global)/$doc_section/previouswindow" "previouswindow

Makes the previous window in the window list active."

doc add "Procedures (Global)/$doc_section/renamewindow" "renamewindow <pathname> <new name>

Renames the window specified by the pathname to the given new name.  It returns the window index of the new window."

doc add "Procedures (Global)/$doc_section/say" "say <message> \[<target pathname>\]

Sends a normal message to the given channel/query/dcc.  If the target is not provided, it will be sent to the current window."

doc add "Procedures (Global)/$doc_section/servers" "servers

Returns a list of the server indexes currently open."

doc add "Procedures (Global)/$doc_section/selectednicks" "selectednicks

Returns the list of nicks that are currently selected in the nicklist.  If it can't find any, it simply returns nothing."

doc add "Procedures (Global)/$doc_section/serverindex" "serverindex <pathname>

Returns the server index for the given pathname, or -1 if the pathname refers to the Main Status window or doesn't exist."

doc add "Procedures (Global)/$doc_section/shutdown" "shutdown

Performs any needed shutdown functions.  Is called by exit before it calls die."

doc add "Procedures (Global)/$doc_section/title" "title <pathname> \[<text>\]

Sets the title for the given pathname to the given text.  If no text is specified, it returns the current title for the given pathname."

doc add "Procedures (Global)/$doc_section/totop" "totop <windowindex>

Brings the given window to the top.  The index is the same as the order of the window list starting at 0.  This is called when a window is clicked on in the window list or when a window is opened or closed.  After bringing the window to the top, it runs update to make sure all the changes it made actually occur."

doc add "Procedures (Global)/$doc_section/version" "version

Returns the current version number."

doc add "Procedures (Global)/$doc_section/windowindex" "windowindex \[<pathname>\]

Returns the window index for the given pathname, or the window index for the current window if the pathname is not given."

doc add "Procedures (Global)/$doc_section/windowname" "windowname \[<pathname>\]

Returns the window name for the given pathname, or the window name for the current window if the pathname is not given."

doc add "Procedures (Global)/$doc_section/windows" "windows

Returns a Tcl list of the pathnames of all open windows."

doc add "Procedures (Global)/$doc_section/windowtype" "windowtype <pathname>

Returns the window type for a given pathname.  It will be one of either main, status, files, channel, query, or chat."


### Server Procedures ###

doc add "Procedures (Server)/$doc_section/acceptlist" "acceptlist add chat <nick> <psuedo-ip> <port>

    Adds the chat to a list of chats that need accepted.  The parameters are the same as the CTCP DCC CHAT arguments.

acceptlist add send <nick> <psuedo-ip> <port> <filename> \[<size>\]

    Adds the file to the accept list with the same parameters as the CTCP DCC CHAT arguments.

acceptlist accept <idtag>

    Accepts the given session.

acceptlist overwrite <idtag>

    Accepts the given session and overwrites the existing file.

acceptlist rename <idtag> <filename>

    Accepts the given session and renames the file.

acceptlist reject <idtag>

    Rejects the given session."

doc add "Procedures (Server)/$doc_section/channelmode" "channelmode <mode letter> <channel>

Returns 0 or 1 whether the given mode is set for the given channel. If the mode letter is l, it will either return 0 or the limit for the channel. If the mode letter is k, it will either return \"\" or the key for the channel."

doc add "Procedures (Server)/$doc_section/channels" "channels

Returns a TCL list of all the channels currently on the server (joined or not)."

doc add "Procedures (Server)/$doc_section/connected" "connected

Returns 1 if connected, 0 if not."

doc add "Procedures (Server)/$doc_section/createchannel" "createchannel <channel>

Creates a new channel window and performs all the neccessary internal actions to set that window up.  If the window already exists it does nothing."

doc add "Procedures (Server)/$doc_section/createquery" "createquery <nick>

Creates a new query window and performs all the neccessary internal actions to set that window up.  If the window already exists it does nothing."

doc add "Procedures (Server)/$doc_section/dcc" "dcc <type> <nick> \[<filename>\]

Initiates a DCC session.

<type> can be either chat or send.  If you use send you need to specify the filename.  If you need the DCC to send a different IP than is automatically detected, then set the global tcl variable dcc_localip, for example:

    /evalglobal set dcc_localip 10.0.0.2 

If you send a file with spaces in the name, the spaces will be converted to underlines in order to send the CTCP DCC request."

doc add "Procedures (Server)/$doc_section/dccquote" "dccquote \[=\]<nick> <message>

Sends the given message to the dcc session specified by the given nick."

doc add "Procedures (Server)/$doc_section/disconnect" "disconnect

Disconnects from the IRC server."

doc add "Procedures (Server)/$doc_section/fdisplay" "fdisplay <type> \[<argument> \[<argument> ...\]\]

Displays the previously fset type, filling in the given arguments.  Can use global or server specific locations."

doc add "Procedures (Server)/$doc_section/fgetpathnames" "fgetpathnames <type> \[<argument> \[<argument> ...]]

type
    The fset format type.

This procedure is invoked in the same manner as fparse.  It returns a list of pathnames when given a type and the associated arguments.  If no location was set, the main status window pathname (.main) is returned.  There is a global version of this procedure as well."

doc add "Procedures (Server)/$doc_section/fixnicklist" "fixnicklist <channel>

On some occaisions due to the limitations of the IRC protocol, the nicklist display for voiced people will become incorrect.  This proc allows you to retrieve a new corrected nicklist from the NAMES response for the given channel."

doc add "Procedures (Server)/$doc_section/fparse" "fparse <type> \[<argument> \[<argument> ...\]\]

Returns the filled in format for the given type and arguments.  See fset for more details.  Can use global or server specific locations."

doc add "Procedures (Server)/$doc_section/index" "index

Returns the current server's index."

doc add "Procedures (Server)/$doc_section/ison" "ison <nick> <channel>

Returns 1 if nick is on channel, 0 otherwise.  Returns 0 if you are not on the given channel."

doc add "Procedures (Server)/$doc_section/isop" "isop <nick> <channel>

Returns 1 if nick in channel is oped, 0 otherwise.  Returns 0 if you are not on the given channel."

doc add "Procedures (Server)/$doc_section/isvoice" "isvoice <nick> <channel>

Returns 1 if nick in channel is voiced, 0 otherwise.  Returns 0 if you are not on the given channel."

doc add "Procedures (Server)/$doc_section/modenicks" "modenicks <channel>

Returns a TCL list of the nicks in the channel with any @ or + prefixes."

doc add "Procedures (Server)/$doc_section/modes" "modes <channel>

Returns a string showing the modes set for the given channel.  Nothing will be returned if no modes are set."

doc add "Procedures (Server)/$doc_section/mynick" "mynick

Returns the current nick on that server."

doc add "Procedures (Server)/$doc_section/nicks" "nicks <channel>

Returns a TCL list of nicks in the channel."

doc add "Procedures (Server)/$doc_section/onchannel" "onchannel <channel>

Returns 1 if you are on the channel, 0 otherwise."

doc add "Procedures (Server)/$doc_section/pathname" "pathname <type> \[<argument>\]

TYPE            ARGUMENT
status          None
files           None
channel         Channel Name
query           Query Nick
chat            DCC Chat Session Nick
guess           Channel Name, Query Nick, or DCC Nick
all             None
<something>     None

Returns the pathname associated with the given information.  Returns \"\" if it can't the appropriate information.  The pathname for the Main Status window is \".main\"  When the type is all, it returns all the pathnames under the appropriate server.

DCC Nick should have the = in front if you want to be sure to get the DCC nick instead of a query nick when using guess.  If guess can't find a channel, query, or chat session to match, it will return the pathname for the status window.

If <something> is not one of the other types, it will run guess on it.

pathname itself is a frame
pathname.text is the text box in each window
pathname.entry is the entry box in each window
pathname.text_vscroll is the scrollbar
pathname.nicks is a tk listbox for the nicks in channel windows."

doc add "Procedures (Server)/$doc_section/popup" "popup add item <type> <submenu> <title> <command>
popup add submenu <type> <submenu> <title>
popup clear <type> <submenu>

This is the server specific version of the popup command.  For information about the popup command in general, see the global popup docs.

<type> is one of the following (main* types will be ignored):
    statustext 
    statusentry 
    channelnicks 
    channeltext 
    channelentry 
    querytext 
    queryentry 
    chattext 
    chatentry 
    filetext 
    fileentry

<command> will be run within the namespace of the server.  In other words, you can add server specific commands and aliases to the script."

doc add "Procedures (Server)/$doc_section/queries" "queries

Returns a TCL list of all the nicks of the query windows open for the current server."

doc add "Procedures (Server)/$doc_section/quote" "quote <message>

Sends message to the server."

doc add "Procedures (Server)/$doc_section/script" "script <script>

Loads the script into the interpreter.  Watch the Main Status window for errors.  It loads by evaluating the script within its namespace and then adding the script to the \$::<serveridx>::scripts variable.  Be sure to use relative pathnames (to ~/.quirc/) when specifying the script.  Scripts are server specific.  The script name in the client is all alpha-numeric characters immediately following the trailing slash."

doc add "Procedures (Server)/$doc_section/server" "server \[<server>\[:\[<port>\]\[:<password>\]\]\]

Reconnects the current server using the given given server, and port if specified.  If no port is specified, uses the default_port.  If no server is specified, it uses the default_server."

doc add "Procedures (Server)/$doc_section/topic" "topic <channel>

Returns the topic set for the given channel, or nothing if there is no such topic or channel."

doc add "Procedures (Server)/$doc_section/unscript" "unscript <script>

Unloads the script from the interpreter by running the event_unload and then destroying the namespace the script is contained within.  It will also remove the script from the \$::<serveridx>::scripts variable." 

doc add "Procedures (Server)/$doc_section/userhost" "userhost <nick>

Returns the last known user@host for the given nick, or \"\" if the userhost info was not encountered for that nick.  The user@host will contain the leading ~ if there is any.  The IAL database currently never shortens itself and adds data from the prefix of any message sent to the client, userhost, who replies and nick changes."

doc add "Procedures (Server)/$doc_section/userlist" "userlist set <type info> \[<list of flag/data> \[<index>]]

type info
    Any of the following:
        {alias name}
        {simple <Mask containing ?, *, or \[chars]>}
        {regexp <Regular expression>}
    For example:
        {alias friends}
        {simple *!*@*}
        {regexp .*!.*@.*}

list of flag/data
    A list consisting of flag/data pairs or just flags.
    If the first flag does not have an explcit -/+ on it, the list will be cleared before adding or removing the given flags.
    Flags with no sign are assumed to have a + sign.
    Flags with - on them are removed from the flag list.
    If you specify a flag with no data, any previous data will be removed.

    For example:
        only_flag
        +one_more_flag
        {{+one_more_flag with_data}}
        {+another_flag -bad_flag {+yet_another_flag {with data}}}

index
    A number used to to indicate the position of an item in the list.
    0 is the first position.
    end is the last position.
    If you try inserting before the first position, or after the last one, it will adjust it to be within the possible insert range.

Sets a given type/info pair with the given flag set in the following manner:

If you specify a type/info pair that does not already exist in the list, it will by default be inserted at the beginning of the list.  If you specify an index, it will be inserted or moved to that position.

The resulting index of the inserted or changed item is returned.

If the flag list argument is omitted, the current list of flags for the item will be returned.

Examples:

To ignore everybody (inserted at end so it can be preempted by other masks, such as masks of friends):
    userlist set {simple *!*@*} +ignore end"
