/* Generated from Telepathy D-Bus Interface Specification, TelepathyQt copy, version 0.17.7 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <QtGlobal>

#include <QByteArray>
#include <QString>
#include <QStringList>
#include <QVariantList>
#include <QVariantMap>

#include <QDBusArgument>
#include <QDBusMetaType>
#include <QDBusObjectPath>
#include <QDBusSignature>
#include <QDBusVariant>

#include <TelepathyQt/Global>

/**
 * \addtogroup typesconstants Types and constants
 *
 * Enumerated, flag, structure, list and mapping types and utility constants.
 */

/**
 * \defgroup struct Structure types
 * \ingroup typesconstants
 *
 * Structure types generated from the specification.
 */

/**
 * \defgroup list List types
 * \ingroup typesconstants
 *
 * List types generated from the specification.
 */

/**
 * \defgroup mapping Mapping types
 * \ingroup typesconstants
 *
 * Mapping types generated from the specification.
 */


namespace Tp
{
/**
 * \struct ByteArrayList
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Generic list type with QByteArray elements. Convertible with
 * QList<QByteArray>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT ByteArrayList : public QList<QByteArray>
{
    inline ByteArrayList() : QList<QByteArray>() {}
    inline ByteArrayList(const QList<QByteArray>& a) : QList<QByteArray>(a) {}

    inline ByteArrayList& operator=(const QList<QByteArray>& a)
    {
        *(static_cast<QList<QByteArray>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ObjectPathList
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Generic list type with QDBusObjectPath elements. Convertible with
 * QList<QDBusObjectPath>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT ObjectPathList : public QList<QDBusObjectPath>
{
    inline ObjectPathList() : QList<QDBusObjectPath>() {}
    inline ObjectPathList(const QList<QDBusObjectPath>& a) : QList<QDBusObjectPath>(a) {}

    inline ObjectPathList& operator=(const QList<QDBusObjectPath>& a)
    {
        *(static_cast<QList<QDBusObjectPath>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct UIntList
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Generic list type with uint elements. Convertible with
 * QList<uint>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT UIntList : public QList<uint>
{
    inline UIntList() : QList<uint>() {}
    inline UIntList(const QList<uint>& a) : QList<uint>(a) {}

    inline UIntList& operator=(const QList<uint>& a)
    {
        *(static_cast<QList<uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct AccessControl
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>An access control mode for extended presence items like geolocation.
 *   This type isn't actually used by the SimplePresence interface, but
 *   it's included here so it can be referenced by rich presence
 *   interfaces.</p>
 * 
 * <p>New interfaces should use this type, and NOT
 *   <tp:type>Rich_Presence_Access_Control</tp:type>.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT AccessControl
{
    /**
     * The type of access control to apply.
     */
    uint type;
    /**
     * Any additional information required by the Type. The required type and 
     * semantics are defined for each Access_Control_Type.
     */
    QDBusVariant detail;
};

TP_QT_EXPORT bool operator==(const AccessControl& v1, const AccessControl& v2);
inline bool operator!=(const AccessControl& v1, const AccessControl& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const AccessControl& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, AccessControl& val);

/**
 * \struct AddressingNormalizationMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from URIs/vCard addresses to the corresponding handle.
 */
struct TP_QT_EXPORT AddressingNormalizationMap : public QMap<QString, uint>
{
    inline AddressingNormalizationMap() : QMap<QString, uint>() {}
    inline AddressingNormalizationMap(const QMap<QString, uint>& a) : QMap<QString, uint>(a) {}

    inline AddressingNormalizationMap& operator=(const QMap<QString, uint>& a)
    {
        *(static_cast<QMap<QString, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct AliasMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * A dictionary whose keys are contact handles and whose values are aliases.
 */
struct TP_QT_EXPORT AliasMap : public QMap<uint, QString>
{
    inline AliasMap() : QMap<uint, QString>() {}
    inline AliasMap(const QMap<uint, QString>& a) : QMap<uint, QString>(a) {}

    inline AliasMap& operator=(const QMap<uint, QString>& a)
    {
        *(static_cast<QMap<uint, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct AliasPair
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A pair (contact handle, alias) as seen in the AliasesChanged signal.
 */
struct TP_QT_EXPORT AliasPair
{
    uint handle;
    QString alias;
};

TP_QT_EXPORT bool operator==(const AliasPair& v1, const AliasPair& v2);
inline bool operator!=(const AliasPair& v1, const AliasPair& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const AliasPair& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, AliasPair& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of AliasPair values.
 */
typedef QList<AliasPair> AliasPairList;

/**
 * \struct Avatar
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>A struct containing avatar data marked with its MIME type.</p>
 * 
 * <p>May be set to an empty byte-array and an empty string, indicating
 *   no avatar.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT Avatar
{
    QByteArray avatarData;
    QString MIMEType;
};

TP_QT_EXPORT bool operator==(const Avatar& v1, const Avatar& v2);
inline bool operator!=(const Avatar& v1, const Avatar& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const Avatar& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, Avatar& val);

/**
 * \struct AvatarTokenMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * A dictionary whose keys are contact handles and whose values are avatar 
 * tokens.
 */
struct TP_QT_EXPORT AvatarTokenMap : public QMap<uint, QString>
{
    inline AvatarTokenMap() : QMap<uint, QString>() {}
    inline AvatarTokenMap(const QMap<uint, QString>& a) : QMap<uint, QString>(a) {}

    inline AvatarTokenMap& operator=(const QMap<uint, QString>& a)
    {
        *(static_cast<QMap<uint, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct CallMemberMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from handles to their current state in the call.
 */
struct TP_QT_EXPORT CallMemberMap : public QMap<uint, uint>
{
    inline CallMemberMap() : QMap<uint, uint>() {}
    inline CallMemberMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline CallMemberMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of CallMemberMap values.
 */
typedef QList<CallMemberMap> CallMemberMapList;

/**
 * \struct CallStateReason
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>A description of the reason for a change to the
 *    \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  and/or
 *    \endhtmlonly \link requestPropertyCallFlags() CallFlags \endlink \htmlonly .</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT CallStateReason
{
    /**
     * The contact responsible for the change, or 0 if no contact was 
     * responsible.
     */
    uint actor;
    /**
     * The reason, chosen from a limited set of possibilities defined by the 
     * Telepathy specification. If User_Requested then the Actor member will 
     * dictate whether it was the local user or a remote contact responsible.
     */
    uint reason;
    /**
     * \htmlonly
     * <p>A specific reason for the change, which may be a D-Bus error in
     *   the Telepathy namespace, a D-Bus error in any other namespace
     *   (for implementation-specific errors), or the empty string to
     *   indicate that the state change was not an error.</p>
     * 
     * <p>This SHOULD be an empty string for changes to any state other
     *   than Ended.</p>
     * 
     * <p>The errors Cancelled and Terminated SHOULD NOT be used here;
     *   an empty string SHOULD be used instead.</p>
     * 
     * <div class="rationale">
     *   <p>Those error names are used to indicate normal call
     *     termination by the local user or another user, respectively,
     *     in contexts where a D-Bus error name must appear.</p>
     * </div>
     * \endhtmlonly
     */
    QString DBusReason;
    /**
     * An optional debug message, to expediate debugging the potentially many 
     * processes involved in a call. This may be communicated across the 
     * network in protocols that support doing so, but it is not essential.
     */
    QString message;
};

TP_QT_EXPORT bool operator==(const CallStateReason& v1, const CallStateReason& v2);
inline bool operator!=(const CallStateReason& v1, const CallStateReason& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CallStateReason& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CallStateReason& val);

/**
 * \struct Candidate
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A Stream Candidate.
 */
struct TP_QT_EXPORT Candidate
{
    /**
     * The component number.
     */
    uint component;
    /**
     * The IP address to use.
     */
    QString IP;
    /**
     * The port number to use.
     */
    uint port;
    /**
     * Additional information about the candidate.
     */
    QVariantMap info;
};

TP_QT_EXPORT bool operator==(const Candidate& v1, const Candidate& v2);
inline bool operator!=(const Candidate& v1, const Candidate& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const Candidate& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, Candidate& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of Candidate values.
 */
typedef QList<Candidate> CandidateList;

/**
 * \struct CandidateInfo
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * <p>Extra information about the candidate. Allowed and mandatory keys
 *   depend on the transport protocol used. The following keys are commenly
 *   used:</p>
 * 
 * <dl>
 *   <dt><code>type</code> - u</dt>
 *   <dd>The type of candidate
 *     (<tp:type>Call_Stream_Candidate_Type</tp:type>)</dd>
 * 
 *   <dt><code>foundation</code> - s</dt>
 *   <dd>The foundation of this candidate</dd>
 * 
 *   <dt><code>protocol</code> - u</dt>
 *   <dd>Underlying protocol of the candidate
 *     (<tp:type>Media_Stream_Base_Proto</tp:type>) </dd>
 * 
 *   <dt><code>priority</code> - u</dt>
 *   <dd>Priority of the candidate (should be a number between 0 and
 *     65535). Most ICE implementations will prefer the highest priority
 *     candidate pair that manages to connect. For backwards
 *     compatibility with non-ICE SIP clients, the lowest priority
 *     candidate may be sent as a raw UDP fallback candidate.
 *     It is recommended that a relay candidate is used as the lowest
 *     priority candidate if possible. If both IPv4 and IPv6 raw udp
 *     fallback candidates are available, they should be set to the
 *     same priority and advertised to the CM at the same time. The CM
 *     will decide which to advertise to the remote end.</dd>
 * 
 *   <dt><code>base-ip</code> - s</dt>
 *   <dd>The underlying Host address where media sent to this
 *     (non-host-type) candidate will eventually arrive.</dd>
 * 
 *   <dt><code>base-port</code> - u</dt>
 *   <dd>The underlying Host port where media sent to this
 *     (non-host-type) candidate will eventually arrive.</dd>
 * 
 *   <dt><code>username</code> - s</dt>
 *   <dd>Username of this candidate
 *     (only if credentials are per candidate)</dd>
 * 
 *   <dt><code>password</code> - s</dt>
 *   <dd>Password of this candidate
 *     (only if credentials are per candidate)</dd>
 * 
 *   <dt><code>ttl</code> - u</dt>
 *   <dd>The TTL mandated for RTP/RTCP packets sent to a multicast group
 *     (only valid for Multicast Streams)</dd>
 * </dl>
 * \endhtmlonly
 */
struct TP_QT_EXPORT CandidateInfo : public QMap<QString, QDBusVariant>
{
    inline CandidateInfo() : QMap<QString, QDBusVariant>() {}
    inline CandidateInfo(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline CandidateInfo& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct CapabilityChange
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (contact handle, channel type, old generic flags, new generic 
 * flags, old type-specific flags, new type-specific flags) representing a 
 * change to one of a contact&apos;s capabilities, as seen in the 
 * CapabilitiesChanged signal on the Capabilities interface.
 */
struct TP_QT_EXPORT CapabilityChange
{
    uint handle;
    QString channelType;
    uint oldGenericFlags;
    uint newGenericFlags;
    uint oldTypeSpecificFlags;
    uint newTypeSpecificFlags;
};

TP_QT_EXPORT bool operator==(const CapabilityChange& v1, const CapabilityChange& v2);
inline bool operator!=(const CapabilityChange& v1, const CapabilityChange& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CapabilityChange& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CapabilityChange& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of CapabilityChange values.
 */
typedef QList<CapabilityChange> CapabilityChangeList;

/**
 * \struct CapabilityPair
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A pair (channel type, type-specific flags) as passed to 
 * AdvertiseCapabilities on the Capabilities interface.
 */
struct TP_QT_EXPORT CapabilityPair
{
    QString channelType;
    uint typeSpecificFlags;
};

TP_QT_EXPORT bool operator==(const CapabilityPair& v1, const CapabilityPair& v2);
inline bool operator!=(const CapabilityPair& v1, const CapabilityPair& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CapabilityPair& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CapabilityPair& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of CapabilityPair values.
 */
typedef QList<CapabilityPair> CapabilityPairList;

/**
 * \struct CaptchaAnswers
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * A mapping of captcha IDs to answer strings.
 * \endhtmlonly
 */
struct TP_QT_EXPORT CaptchaAnswers : public QMap<uint, QString>
{
    inline CaptchaAnswers() : QMap<uint, QString>() {}
    inline CaptchaAnswers(const QMap<uint, QString>& a) : QMap<uint, QString>(a) {}

    inline CaptchaAnswers& operator=(const QMap<uint, QString>& a)
    {
        *(static_cast<QMap<uint, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct CaptchaInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>A struct containing information regarding a single captcha
 *   mechanism.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT CaptchaInfo
{
    /**
     * \htmlonly
     * <p>The ID with which to reference this captcha method
     *   when retrieving its data and answering it.
     *   They are unique within this channel instance only.</p>
     * \endhtmlonly
     */
    uint ID;
    /**
     * \htmlonly
     * <p>The type of challenge
     *   <a href="http://xmpp.org/extensions/xep-0158.html#challenge">
     *   as defined by XEP-0158</a>. For instance, the commonly-used
     *   &quot;type the letters/words you see in this image&quot; challenge is
     *   represented by <code>ocr</code></p>
     * \endhtmlonly
     */
    QString type;
    /**
     * \htmlonly
     * <p>A human-readable label for the challenge, as defined in
     *   XEP-0158.</p>
     * 
     * <p>If the server does not supply a label for a challenge of type
     *   other than <code>qa</code>, connection managers SHOULD set Label
     *   to an empty string instead of generating their own text.
     *   If the Label is an empty string, the Handler SHOULD replace
     *   it with a generic label in the user's locale, such as
     *   the strings suggested in XEP-0158 (for instance,
     *   <code>Enter the text you see</code> for <code>ocr</code>
     *   challenges). The Handler MAY use those generic labels
     *   in any case, as per
     *   <a href="http://xmpp.org/extensions/xep-0158.html#i18n">the
     *     Internationalization Considerations section of XEP-0158</a>.</p>
     * 
     * <div class="rationale">
     *   <p>Connection managers are not usually localized, so text
     *     generated by the connection manager would be in English,
     *     regardless of the user's locale. The Handler is better-placed
     *     to generate a generic Label in the user's locale.</p>
     * </div>
     * 
     * <p>For challenges of type <code>qa</code>, the Label is a plain-text
     *   question for the user to answer. The connection manager
     *   SHOULD NOT provide an empty Label; if it does, the Handler
     *   SHOULD treat that challenge as impossible, and SHOULD NOT
     *   attempt to display it.</p>
     * \endhtmlonly
     */
    QString label;
    /**
     * \htmlonly
     * <p>One flag defined: Required. Most captchas will have no flags.</p>
     * \endhtmlonly
     */
    uint flags;
    /**
     * \htmlonly
     * <p>A list of MIME types the server is offering to provide
     *   for this captcha method.</p>
     * \endhtmlonly
     */
    QStringList availableMIMETypes;
};

TP_QT_EXPORT bool operator==(const CaptchaInfo& v1, const CaptchaInfo& v2);
inline bool operator!=(const CaptchaInfo& v1, const CaptchaInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CaptchaInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CaptchaInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of CaptchaInfo values.
 */
typedef QList<CaptchaInfo> CaptchaInfoList;

/**
 * \struct ChannelCallStateMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contacts to call states.
 */
struct TP_QT_EXPORT ChannelCallStateMap : public QMap<uint, uint>
{
    inline ChannelCallStateMap() : QMap<uint, uint>() {}
    inline ChannelCallStateMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline ChannelCallStateMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ChannelClass
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * <p>Mapping representing a class of channels that can be requested
 *   from a connection manager, can be handled by a user interface,
 *   are supported by a contact, etc.</p>
 * 
 * <p>Classes of channel are identified by the fixed values of
 *   a subset of their properties.</p>
 * 
 * <p>Channel classes SHOULD always include the keys
 *    \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly 
 *   and
 *    \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly .
 *   (One exception is that  \endhtmlonly ChannelTypeContactSearchInterface \htmlonly  channels do not have TargetHandleType
 *   <code>None</code> in their requestable channel classes, for
 *   historical reasons.)</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT ChannelClass : public QMap<QString, QDBusVariant>
{
    inline ChannelClass() : QMap<QString, QDBusVariant>() {}
    inline ChannelClass(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline ChannelClass& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ChannelClass values.
 */
typedef QList<ChannelClass> ChannelClassList;

/**
 * \struct ChannelDetails
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * Enough details of a channel that clients can work out how to dispatch or 
 * handle it.
 */
struct TP_QT_EXPORT ChannelDetails
{
    /**
     * The object path of the channel.
     */
    QDBusObjectPath channel;
    /**
     * \htmlonly
     * <p>Properties of the channel.</p>
     * 
     * <p>Connection managers MUST NOT include properties in this mapping
     *   if their values can change. Clients MUST ignore properties
     *   that appear in this mapping if their values can change.</p>
     * 
     * <div class="rationale">
     *   <p>If properties that could change were included, the following
     *     race condition would be likely to exist in some cases:</p>
     * 
     *   <ul>
     *     <li>NewChannels or Get(&quot;Channels&quot;) includes a property P with
     *       value V1</li>
     *     <li>Client creates a proxy object for the channel</li>
     *     <li>The value of P changes to V2</li>
     *     <li>Client connects to PChanged signal</li>
     *     <li>Client should call Get(&quot;P&quot;) or GetAll here, to avoid the
     *       race, but client's author has forgotten to do so</li>
     *     <li>Proxy object thinks P == V1, but actually P == V2</li>
     *   </ul>
     * 
     *   <p>We've taken the opportunity to make the API encourage the
     *     client author to get it right. Where possible, we intend that
     *     properties whose value will be used in channel dispatching
     *     or other &quot;early&quot; processing will be defined so that they are
     *     immutable (can never change).</p>
     * </div>
     * 
     * <p>Each dictionary MUST contain the keys
     *    \endhtmlonly \link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \endlink \htmlonly ,
     *    \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly ,
     *    \endhtmlonly \link ChannelInterface::requestPropertyTargetHandle() ChannelInterface::TargetHandle \endlink \htmlonly ,
     *    \endhtmlonly \link ChannelInterface::requestPropertyTargetID() ChannelInterface::TargetID \endlink \htmlonly 
     *   and
     *    \endhtmlonly \link ChannelInterface::requestPropertyRequested() ChannelInterface::Requested \endlink \htmlonly .
     * </p>
     * 
     * <div class="rationale">
     *   <p>We expect these to be crucial to the channel-dispatching
     *     process.</p>
     * </div>
     * \endhtmlonly
     */
    QVariantMap properties;
};

TP_QT_EXPORT bool operator==(const ChannelDetails& v1, const ChannelDetails& v2);
inline bool operator!=(const ChannelDetails& v1, const ChannelDetails& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ChannelDetails& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ChannelDetails& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ChannelDetails values.
 */
typedef QList<ChannelDetails> ChannelDetailsList;

/**
 * \struct ChannelInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct representing a channel, as returned by ListChannels on the 
 * Connection interface.
 */
struct TP_QT_EXPORT ChannelInfo
{
    /**
     * The object path of the channel, which is on the same bus name as the 
     * connection
     */
    QDBusObjectPath channel;
    /**
     * The channel&apos;s type
     */
    QString channelType;
    /**
     * The type of the handle that the channel communicates with, or 
     * Handle_Type_None if there is no associated handle
     */
    uint handleType;
    /**
     * The handle that the channel communicates with, or 0 if there is no 
     * associated handle
     */
    uint handle;
};

TP_QT_EXPORT bool operator==(const ChannelInfo& v1, const ChannelInfo& v2);
inline bool operator!=(const ChannelInfo& v1, const ChannelInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ChannelInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ChannelInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ChannelInfo values.
 */
typedef QList<ChannelInfo> ChannelInfoList;

/**
 * \struct ChannelOriginatorMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QDBusObjectPath>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * A mapping from members of a conference to the original 1-1 channel with
 * that contact, if any. See
 *  \endhtmlonly \link requestPropertyOriginalChannels() OriginalChannels \endlink \htmlonly  for details.
 * \endhtmlonly
 */
struct TP_QT_EXPORT ChannelOriginatorMap : public QMap<uint, QDBusObjectPath>
{
    inline ChannelOriginatorMap() : QMap<uint, QDBusObjectPath>() {}
    inline ChannelOriginatorMap(const QMap<uint, QDBusObjectPath>& a) : QMap<uint, QDBusObjectPath>(a) {}

    inline ChannelOriginatorMap& operator=(const QMap<uint, QDBusObjectPath>& a)
    {
        *(static_cast<QMap<uint, QDBusObjectPath>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ChatStateMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contacts to their chat states.
 */
struct TP_QT_EXPORT ChatStateMap : public QMap<uint, uint>
{
    inline ChatStateMap() : QMap<uint, uint>() {}
    inline ChatStateMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline ChatStateMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ComponentStateMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT ComponentStateMap : public QMap<uint, uint>
{
    inline ComponentStateMap() : QMap<uint, uint>() {}
    inline ComponentStateMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline ComponentStateMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactAttributesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QVariantMap>, but needed to have a discrete type in the Qt type system.
 * 
 * Mapping returned by GetContactAttributes, representing a collection of 
 * Contacts and their requested attributes.
 */
struct TP_QT_EXPORT ContactAttributesMap : public QMap<uint, QVariantMap>
{
    inline ContactAttributesMap() : QMap<uint, QVariantMap>() {}
    inline ContactAttributesMap(const QMap<uint, QVariantMap>& a) : QMap<uint, QVariantMap>(a) {}

    inline ContactAttributesMap& operator=(const QMap<uint, QVariantMap>& a)
    {
        *(static_cast<QMap<uint, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactCapability
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (contact handle, channel type, generic flags, type-specific flags) 
 * representing a capability posessed by a contact, as returned by 
 * GetCapabilities on the Capabilities interface.
 */
struct TP_QT_EXPORT ContactCapability
{
    uint handle;
    QString channelType;
    uint genericFlags;
    uint typeSpecificFlags;
};

TP_QT_EXPORT bool operator==(const ContactCapability& v1, const ContactCapability& v2);
inline bool operator!=(const ContactCapability& v1, const ContactCapability& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ContactCapability& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ContactCapability& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ContactCapability values.
 */
typedef QList<ContactCapability> ContactCapabilityList;

/**
 * \struct ContactClientTypes
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QStringList>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from contact handle to client types.
 */
struct TP_QT_EXPORT ContactClientTypes : public QMap<uint, QStringList>
{
    inline ContactClientTypes() : QMap<uint, QStringList>() {}
    inline ContactClientTypes(const QMap<uint, QStringList>& a) : QMap<uint, QStringList>(a) {}

    inline ContactClientTypes& operator=(const QMap<uint, QStringList>& a)
    {
        *(static_cast<QMap<uint, QStringList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactInfoField
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 *         <p>Represents one piece of information about a contact, as modelled by
 *           a single vCard field. Of the fields defined in RFC 2426, common
 *           examples include:</p>
 * 
 *         <dl>
 *           <dt>fn</dt>
 *           <dd>The contact's full name, formatted to their liking</dd>
 * 
 *           <dt>n</dt>
 *           <dd>The contact's full name, divided into five parts: family name,
 *             given name, additional names, honorific prefixes, and honorific
 *             suffixes</dd>
 * 
 *           <dt>org</dt>
 *           <dd>The contact's organisation, divided into the organization's name
 *             possibly followed by one or more organizational unit names.</dd>
 * 
 *           <dt>adr</dt>
 *           <dd>A street address for the contact, divided into seven components:
 *             post office box, extended address, street address, locality (e.g.,
 *             city), region (e.g., state or province), the postal code, and the
 *             country name.</dd>
 * 
 *           <dt>label</dt>
 *           <dd>A free-form street address for the contact, formatted as a
 *             single value (with embedded newlines where necessary) suitable for
 *             printing on an address label</dd>
 * 
 *           <dt>tel</dt>
 *           <dd>A telephone number for the contact.</dd>
 * 
 *           <dt>email</dt>
 *           <dd>An email address for the contact.</dd>
 *         </dl>
 * 
 *         <p>For example, the following vCard:</p>
 * 
 *         <pre>
 *    BEGIN:vCard
 *    VERSION:3.0
 *    FN:Wee Ninja
 *    N;LANGUAGE=ja:Ninja;Wee;;;-san
 *    ORG:Collabora, Ltd.;Management Division;Human Resources\\; Company Policy Enforcement
 *    ADR;TYPE=WORK,POSTAL,PARCEL:;;11 Kings Parade;Cambridge;Cambridgeshire
 *     ;CB2 1SJ;UK
 *    LABEL;TYPE=WORK,POSTAL,PARCEL:11 Kings Parade\\nCambridge\\nCambridgeshire\\nUK\\nCB2 1SJ
 *    TEL;TYPE=VOICE,WORK:+44 1223 362967, +44 7700 900753
 *    EMAIL;TYPE=INTERNET,PREF:wee.ninja@collabora.co.uk
 *    EMAIL;TYPE=INTERNET:wee.ninja@example.com
 *    URL:http://www.thinkgeek.com/geektoys/plush/8823/
 *    NICKNAME:HR Ninja,Enforcement Ninja
 *    END:vCard</pre>
 * 
 *         <p>would be represented by (in Python-like syntax):</p>
 * 
 *         <pre>
 * [
 *   ('fn', [], ['Wee Ninja']),
 *   ('n', ['language=ja'], ['Ninja', 'Wee', '', '', '-san']),
 *   ('org', [], ['Collabora, Ltd.', 'Management Division',
 *     'Human Resources; Company Policy Enforcement']),
 *   ('adr', ['type=work','type=postal','type=parcel'],
 *    ['','','11 Kings Parade','Cambridge', 'Cambridgeshire','CB2 1SJ','UK']),
 *   ('label', ['type=work','type=postal','type=parcel'],
 *    ['''11 Kings Parade
 *   Cambridge
 *   Cambridgeshire
 *   UK
 *   CB2 1SJ''']),
 *   ('tel', ['type=voice','type=work'], ['+44 1223 362967']),
 *   ('tel', ['type=voice','type=work'], ['+44 7700 900753']),
 *   ('email', ['type=internet','type=pref'], ['wee.ninja@collabora.co.uk']),
 *   ('email', ['type=internet'], ['wee.ninja@example.com']),
 *   ('url', [], ['http://www.thinkgeek.com/geektoys/plush/8823/']),
 *   ('nickname', [], ['HR Ninja']),
 *   ('nickname', [], ['Enforcement Ninja'])
 * ]</pre>
 * \endhtmlonly
 */
struct TP_QT_EXPORT ContactInfoField
{
    /**
     * The name of the field; this is the lowercased name of a vCard field. 
     * For example, a field representing a contact&apos;s address would be 
     * named &quot;adr&quot;.
     */
    QString fieldName;
    /**
     * \htmlonly
     * <p>A list of vCard type parameters applicable to this field, with their
     *   values. The type parameter names, and any values that are
     *   case-insensitive in vCard, MUST be in lower case. For example, a
     *   contact's preferred home address would have parameters
     *   'type=home' and 'type=pref'.</p>
     * 
     * <div class="rationale">
     *   The type parameter 'type' is likely to be the most common, but
     *   there can be others, such as 'language=en'.
     * </div>
     * 
     * <p>Characters which are required to be escaped in vCard type
     *   parameters should not be escaped in this list. For instance,
     *   a field &quot;X-FOO;SEMICOLON=\\;:bar&quot; in a vCard would become
     *   ('x-foo', ['semicolon=;'], ['bar']) in this interface.</p>
     * 
     * <div class="rationale">
     *   This avoids Telepathy UIs having to understand the escaping and
     *   unescaping rules for vCards. The type parameter name is not
     *   allowed (by RFC 2425) to contain an '=' character, so no ambiguity
     *   is introduced.
     * </div>
     * \endhtmlonly
     */
    QStringList parameters;
    /**
     * \htmlonly
     * <p>For unstructured vCard fields (such as 'fn', a formatted name
     *   field), a single-element array containing the field's value.</p>
     * 
     * <p>For structured fields (such as 'adr', an address field), an array
     *   corresponding to the semicolon-separated elements of the field (with
     *   empty strings for empty elements).</p>
     * 
     * <p>A vCard field with multiple comma-separated values, such as
     *   'nickname', should be represented by several
     *   <tp:type>Contact_Info_Field</tp:type>s.</p>
     * 
     * <p>Characters which are required to be escaped in vCard values, such as
     *   semi-colons and newlines, should not be escaped in this list (e.g. if
     *   a value contains a newline, the data passed over D-Bus should
     *   contain a literal newline character).</p>
     * 
     * <div class="rationale">
     *   An earlier draft of this interface split structured vCard fields
     *   into multiple Telepathy-level fields; for example, 'n' became
     *   'family-name', 'given-name', etc.  But under this representation,
     *   omitting empty components leads to difficulty identifying where one
     *   name ends and another begins.  Consider the fields ['given-name',
     *   'honorific-suffixes', 'family-name', 'honorific-prefixes']: does
     *   this represent two 'n' fields, or one with incorrect component
     *   ordering?
     * </div>
     * \endhtmlonly
     */
    QStringList fieldValue;
};

TP_QT_EXPORT bool operator==(const ContactInfoField& v1, const ContactInfoField& v2);
inline bool operator!=(const ContactInfoField& v1, const ContactInfoField& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ContactInfoField& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ContactInfoField& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ContactInfoField values.
 */
typedef QList<ContactInfoField> ContactInfoFieldList;

/**
 * \struct ContactLocations
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QVariantMap>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contacts to their locations.
 */
struct TP_QT_EXPORT ContactLocations : public QMap<uint, QVariantMap>
{
    inline ContactLocations() : QMap<uint, QVariantMap>() {}
    inline ContactLocations(const QMap<uint, QVariantMap>& a) : QMap<uint, QVariantMap>(a) {}

    inline ContactLocations& operator=(const QMap<uint, QVariantMap>& a)
    {
        *(static_cast<QMap<uint, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactMediaDescriptionPropertiesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QVariantMap>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT ContactMediaDescriptionPropertiesMap : public QMap<uint, QVariantMap>
{
    inline ContactMediaDescriptionPropertiesMap() : QMap<uint, QVariantMap>() {}
    inline ContactMediaDescriptionPropertiesMap(const QMap<uint, QVariantMap>& a) : QMap<uint, QVariantMap>(a) {}

    inline ContactMediaDescriptionPropertiesMap& operator=(const QMap<uint, QVariantMap>& a)
    {
        *(static_cast<QMap<uint, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSSRCsMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, UIntList>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT ContactSSRCsMap : public QMap<uint, UIntList>
{
    inline ContactSSRCsMap() : QMap<uint, UIntList>() {}
    inline ContactSSRCsMap(const QMap<uint, UIntList>& a) : QMap<uint, UIntList>(a) {}

    inline ContactSSRCsMap& operator=(const QMap<uint, UIntList>& a)
    {
        *(static_cast<QMap<uint, UIntList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSearchMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from search keys to search terms.
 */
struct TP_QT_EXPORT ContactSearchMap : public QMap<QString, QString>
{
    inline ContactSearchMap() : QMap<QString, QString>() {}
    inline ContactSearchMap(const QMap<QString, QString>& a) : QMap<QString, QString>(a) {}

    inline ContactSearchMap& operator=(const QMap<QString, QString>& a)
    {
        *(static_cast<QMap<QString, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSendingStateMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from a contact to his or her sending state.
 */
struct TP_QT_EXPORT ContactSendingStateMap : public QMap<uint, uint>
{
    inline ContactSendingStateMap() : QMap<uint, uint>() {}
    inline ContactSendingStateMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline ContactSendingStateMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSubscriptions
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A single contact&apos;s subscribe, publish and publish-request attributes.
 */
struct TP_QT_EXPORT ContactSubscriptions
{
    /**
     * The new value of the contact&apos;s &quot;subscribe&quot; attribute.
     */
    uint subscribe;
    /**
     * The new value of the contact&apos;s &quot;publish&quot; attribute.
     */
    uint publish;
    /**
     * The new value of the contact&apos;s &quot;publish-request&quot; 
     * attribute, or the empty string if that attribute would be omitted.
     */
    QString publishRequest;
};

TP_QT_EXPORT bool operator==(const ContactSubscriptions& v1, const ContactSubscriptions& v2);
inline bool operator!=(const ContactSubscriptions& v1, const ContactSubscriptions& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ContactSubscriptions& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ContactSubscriptions& val);

/**
 * \struct CurrencyAmount
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>An amount of money in a specified currency. For example,
 *   3.21 British pounds would conventionally be represented by
 *   (<var>Amount</var> = <tt>321</tt>, <var>Scale</var> = <tt>2</tt>,
 *   <var>Currency</var> = <tt>&quot;GBP&quot;</tt>), but could be represented by
 *   (<var>Amount</var> = <tt>3210</tt>, <var>Scale</var> = <tt>3</tt>,
 *   <var>Currency</var> = <tt>&quot;GBP&quot;</tt>) in a service that records
 *   balance in units of 0.001 pounds.</p>
 * 
 * <p>As a special case, if <var>Amount</var> = <tt>0</tt>,
 *   <var>Scale</var> = <tt>2**32 - 1</tt> (i.e.  the largest possible
 *   32-bit unsigned integer) and <var>Currency</var> = <tt>&quot;&quot;</tt>, this
 *   indicates an unknown amount.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT CurrencyAmount
{
    /**
     * \htmlonly
     * <p>The amount, expressed as a fixed-point number with decimal scale
     *   defined by the <var>Scale</var> field; for instance, an
     *   <var>Amount</var> value of <tt>1234</tt> with <var>Scale</var> of
     *   <tt>2</tt> represents 12.34 in the currency unit given by the
     *   <var>Currency</var> field.</p>
     * \endhtmlonly
     */
    int amount;
    /**
     * \htmlonly
     * <p>The decimal scale for the fixed point value of the
     *   <var>Amount</var> field, defining the number of rightmost decimal
     *   digits from the integer value which form the fractional part of the
     *   resulting currency value.</p>
     * 
     * <p>As well as defining the interpretation of <var>Amount</var>, user
     *   interfaces may use this value to determine the precision with which
     *   to display the amount.</p>
     * \endhtmlonly
     */
    uint scale;
    /**
     * The currency code represented by this amount, which SHOULD be an 
     * international currency code such as &quot;EUR&quot;, &quot;USD&quot;, 
     * or &quot;JPY&quot; if possible. An empty string can be used to indicate 
     * that the currency is not known.
     */
    QString currency;
};

TP_QT_EXPORT bool operator==(const CurrencyAmount& v1, const CurrencyAmount& v2);
inline bool operator!=(const CurrencyAmount& v1, const CurrencyAmount& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CurrencyAmount& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CurrencyAmount& val);

/**
 * \struct DBusTubeMember
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * Represents a participant in a multi-user D-Bus tube, as returned by 
 * GetDBusNames and seen in the DBusNamesChanged signal.
 */
struct TP_QT_EXPORT DBusTubeMember
{
    /**
     * The handle of a participant in this D-Bus tube.
     */
    uint handle;
    /**
     * That participant&apos;s unique name.
     */
    QString uniqueName;
};

TP_QT_EXPORT bool operator==(const DBusTubeMember& v1, const DBusTubeMember& v2);
inline bool operator!=(const DBusTubeMember& v1, const DBusTubeMember& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const DBusTubeMember& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, DBusTubeMember& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of DBusTubeMember values.
 */
typedef QList<DBusTubeMember> DBusTubeMemberList;

/**
 * \struct DBusTubeParticipants
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * Represents the participants in a multi-user D-Bus tube, as used by the 
 * DBusNames property and the DBusNamesChanged signal.
 */
struct TP_QT_EXPORT DBusTubeParticipants : public QMap<uint, QString>
{
    inline DBusTubeParticipants() : QMap<uint, QString>() {}
    inline DBusTubeParticipants(const QMap<uint, QString>& a) : QMap<uint, QString>(a) {}

    inline DBusTubeParticipants& operator=(const QMap<uint, QString>& a)
    {
        *(static_cast<QMap<uint, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct DebugMessage
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct representing a debug message, as returned by GetMessages.
 */
struct TP_QT_EXPORT DebugMessage
{
    /**
     * Timestamp of the debug message. This is a double to allow more accuracy 
     * in the time the message was logged.
     */
    double timestamp;
    /**
     * \htmlonly
     * <p>Domain of the debug message. This is used to identify
     * the source of debug messages. For example, debug messages
     * from a connection manager could have this Domain struct
     * member be the name of the connection manager, and logs
     * from any helper library could have the name of the helper
     * library.</p>
     * 
     * <p>The domain could also contain a category as to where
     * the log message originated separated by a forward-slash.
     * For example, if a debug message was output in a connection
     * manager called &quot;dummy&quot;, in the file-transfer code, this
     * Domain struct member might be <tt>dummy/file-transfer</tt>.</p>
     * \endhtmlonly
     */
    QString domain;
    /**
     * Level of the debug message. This states the severity of the debug 
     * message.
     */
    uint level;
    /**
     * The text of the debug message.
     */
    QString message;
};

TP_QT_EXPORT bool operator==(const DebugMessage& v1, const DebugMessage& v2);
inline bool operator!=(const DebugMessage& v1, const DebugMessage& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const DebugMessage& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, DebugMessage& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of DebugMessage values.
 */
typedef QList<DebugMessage> DebugMessageList;

/**
 * \struct FieldSpec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct describing a vCard field, with parameters, that may be passed to 
 * SetContactInfo on this Connection.
 */
struct TP_QT_EXPORT FieldSpec
{
    /**
     * A vCard field name, such as &apos;tel&apos;.
     */
    QString name;
    /**
     * The set of vCard type parameters which may be set on this field. If 
     * this list is empty and the Contact_Info_Field_Flag_Parameters_Exact 
     * flag is not set, any vCard type parameters may be used.
     */
    QStringList parameters;
    /**
     * Flags describing the behaviour of this field.
     */
    uint flags;
    /**
     * Maximum number of instances of this field which may be set. MAXUINT32 
     * is used to indicate that there is no limit.
     */
    uint max;
};

TP_QT_EXPORT bool operator==(const FieldSpec& v1, const FieldSpec& v2);
inline bool operator!=(const FieldSpec& v1, const FieldSpec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const FieldSpec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, FieldSpec& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of FieldSpec values.
 */
typedef QList<FieldSpec> FieldSpecs;

/**
 * \struct HTTPPostData
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>A pair (key, value) representing POST data compatible with the
 * application/x-www-form-urlencoded MIME type. The strings MUST be
 * valid UTF-8 strings, and the characters used in the key MUST obey
 * the requirements of the
 * <a href="http://www.w3.org/TR/html401/types.html#type-cdata">
 *   HTML CDATA type</a>. The value MUST NOT be
 * encoded with HTML entities.</p>
 * 
 * <p>For example, if the POST data should contain a key &quot;less-than&quot; with value
 * &quot;&lt;&quot;, and a key &quot;percent&quot; with value &quot;%&quot;, this should be represented as
 * two HTTP_Post_Data structures, (&quot;less-than&quot;, &quot;&lt;&quot;) and (&quot;percent&quot;, &quot;%&quot;),
 * resulting in a POST request whose request body is &quot;less-than=&amp;lt;&amp;percent=%25&quot;.
 * If a client passes this to a browser by writing it into an HTML form, it
 * could do so by representing it as:</p>
 * 
 * <pre>
 * &lt;input type=&quot;hidden&quot; name=&quot;less-than&quot;&gt;&amp;lt;&lt;/input&gt;
 * &lt;input type=&quot;hidden&quot; name=&quot;percent&quot;&gt;%&lt;/input&gt;
 * </pre>
 * 
 * <div class="rationale">
 *   <p>This data can be used to generate a HTML file that will
 *     automatically load the URL with appropriate POST data, in which case
 *     the client MUST convert any characters that are special within HTML
 *     into HTML entities. Alternatively, it can be used in an API that will
 *     instruct the browser how to load the URL (like the Netscape Plug-in
 *     API), in which case the client MUST escape
 *     <a href="http://www.ietf.org/rfc/rfc1738.txt">characters that are
 *       reserved in URLs</a>, if appropriate for that API.</p>
 * 
 *   <p>An array of pairs is used instead of a map from keys to values,
 *     because it's valid to repeat keys in both HTML and
 *     x-www-form-urlencoded data.</p>
 * </div>
 * \endhtmlonly
 */
struct TP_QT_EXPORT HTTPPostData
{
    /**
     * The key, corresponding to a HTML control name
     */
    QString key;
    /**
     * The value
     */
    QString value;
};

TP_QT_EXPORT bool operator==(const HTTPPostData& v1, const HTTPPostData& v2);
inline bool operator!=(const HTTPPostData& v1, const HTTPPostData& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const HTTPPostData& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, HTTPPostData& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of HTTPPostData values.
 */
typedef QList<HTTPPostData> HTTPPostDataList;

/**
 * \struct HandleIdentifierMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from handles to the corresponding normalized string identifier.
 */
struct TP_QT_EXPORT HandleIdentifierMap : public QMap<uint, QString>
{
    inline HandleIdentifierMap() : QMap<uint, QString>() {}
    inline HandleIdentifierMap(const QMap<uint, QString>& a) : QMap<uint, QString>(a) {}

    inline HandleIdentifierMap& operator=(const QMap<uint, QString>& a)
    {
        *(static_cast<QMap<uint, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct HandleOwnerMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, uint>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from channel-specific handles to their owners.
 */
struct TP_QT_EXPORT HandleOwnerMap : public QMap<uint, uint>
{
    inline HandleOwnerMap() : QMap<uint, uint>() {}
    inline HandleOwnerMap(const QMap<uint, uint>& a) : QMap<uint, uint>(a) {}

    inline HandleOwnerMap& operator=(const QMap<uint, uint>& a)
    {
        *(static_cast<QMap<uint, uint>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct LocalPendingInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A structure representing a contact whose attempt to join a group is to be 
 * confirmed by the local user using AddMembers.
 */
struct TP_QT_EXPORT LocalPendingInfo
{
    /**
     * The contact to be added to the group
     */
    uint toBeAdded;
    /**
     * The contact requesting or causing the change
     */
    uint actor;
    /**
     * The reason for the change
     */
    uint reason;
    /**
     * A human-readable message from the Actor, or an empty string if there is 
     * no message
     */
    QString message;
};

TP_QT_EXPORT bool operator==(const LocalPendingInfo& v1, const LocalPendingInfo& v2);
inline bool operator!=(const LocalPendingInfo& v1, const LocalPendingInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const LocalPendingInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, LocalPendingInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of LocalPendingInfo values.
 */
typedef QList<LocalPendingInfo> LocalPendingInfoList;

/**
 * \struct Location
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * A user&apos;s location, represented as an extensible mapping.
 */
struct TP_QT_EXPORT Location : public QMap<QString, QDBusVariant>
{
    inline Location() : QMap<QString, QDBusVariant>() {}
    inline Location(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline Location& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct Mail
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * An extensible map representing a mail, or (on protocols where Thread_Based 
 * appears in MailNotificationFlags) a thread of mails. All keys are optional 
 * where not otherwise stated; however, at least one of &quot;senders&quot; 
 * and &quot;subject&quot; must be included.
 */
struct TP_QT_EXPORT Mail : public QMap<QString, QDBusVariant>
{
    inline Mail() : QMap<QString, QDBusVariant>() {}
    inline Mail(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline Mail& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of Mail values.
 */
typedef QList<Mail> MailList;

/**
 * \struct MailAddress
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 *         <p>A pair (name, address) representing an e-mail address,
 *         such as (&quot;Nicolas Dufresne&quot;, &quot;nicolas.dufresne@collabora.co.uk&quot;). At
 *         least one of name and address MUST be provided. A missing element will
 *         be represented by the empty string.</p>
 *         <div class="rationale">
 * 	  <p>The CM should provide as much information as possible, but not all
 *             protocols provide both the displayed name and the address. (If a
 *             protocol doesn't provide either, it should omit the appropriate
 *             field from the <tp:type>Mail</tp:type> entirely.)</p>
 *         </div>
 * \endhtmlonly
 */
struct TP_QT_EXPORT MailAddress
{
    /**
     * The displayed name corresponding to the e-mail address
     */
    QString name;
    /**
     * The actual e-mail address
     */
    QString address;
};

TP_QT_EXPORT bool operator==(const MailAddress& v1, const MailAddress& v2);
inline bool operator!=(const MailAddress& v1, const MailAddress& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MailAddress& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MailAddress& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MailAddress values.
 */
typedef QList<MailAddress> MailAddressList;

/**
 * \struct MediaDescriptionOffer
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * The remote description offer and its information
 */
struct TP_QT_EXPORT MediaDescriptionOffer
{
    /**
     * \htmlonly
     * The object path to the  \endhtmlonly CallContentMediaDescriptionInterface \htmlonly 
     * \endhtmlonly
     */
    QDBusObjectPath mediaDescription;
    /**
     * The immutable properties of all interfaces of the codec description. 
     * Having all the codec description properties here saves a D-Bus 
     * round-trip - it shouldn&apos;t be necessary to get the properties from 
     * the MediaDescription object, in practice.
     */
    QVariantMap properties;
};

TP_QT_EXPORT bool operator==(const MediaDescriptionOffer& v1, const MediaDescriptionOffer& v2);
inline bool operator!=(const MediaDescriptionOffer& v1, const MediaDescriptionOffer& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaDescriptionOffer& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaDescriptionOffer& val);

/**
 * \struct MediaDescriptionProperties
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * <p>
 *   A mapping containing all properties that define the information from a
 *    \endhtmlonly CallContentMediaDescriptionInterface \htmlonly  and its interfaces.
 * </p>
 * 
 * <p>
 *   If  \endhtmlonly \link CallContentMediaDescriptionInterface::requestPropertyHasRemoteInformation() CallContentMediaDescriptionInterface::HasRemoteInformation \endlink \htmlonly  is True, then this mapping
 *   will always contains at least
 *    \endhtmlonly \link CallContentMediaDescriptionInterface::requestPropertyCodecs() CallContentMediaDescriptionInterface::Codecs \endlink \htmlonly 
 * </p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT MediaDescriptionProperties : public QMap<QString, QDBusVariant>
{
    inline MediaDescriptionProperties() : QMap<QString, QDBusVariant>() {}
    inline MediaDescriptionProperties(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline MediaDescriptionProperties& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct MediaSessionHandlerInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct representing a active session handler.
 */
struct TP_QT_EXPORT MediaSessionHandlerInfo
{
    /**
     * The object path of the session handler, which is on the same bus name 
     * as the channel.
     */
    QDBusObjectPath sessionHandler;
    /**
     * The media session&apos;s type
     */
    QString mediaSessionType;
};

TP_QT_EXPORT bool operator==(const MediaSessionHandlerInfo& v1, const MediaSessionHandlerInfo& v2);
inline bool operator!=(const MediaSessionHandlerInfo& v1, const MediaSessionHandlerInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaSessionHandlerInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaSessionHandlerInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MediaSessionHandlerInfo values.
 */
typedef QList<MediaSessionHandlerInfo> MediaSessionHandlerInfoList;

/**
 * \struct MediaStreamHandlerTransport
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT MediaStreamHandlerTransport
{
    uint componentNumber;
    QString IPAddress;
    uint port;
    uint protocol;
    QString subtype;
    QString profile;
    double preferenceValue;
    uint transportType;
    QString username;
    QString password;
};

TP_QT_EXPORT bool operator==(const MediaStreamHandlerTransport& v1, const MediaStreamHandlerTransport& v2);
inline bool operator!=(const MediaStreamHandlerTransport& v1, const MediaStreamHandlerTransport& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaStreamHandlerTransport& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaStreamHandlerTransport& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MediaStreamHandlerTransport values.
 */
typedef QList<MediaStreamHandlerTransport> MediaStreamHandlerTransportList;

/**
 * \struct MediaStreamInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT MediaStreamInfo
{
    uint identifier;
    uint contact;
    uint type;
    uint state;
    uint direction;
    uint pendingSendFlags;
};

TP_QT_EXPORT bool operator==(const MediaStreamInfo& v1, const MediaStreamInfo& v2);
inline bool operator!=(const MediaStreamInfo& v1, const MediaStreamInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaStreamInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaStreamInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MediaStreamInfo values.
 */
typedef QList<MediaStreamInfo> MediaStreamInfoList;

/**
 * \struct MessagePart
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT MessagePart : public QMap<QString, QDBusVariant>
{
    inline MessagePart() : QMap<QString, QDBusVariant>() {}
    inline MessagePart(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline MessagePart& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MessagePart values.
 */
typedef QList<MessagePart> MessagePartList;

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MessagePartList values.
 */
typedef QList<MessagePartList> MessagePartListList;

/**
 * \struct MessagePartContentMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from message part indexes to their content, as returned by 
 * GetPendingMessageContent.
 */
struct TP_QT_EXPORT MessagePartContentMap : public QMap<uint, QDBusVariant>
{
    inline MessagePartContentMap() : QMap<uint, QDBusVariant>() {}
    inline MessagePartContentMap(const QMap<uint, QDBusVariant>& a) : QMap<uint, QDBusVariant>(a) {}

    inline MessagePartContentMap& operator=(const QMap<uint, QDBusVariant>& a)
    {
        *(static_cast<QMap<uint, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct Metadata
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QStringList>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from string key to a list of strings, used in the Metadata 
 * property. To emulate a simple string → string hash table one should have 
 * exactly one member in the value string list. This property is an a{sas} 
 * primarily because this maps easily to XEP-0004 Data Forms, and allows more 
 * structured metadata than a{ss} would. (For instance, a list of RDF triples 
 * could be expressed as one long array of strings, or as three-element values 
 * for a series of dummy key names, rather than as one big string blob.) While 
 * it might be convenient for applications to allow keys of arbitrary types, 
 * the added convenience would be outweighed by having to define the XMPP 
 * representation
 */
struct TP_QT_EXPORT Metadata : public QMap<QString, QStringList>
{
    inline Metadata() : QMap<QString, QStringList>() {}
    inline Metadata(const QMap<QString, QStringList>& a) : QMap<QString, QStringList>(a) {}

    inline Metadata& operator=(const QMap<QString, QStringList>& a)
    {
        *(static_cast<QMap<QString, QStringList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct MultipleStatusMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QVariantMap>, but needed to have a discrete type in the Qt type system.
 * 
 * Mapping used in Last_Activity_And_Statuses and passed to SetStatus, 
 * representing a collection of statuses. Use of this mapping with more than 
 * one member is deprecated.
 */
struct TP_QT_EXPORT MultipleStatusMap : public QMap<QString, QVariantMap>
{
    inline MultipleStatusMap() : QMap<QString, QVariantMap>() {}
    inline MultipleStatusMap(const QMap<QString, QVariantMap>& a) : QMap<QString, QVariantMap>(a) {}

    inline MultipleStatusMap& operator=(const QMap<QString, QVariantMap>& a)
    {
        *(static_cast<QMap<QString, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct NotDelegatedError
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT NotDelegatedError
{
    /**
     * the name of a D-Bus error describing what went wrong.
     */
    QString errorName;
    /**
     * a human-readable informative error message.
     */
    QString errorMessage;
};

TP_QT_EXPORT bool operator==(const NotDelegatedError& v1, const NotDelegatedError& v2);
inline bool operator!=(const NotDelegatedError& v1, const NotDelegatedError& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const NotDelegatedError& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, NotDelegatedError& val);

/**
 * \struct ObjectImmutablePropertiesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QDBusObjectPath, QVariantMap>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from object path to the immutable properties of the object.
 */
struct TP_QT_EXPORT ObjectImmutablePropertiesMap : public QMap<QDBusObjectPath, QVariantMap>
{
    inline ObjectImmutablePropertiesMap() : QMap<QDBusObjectPath, QVariantMap>() {}
    inline ObjectImmutablePropertiesMap(const QMap<QDBusObjectPath, QVariantMap>& a) : QMap<QDBusObjectPath, QVariantMap>(a) {}

    inline ObjectImmutablePropertiesMap& operator=(const QMap<QDBusObjectPath, QVariantMap>& a)
    {
        *(static_cast<QMap<QDBusObjectPath, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ObjectImmutablePropertiesMap values.
 */
typedef QList<ObjectImmutablePropertiesMap> ObjectImmutablePropertiesMapList;

/**
 * \struct ParamSpec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct representing an allowed parameter, as returned by GetParameters on 
 * the ConnectionManager interface.
 */
struct TP_QT_EXPORT ParamSpec
{
    /**
     * A string parameter name
     */
    QString name;
    /**
     * A bitwise OR of the parameter flags
     */
    uint flags;
    /**
     * A string containing the D-Bus type signature for this parameter
     */
    QString signature;
    /**
     * The default value (if the Has_Default flag is not present, there is no 
     * default and this takes some dummy value, which SHOULD be of the 
     * appropriate D-Bus type)
     */
    QDBusVariant defaultValue;
};

TP_QT_EXPORT bool operator==(const ParamSpec& v1, const ParamSpec& v2);
inline bool operator!=(const ParamSpec& v1, const ParamSpec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ParamSpec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ParamSpec& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ParamSpec values.
 */
typedef QList<ParamSpec> ParamSpecList;

/**
 * \struct PendingTextMessage
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (message ID, timestamp in seconds since 1970-01-01 00:00 UTC, 
 * sender&apos;s handle, message type, flags, text) representing a pending 
 * text message, as returned by ListPendingMessages. The arguments of the 
 * Received signal also match this struct&apos;s signature.
 */
struct TP_QT_EXPORT PendingTextMessage
{
    uint identifier;
    uint unixTimestamp;
    uint sender;
    uint messageType;
    uint flags;
    QString text;
};

TP_QT_EXPORT bool operator==(const PendingTextMessage& v1, const PendingTextMessage& v2);
inline bool operator!=(const PendingTextMessage& v1, const PendingTextMessage& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const PendingTextMessage& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, PendingTextMessage& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of PendingTextMessage values.
 */
typedef QList<PendingTextMessage> PendingTextMessageList;

/**
 * \struct PropertyFlagsChange
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (property ID, flags) representing a change to a property&apos;s 
 * flags, as seen in the PropertyFlagsChanged signal on the Properties 
 * interface.
 */
struct TP_QT_EXPORT PropertyFlagsChange
{
    uint propertyID;
    uint newFlags;
};

TP_QT_EXPORT bool operator==(const PropertyFlagsChange& v1, const PropertyFlagsChange& v2);
inline bool operator!=(const PropertyFlagsChange& v1, const PropertyFlagsChange& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const PropertyFlagsChange& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, PropertyFlagsChange& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of PropertyFlagsChange values.
 */
typedef QList<PropertyFlagsChange> PropertyFlagsChangeList;

/**
 * \struct PropertySpec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (property ID, property name, D-Bus signature, flags) representing 
 * a property, as returned by ListProperties on the Properties interface.
 */
struct TP_QT_EXPORT PropertySpec
{
    uint propertyID;
    QString name;
    QString signature;
    uint flags;
};

TP_QT_EXPORT bool operator==(const PropertySpec& v1, const PropertySpec& v2);
inline bool operator!=(const PropertySpec& v1, const PropertySpec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const PropertySpec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, PropertySpec& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of PropertySpec values.
 */
typedef QList<PropertySpec> PropertySpecList;

/**
 * \struct PropertyValue
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (property ID, value) representing a property&apos;s value, as seen 
 * in the PropertiesChanged signal on the Properties interface, returned by 
 * the GetProperties method and passed to the SetProperties method.
 */
struct TP_QT_EXPORT PropertyValue
{
    uint identifier;
    QDBusVariant value;
};

TP_QT_EXPORT bool operator==(const PropertyValue& v1, const PropertyValue& v2);
inline bool operator!=(const PropertyValue& v1, const PropertyValue& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const PropertyValue& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, PropertyValue& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of PropertyValue values.
 */
typedef QList<PropertyValue> PropertyValueList;

/**
 * \struct ProtocolPropertiesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QVariantMap>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * <p>A map from protocol identifiers supported by a connection
 *   manager to the immutable properties of the corresponding
 *    \endhtmlonly ProtocolInterface \htmlonly  objects.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT ProtocolPropertiesMap : public QMap<QString, QVariantMap>
{
    inline ProtocolPropertiesMap() : QMap<QString, QVariantMap>() {}
    inline ProtocolPropertiesMap(const QMap<QString, QVariantMap>& a) : QMap<QString, QVariantMap>(a) {}

    inline ProtocolPropertiesMap& operator=(const QMap<QString, QVariantMap>& a)
    {
        *(static_cast<QMap<QString, QVariantMap>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct QualifiedPropertyValueMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from strings representing D-Bus properties (by their namespaced 
 * names) to their values.
 */
struct TP_QT_EXPORT QualifiedPropertyValueMap : public QMap<QString, QDBusVariant>
{
    inline QualifiedPropertyValueMap() : QMap<QString, QDBusVariant>() {}
    inline QualifiedPropertyValueMap(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline QualifiedPropertyValueMap& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of QualifiedPropertyValueMap values.
 */
typedef QList<QualifiedPropertyValueMap> QualifiedPropertyValueMapList;

/**
 * \struct RTCPFeedbackMessage
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct defining an RTCP feedback message.
 */
struct TP_QT_EXPORT RTCPFeedbackMessage
{
    /**
     * Feedback type, for example &quot;ack&quot;, &quot;nack&quot;, or 
     * &quot;ccm&quot;.
     */
    QString type;
    /**
     * Feedback subtype, according to the Type, can be an empty string 
     * (&quot;&quot;), if there is no subtype. For example, generic nack is 
     * Type=&quot;nack&quot; Subtype=&quot;&quot;.
     */
    QString subtype;
    /**
     * Feedback parameters as a string. Format is defined in the relevant RFC
     */
    QString parameters;
};

TP_QT_EXPORT bool operator==(const RTCPFeedbackMessage& v1, const RTCPFeedbackMessage& v2);
inline bool operator!=(const RTCPFeedbackMessage& v1, const RTCPFeedbackMessage& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RTCPFeedbackMessage& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RTCPFeedbackMessage& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of RTCPFeedbackMessage values.
 */
typedef QList<RTCPFeedbackMessage> RTCPFeedbackMessageList;

/**
 * \struct RTPHeaderExtension
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct defining a RTP Header extension.
 */
struct TP_QT_EXPORT RTPHeaderExtension
{
    /**
     * Identifier to be negotiated.
     */
    uint ID;
    /**
     * Direction in which the Header Extension is negotiated.
     */
    uint direction;
    /**
     * URI defining the extension.
     */
    QString URI;
    /**
     * Feedback parameters as a string. Format is defined in the relevant RFC.
     */
    QString parameters;
};

TP_QT_EXPORT bool operator==(const RTPHeaderExtension& v1, const RTPHeaderExtension& v2);
inline bool operator!=(const RTPHeaderExtension& v1, const RTPHeaderExtension& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RTPHeaderExtension& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RTPHeaderExtension& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of RTPHeaderExtension values.
 */
typedef QList<RTPHeaderExtension> RTPHeaderExtensionsList;

/**
 * \struct RequestableChannelClass
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>Structure representing a class of channels that can be requested,
 *   identified by a set of properties that identify that class of
 *   channel.</p>
 * 
 * <div class="rationale">
 *   <p>This will often just be the channel type and the handle type,
 *     but can include other properties of the channel - for instance,
 *     encrypted channels might require properties that
 *     unencrypted channels do not, like an encryption key.</p>
 * </div>
 * 
 * <p>In some cases, these classes of channel may overlap, in the sense
 *   that one class fixes all the properties that another class does,
 *   plus some more properties.</p>
 * 
 * <div class="rationale">
 *   <p>For older clients to still be able to understand how to request
 *     channels in the presence of a hypothetical &quot;encryption&quot; interface,
 *     we'd need to represent it like this:</p>
 * 
 *   <ul>
 *     <li>class 1: ChannelType = Text, TargetHandleType = CONTACT</li>
 *     <li>class 2: Channel.ChannelType = Text,
 *       Channel.TargetHandleType = CONTACT,
 *       Encryption.Encrypted = TRUE</li>
 *   </ul>
 * </div>
 * \endhtmlonly
 */
struct TP_QT_EXPORT RequestableChannelClass
{
    /**
     * \htmlonly
     * <p>The property values that identify this requestable channel class.
     *   These properties MUST be included in requests for a channel of this
     *   class, and MUST take these values.</p>
     * 
     * <p>Clients that do not understand the semantics of all the
     *   Fixed_Properties MUST NOT request channels of this class, since
     *   they would be unable to avoid making an incorrect request.</p>
     * 
     * <p>This implies that connection managers wishing to make channels
     *   available to old or minimal clients SHOULD have a channel class
     *   with the minimum number of Fixed_Properties, and MAY additionally
     *   have channel classes with extra Fixed_Properties.</p>
     * 
     * <p>Interface designers SHOULD avoid introducing fixed properties
     *   whose types are not serializable in a <code>.manager</code>
     *   file.</p>
     * 
     * <div class="rationale">
     *   <p>Connection managers with a fixed property that is not
     *     serializable cannot have a complete <code>.manager</code>
     *     file.</p>
     * </div>
     * \endhtmlonly
     */
    QVariantMap fixedProperties;
    /**
     * \htmlonly
     * <p>Properties that MAY be set when requesting a channel of this
     *   channel type and handle type.</p>
     * 
     * <p>This array MUST NOT include properties that are in the
     *   Fixed_Properties mapping.</p>
     * 
     * <p>Properties in this array may either be required or optional,
     *   according to their documented semantics.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, if
     *     TargetHandleType takes a value that is not Handle_Type_None,
     *     one or the other of TargetHandle and TargetID is required.
     *     Clients are expected to understand the documented relationship
     *     between the properties, so we do not have separate arrays
     *     of required and optional properties.</p>
     * </div>
     * 
     * <p>If this array contains the
     *    \endhtmlonly org.freedesktop.Telepathy.Channel.FUTURE.Bundle \htmlonly 
     *   property, then this class of channel can be combined with other
     *   channels with that property in a request, or added to an existing
     *   bundle. If not, this signifies that the connection manager is
     *   unable to mark channels of this class as part of a bundle - this
     *   means that to the remote contact they are likely to be
     *   indistinguishable from channels requested separately.</p>
     * \endhtmlonly
     */
    QStringList allowedProperties;
};

TP_QT_EXPORT bool operator==(const RequestableChannelClass& v1, const RequestableChannelClass& v2);
inline bool operator!=(const RequestableChannelClass& v1, const RequestableChannelClass& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RequestableChannelClass& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RequestableChannelClass& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of RequestableChannelClass values.
 */
typedef QList<RequestableChannelClass> RequestableChannelClassList;

/**
 * \struct RichPresenceAccessControl
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>An access control mode for extended presence items like geolocation.
 *   This type isn't actually used by the SimplePresence interface, but
 *   it's included here so it can be referenced by rich presence interfaces
 *   such as  \endhtmlonly ConnectionInterfaceLocationInterface \htmlonly .</p>
 * 
 * <p> \endhtmlonly ConnectionInterfaceLocationInterface \htmlonly 
 *   uses this for historical reasons, new interfaces will use
 *   <tp:type>Access_Control_Type</tp:type>.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT RichPresenceAccessControl
{
    /**
     * The type of access control to apply.
     */
    uint type;
    /**
     * Any additional information required by the Type. The required type and 
     * semantics are defined for each Rich_Presence_Access_Control_Type.
     */
    QDBusVariant detail;
};

TP_QT_EXPORT bool operator==(const RichPresenceAccessControl& v1, const RichPresenceAccessControl& v2);
inline bool operator!=(const RichPresenceAccessControl& v1, const RichPresenceAccessControl& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RichPresenceAccessControl& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RichPresenceAccessControl& val);

/**
 * \struct RoomInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT RoomInfo
{
    uint handle;
    QString channelType;
    QVariantMap info;
};

TP_QT_EXPORT bool operator==(const RoomInfo& v1, const RoomInfo& v2);
inline bool operator!=(const RoomInfo& v1, const RoomInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RoomInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RoomInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of RoomInfo values.
 */
typedef QList<RoomInfo> RoomInfoList;

/**
 * \struct ServicePoint
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A service point.
 */
struct TP_QT_EXPORT ServicePoint
{
    /**
     * The service type.
     */
    uint servicePointType;
    /**
     * String representation of the service point. The representation is 
     * service specific; it may be a &apos;service&apos; Uniform Resource Name 
     * as specified by RFC 5031, or may be in some other form. Empty, unused 
     * or unknown value is represented by &quot;&quot;.
     */
    QString service;
};

TP_QT_EXPORT bool operator==(const ServicePoint& v1, const ServicePoint& v2);
inline bool operator!=(const ServicePoint& v1, const ServicePoint& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ServicePoint& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ServicePoint& val);

/**
 * \struct SimplePresence
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct representing the presence of a contact.
 */
struct TP_QT_EXPORT SimplePresence
{
    /**
     * The presence type, e.g. Connection_Presence_Type_Away.
     */
    uint type;
    /**
     * The string identifier of the status, e.g. &quot;brb&quot;, as defined 
     * in the Statuses property.
     */
    QString status;
    /**
     * \htmlonly
     * <p>The user-defined status message, e.g. &quot;Back soon!&quot;.</p>
     * 
     * <p>Clients SHOULD set the status message for the local
     *   user to the empty string, unless the user has actually provided
     *   a specific message (i.e. one that conveys more information than the
     *   Status).</p>
     * 
     * <p>User interfaces SHOULD regard an empty status message as unset,
     *   and MAY replace it with a localized string corresponding to the
     *   Status or Type.</p>
     * 
     * <div class="rationale">
     *   Use case: Daf sets his status in Empathy by choosing the Welsh
     *   translation of &quot;Available&quot; from a menu.
     *   It is more informative for his English-speaking colleagues
     *   to see the English translation of &quot;Available&quot; (as localized
     *   by their own clients) than to see &quot;Ar Gael&quot; (which they don't
     *   understand anyway).
     * </div>
     * \endhtmlonly
     */
    QString statusMessage;
};

TP_QT_EXPORT bool operator==(const SimplePresence& v1, const SimplePresence& v2);
inline bool operator!=(const SimplePresence& v1, const SimplePresence& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SimplePresence& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SimplePresence& val);

/**
 * \struct SimpleStatusSpec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct containing information about a status.
 */
struct TP_QT_EXPORT SimpleStatusSpec
{
    /**
     * The type of a presence. This SHOULD NOT be used as a way to set 
     * statuses that the client does not recognise (as explained in 
     * SetPresence), but MAY be used to check that the client&apos;s 
     * assumptions about a particular status name match the connection 
     * manager&apos;s.
     */
    uint type;
    /**
     * If true, the user can set this status on themselves using SetPresence.
     */
    bool maySetOnSelf;
    /**
     * If true, a non-empty message can be set for this status. Otherwise, the 
     * empty string is the only acceptable message. On IRC you can be Away 
     * with a status message, but if you are available you cannot set a status 
     * message.
     */
    bool canHaveMessage;
};

TP_QT_EXPORT bool operator==(const SimpleStatusSpec& v1, const SimpleStatusSpec& v2);
inline bool operator!=(const SimpleStatusSpec& v1, const SimpleStatusSpec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SimpleStatusSpec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SimpleStatusSpec& val);

/**
 * \struct SingleContactAttributesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * Some of the attributes of a single contact.
 */
struct TP_QT_EXPORT SingleContactAttributesMap : public QMap<QString, QDBusVariant>
{
    inline SingleContactAttributesMap() : QMap<QString, QDBusVariant>() {}
    inline SingleContactAttributesMap(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline SingleContactAttributesMap& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct SocketAddressIP
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * An IP address and port.
 */
struct TP_QT_EXPORT SocketAddressIP
{
    /**
     * Either a dotted-quad IPv4 address literal as for Socket_Address_IPv4, 
     * or an RFC2373 IPv6 address as for Socket_Address_IPv6.
     */
    QString address;
    /**
     * The TCP or UDP port number.
     */
    ushort port;
};

TP_QT_EXPORT bool operator==(const SocketAddressIP& v1, const SocketAddressIP& v2);
inline bool operator!=(const SocketAddressIP& v1, const SocketAddressIP& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SocketAddressIP& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SocketAddressIP& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of SocketAddressIP values.
 */
typedef QList<SocketAddressIP> SocketAddressIPList;

/**
 * \struct SocketAddressIPv4
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * An IPv4 address and port.
 */
struct TP_QT_EXPORT SocketAddressIPv4
{
    /**
     * A dotted-quad IPv4 address literal: four ASCII decimal numbers, each 
     * between 0 and 255 inclusive, e.g. &quot;192.168.0.1&quot;.
     */
    QString address;
    /**
     * The TCP or UDP port number.
     */
    ushort port;
};

TP_QT_EXPORT bool operator==(const SocketAddressIPv4& v1, const SocketAddressIPv4& v2);
inline bool operator!=(const SocketAddressIPv4& v1, const SocketAddressIPv4& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SocketAddressIPv4& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SocketAddressIPv4& val);

/**
 * \struct SocketAddressIPv6
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * An IPv6 address and port.
 */
struct TP_QT_EXPORT SocketAddressIPv6
{
    /**
     * An IPv6 address literal as specified by RFC2373 section 2.2, e.g. 
     * &quot;2001:DB8::8:800:200C:4171&quot;.
     */
    QString address;
    /**
     * The TCP or UDP port number.
     */
    ushort port;
};

TP_QT_EXPORT bool operator==(const SocketAddressIPv6& v1, const SocketAddressIPv6& v2);
inline bool operator!=(const SocketAddressIPv6& v1, const SocketAddressIPv6& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SocketAddressIPv6& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SocketAddressIPv6& val);

/**
 * \struct SocketNetmaskIPv4
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * An IPv4 network or subnet.
 */
struct TP_QT_EXPORT SocketNetmaskIPv4
{
    /**
     * A dotted-quad IPv4 address literal: four ASCII decimal numbers, each 
     * between 0 and 255 inclusive, e.g. &quot;192.168.0.1&quot;.
     */
    QString address;
    /**
     * The number of leading bits of the address that must match, for this 
     * netmask to be considered to match an address.
     */
    uchar prefixLength;
};

TP_QT_EXPORT bool operator==(const SocketNetmaskIPv4& v1, const SocketNetmaskIPv4& v2);
inline bool operator!=(const SocketNetmaskIPv4& v1, const SocketNetmaskIPv4& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SocketNetmaskIPv4& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SocketNetmaskIPv4& val);

/**
 * \struct SocketNetmaskIPv6
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * An IPv6 network or subnet.
 */
struct TP_QT_EXPORT SocketNetmaskIPv6
{
    /**
     * An IPv6 address literal as specified by RFC2373 section 2.2, e.g. 
     * &quot;2001:DB8::8:800:200C:4171&quot;.
     */
    QString address;
    /**
     * The number of leading bits of the address that must match, for this 
     * netmask to be considered to match an address.
     */
    uchar prefixLength;
};

TP_QT_EXPORT bool operator==(const SocketNetmaskIPv6& v1, const SocketNetmaskIPv6& v2);
inline bool operator!=(const SocketNetmaskIPv6& v1, const SocketNetmaskIPv6& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const SocketNetmaskIPv6& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, SocketNetmaskIPv6& val);

/**
 * \struct StreamCredentials
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A username and password pair.
 */
struct TP_QT_EXPORT StreamCredentials
{
    /**
     * The username.
     */
    QString username;
    /**
     * The password.
     */
    QString password;
};

TP_QT_EXPORT bool operator==(const StreamCredentials& v1, const StreamCredentials& v2);
inline bool operator!=(const StreamCredentials& v1, const StreamCredentials& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const StreamCredentials& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, StreamCredentials& val);

/**
 * \struct StringStringMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from strings to strings representing extra key-value pairs.
 */
struct TP_QT_EXPORT StringStringMap : public QMap<QString, QString>
{
    inline StringStringMap() : QMap<QString, QString>() {}
    inline StringStringMap(const QMap<QString, QString>& a) : QMap<QString, QString>(a) {}

    inline StringStringMap& operator=(const QMap<QString, QString>& a)
    {
        *(static_cast<QMap<QString, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of StringStringMap values.
 */
typedef QList<StringStringMap> StringStringMapList;

/**
 * \struct StringVariantMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QDBusVariant>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from strings to variants representing extra key-value pairs.
 */
struct TP_QT_EXPORT StringVariantMap : public QMap<QString, QDBusVariant>
{
    inline StringVariantMap() : QMap<QString, QDBusVariant>() {}
    inline StringVariantMap(const QMap<QString, QDBusVariant>& a) : QMap<QString, QDBusVariant>(a) {}

    inline StringVariantMap& operator=(const QMap<QString, QDBusVariant>& a)
    {
        *(static_cast<QMap<QString, QDBusVariant>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of StringVariantMap values.
 */
typedef QList<StringVariantMap> StringVariantMapList;

/**
 * \struct SupportedSocketMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, UIntList>, but needed to have a discrete type in the Qt type system.
 * 
 * The supported socket address and access-control types for tubes. See 
 * GetAvailableStreamTubeTypes.
 */
struct TP_QT_EXPORT SupportedSocketMap : public QMap<uint, UIntList>
{
    inline SupportedSocketMap() : QMap<uint, UIntList>() {}
    inline SupportedSocketMap(const QMap<uint, UIntList>& a) : QMap<uint, UIntList>(a) {}

    inline SupportedSocketMap& operator=(const QMap<uint, UIntList>& a)
    {
        *(static_cast<QMap<uint, UIntList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct TLSCertificateRejection
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>Struct representing one reason why a TLS certificate was rejected.</p>
 * <p>Since there can be multiple things wrong with a TLS certificate,
 * arrays of this type are used to represent lists of reasons for
 * rejection. In that case, the most important reason SHOULD be placed
 * first in the list.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT TLSCertificateRejection
{
    /**
     * \htmlonly
     *           <p>The value of the TLS_Certificate_Reject_Reason enumeration for
     *           this certificate rejection.
     *           <div class="rationale">
     *             Clients that do not understand the <code>Error</code> member,
     *             which may be implementation-specific, can use this property to
     *             classify rejection reasons into common categories.
     *           </div>
     * 	  </p>
     * \endhtmlonly
     */
    uint reason;
    /**
     * \htmlonly
     * <p>The DBus error name for this certificate rejection.</p>
     * <p>This MAY correspond to the value of the <code>Reason</code> member,
     * or MAY be a more specific D-Bus error name, perhaps implementation-specific.</p>
     * \endhtmlonly
     */
    QString error;
    /**
     * \htmlonly
     * <p>Additional information about why the certificate was rejected.
     * This MAY also include one or more of the following well-known keys:</p>
     * <p>
     * <dl>
     *   <dt>user-requested (b)</dt>
     *   <dd>True if the error was due to an user-requested rejection of
     *   the certificate; False if there was an unrecoverable error in the
     *   verification process.</dd>
     *   <dt>expected-hostname (s)</dt>
     *   <dd>If the rejection reason is Hostname_Mismatch, the hostname that
     *   the server certificate was expected to have.</dd>
     *   <dt>certificate-hostname (s)</dt>
     *   <dd>If the rejection reason is Hostname_Mismatch, the hostname of
     *   the certificate that was presented.
     *   <div class="rationale">
     *     <p>For instance, if you try to connect to gmail.com but are presented
     *     with a TLS certificate issued to evil.example.org, the error details
     *     for Hostname_Mismatch MAY include:</p>
     *     <pre>
     *       {
     *         'expected-hostname': 'gmail.com',
     *         'certificate-hostname': 'evil.example.org',
     *       }
     *     </pre>
     *   </div>
     *   </dd>
     *   <dt>debug-message (s)</dt>
     *   <dd>Debugging information on the error, corresponding to the
     *   message part of a D-Bus error message, which SHOULD NOT be
     *   displayed to users under normal circumstances</dd>
     * </dl>
     * </p>
     * \endhtmlonly
     */
    QVariantMap details;
};

TP_QT_EXPORT bool operator==(const TLSCertificateRejection& v1, const TLSCertificateRejection& v2);
inline bool operator!=(const TLSCertificateRejection& v1, const TLSCertificateRejection& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const TLSCertificateRejection& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, TLSCertificateRejection& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of TLSCertificateRejection values.
 */
typedef QList<TLSCertificateRejection> TLSCertificateRejectionList;

/**
 * \struct TubeInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A struct (tube ID, initiator handle, tube type, service name, parameters, 
 * state) representing a tube, as returned by ListTubes on the Tubes channel 
 * type.
 */
struct TP_QT_EXPORT TubeInfo
{
    uint identifier;
    uint initiator;
    uint type;
    QString service;
    QVariantMap parameters;
    uint state;
};

TP_QT_EXPORT bool operator==(const TubeInfo& v1, const TubeInfo& v2);
inline bool operator!=(const TubeInfo& v1, const TubeInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const TubeInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, TubeInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of TubeInfo values.
 */
typedef QList<TubeInfo> TubeInfoList;

/**
 * \struct VCardFieldAddressMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, QString>, but needed to have a discrete type in the Qt type system.
 * 
 * \htmlonly
 * <p>A mapping of vCard fields and addresses equivalent to a
 *   particular contact's protocol identifier. For instance,
 *   on XMPP this would contain <code>x-jabber</code> for all
 *   contacts, and <code>x-facebook-id</code> for contacts on
 *   Facebook's server.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT VCardFieldAddressMap : public QMap<QString, QString>
{
    inline VCardFieldAddressMap() : QMap<QString, QString>() {}
    inline VCardFieldAddressMap(const QMap<QString, QString>& a) : QMap<QString, QString>(a) {}

    inline VCardFieldAddressMap& operator=(const QMap<QString, QString>& a)
    {
        *(static_cast<QMap<QString, QString>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct VideoResolution
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT VideoResolution
{
    /**
     * With of the video stream.
     */
    uint width;
    /**
     * Height of the video stream.
     */
    uint height;
};

TP_QT_EXPORT bool operator==(const VideoResolution& v1, const VideoResolution& v2);
inline bool operator!=(const VideoResolution& v1, const VideoResolution& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const VideoResolution& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, VideoResolution& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of VideoResolution values.
 */
typedef QList<VideoResolution> VideoResolutionStruct;

/**
 * \struct CandidatePair
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A Pair of candidates.
 */
struct TP_QT_EXPORT CandidatePair
{
    /**
     * The local candidate.
     */
    Candidate local;
    /**
     * The remote candidate.
     */
    Candidate remote;
};

TP_QT_EXPORT bool operator==(const CandidatePair& v1, const CandidatePair& v2);
inline bool operator!=(const CandidatePair& v1, const CandidatePair& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const CandidatePair& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, CandidatePair& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of CandidatePair values.
 */
typedef QList<CandidatePair> CandidatePairList;

/**
 * \struct Codec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A description of a codec.
 */
struct TP_QT_EXPORT Codec
{
    /**
     * \htmlonly
     * Numeric identifier for the codec. This will be used as the PT in the
     * SDP or content description.
     * \endhtmlonly
     */
    uint identifier;
    /**
     * \htmlonly
     * The name of the codec.
     * \endhtmlonly
     */
    QString name;
    /**
     * \htmlonly
     * The clockrate of the codec.
     * \endhtmlonly
     */
    uint clockrate;
    /**
     * \htmlonly
     * Number of channels of the codec if applicable, otherwise 0.
     * \endhtmlonly
     */
    uint channels;
    /**
     * \htmlonly
     * This should be set to true in calls to  \endhtmlonly CallContentMediaDescriptionInterface::Accept() \htmlonly  and
     *  \endhtmlonly UpdateLocalMediaDescription() \htmlonly  if this
     * codec has changed in a way that needs to be signalled over the
     * network. If it is set to false, the CM is allowed ignore any
     * differences between the current parameters and the previous ones
     * <div class="rationale">
     *   This mechanism may be used to save bandwidth and avoid the CM
     *   having to calculate diffs against previous versions of this
     *   struct, which can lead to false-positives (e.g. redundant ptime
     *   updates).
     * </div>
     * \endhtmlonly
     */
    bool updated;
    /**
     * \htmlonly
     * Extra parameters for this codec.
     * \endhtmlonly
     */
    StringStringMap parameters;
};

TP_QT_EXPORT bool operator==(const Codec& v1, const Codec& v2);
inline bool operator!=(const Codec& v1, const Codec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const Codec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, Codec& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of Codec values.
 */
typedef QList<Codec> CodecList;

/**
 * \struct ContactCapabilitiesMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, RequestableChannelClassList>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping from contact handle to their capabilities.
 */
struct TP_QT_EXPORT ContactCapabilitiesMap : public QMap<uint, RequestableChannelClassList>
{
    inline ContactCapabilitiesMap() : QMap<uint, RequestableChannelClassList>() {}
    inline ContactCapabilitiesMap(const QMap<uint, RequestableChannelClassList>& a) : QMap<uint, RequestableChannelClassList>(a) {}

    inline ContactCapabilitiesMap& operator=(const QMap<uint, RequestableChannelClassList>& a)
    {
        *(static_cast<QMap<uint, RequestableChannelClassList>*>(this)) = a;
        return *this;
    }
};

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ContactCapabilitiesMap values.
 */
typedef QList<ContactCapabilitiesMap> ContactCapabilitiesMapList;

/**
 * \struct ContactInfoMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, ContactInfoFieldList>, but needed to have a discrete type in the Qt type system.
 * 
 * A dictionary whose keys are contact handles and whose values are contact 
 * information..
 */
struct TP_QT_EXPORT ContactInfoMap : public QMap<uint, ContactInfoFieldList>
{
    inline ContactInfoMap() : QMap<uint, ContactInfoFieldList>() {}
    inline ContactInfoMap(const QMap<uint, ContactInfoFieldList>& a) : QMap<uint, ContactInfoFieldList>(a) {}

    inline ContactInfoMap& operator=(const QMap<uint, ContactInfoFieldList>& a)
    {
        *(static_cast<QMap<uint, ContactInfoFieldList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSearchResultMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, ContactInfoFieldList>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contact identifier to search result, emitted in the 
 * SearchResultReceived signal.
 */
struct TP_QT_EXPORT ContactSearchResultMap : public QMap<QString, ContactInfoFieldList>
{
    inline ContactSearchResultMap() : QMap<QString, ContactInfoFieldList>() {}
    inline ContactSearchResultMap(const QMap<QString, ContactInfoFieldList>& a) : QMap<QString, ContactInfoFieldList>(a) {}

    inline ContactSearchResultMap& operator=(const QMap<QString, ContactInfoFieldList>& a)
    {
        *(static_cast<QMap<QString, ContactInfoFieldList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactSubscriptionMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, ContactSubscriptions>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contacts to their subscribe, publish and publish-request 
 * attributes.
 */
struct TP_QT_EXPORT ContactSubscriptionMap : public QMap<uint, ContactSubscriptions>
{
    inline ContactSubscriptionMap() : QMap<uint, ContactSubscriptions>() {}
    inline ContactSubscriptionMap(const QMap<uint, ContactSubscriptions>& a) : QMap<uint, ContactSubscriptions>(a) {}

    inline ContactSubscriptionMap& operator=(const QMap<uint, ContactSubscriptions>& a)
    {
        *(static_cast<QMap<uint, ContactSubscriptions>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct HandlerCapabilities
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * A structure representing the capabilities of a single client.
 */
struct TP_QT_EXPORT HandlerCapabilities
{
    /**
     * For implementations of the Client interface, the well-known bus name 
     * name of the client; for any other process, any other reversed domain 
     * name that uniquely identifies it.
     */
    QString wellKnownName;
    /**
     * \htmlonly
     * An array of channel classes that can be handled by this client.
     * This will usually be a copy of the client's  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     * property.
     * \endhtmlonly
     */
    StringVariantMapList channelClasses;
    /**
     * \htmlonly
     * An array of client capabilities supported by this client, to be
     * used by the connection manager to determine what capabilities to
     * advertise. This will usually be a copy of the client's  \endhtmlonly \link ClientHandlerInterface::requestPropertyCapabilities() ClientHandlerInterface::Capabilities \endlink \htmlonly 
     * property.
     * \endhtmlonly
     */
    QStringList capabilities;
};

TP_QT_EXPORT bool operator==(const HandlerCapabilities& v1, const HandlerCapabilities& v2);
inline bool operator!=(const HandlerCapabilities& v1, const HandlerCapabilities& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const HandlerCapabilities& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, HandlerCapabilities& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of HandlerCapabilities values.
 */
typedef QList<HandlerCapabilities> HandlerCapabilitiesList;

/**
 * \struct LastActivityAndStatuses
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * Structure representing a contact&apos;s presence, containing a 
 * last-activity time (deprecated) and a Multiple_Status_Map.
 */
struct TP_QT_EXPORT LastActivityAndStatuses
{
    uint lastActivity;
    MultipleStatusMap statuses;
};

TP_QT_EXPORT bool operator==(const LastActivityAndStatuses& v1, const LastActivityAndStatuses& v2);
inline bool operator!=(const LastActivityAndStatuses& v1, const LastActivityAndStatuses& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const LastActivityAndStatuses& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, LastActivityAndStatuses& val);

/**
 * \struct MailURL
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * \htmlonly
 * <p>A structure containing the required information to open a web-based
 *   e-mail UI, without needing re-authentication (if possible).</p>
 * 
 * <p>Because the URL and POST data frequently contain short-lived
 *   credential tokens, a new URL should be requested (by calling one of
 *   the methods that returns a Mail_URL) for each visit to the web-based
 *   UI, and the URL should be visited soon after it is returned.</p>
 * \endhtmlonly
 */
struct TP_QT_EXPORT MailURL
{
    /**
     * The URL to which to send a request.
     */
    QString URL;
    /**
     * The HTTP method of the request.
     */
    uint method;
    /**
     * An array of name-value pairs containing the POST data to use when 
     * opening the URL. This MUST be an empty array if the Method is not POST.
     */
    HTTPPostDataList postData;
};

TP_QT_EXPORT bool operator==(const MailURL& v1, const MailURL& v2);
inline bool operator!=(const MailURL& v1, const MailURL& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MailURL& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MailURL& val);

/**
 * \struct MediaStreamHandlerCandidate
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT MediaStreamHandlerCandidate
{
    QString name;
    MediaStreamHandlerTransportList transports;
};

TP_QT_EXPORT bool operator==(const MediaStreamHandlerCandidate& v1, const MediaStreamHandlerCandidate& v2);
inline bool operator!=(const MediaStreamHandlerCandidate& v1, const MediaStreamHandlerCandidate& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaStreamHandlerCandidate& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaStreamHandlerCandidate& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MediaStreamHandlerCandidate values.
 */
typedef QList<MediaStreamHandlerCandidate> MediaStreamHandlerCandidateList;

/**
 * \struct MediaStreamHandlerCodec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * Information about a codec supported by a client or a peer&apos;s client.
 */
struct TP_QT_EXPORT MediaStreamHandlerCodec
{
    /**
     * The codec&apos;s payload identifier, as per RFC 3551 (static or dynamic)
     */
    uint codecID;
    /**
     * The codec&apos;s name
     */
    QString name;
    /**
     * Type of stream this codec supports
     */
    uint mediaType;
    /**
     * Sampling frequency in Hertz
     */
    uint clockRate;
    /**
     * Number of supported channels
     */
    uint numberOfChannels;
    /**
     * Codec-specific optional parameters
     */
    StringStringMap parameters;
};

TP_QT_EXPORT bool operator==(const MediaStreamHandlerCodec& v1, const MediaStreamHandlerCodec& v2);
inline bool operator!=(const MediaStreamHandlerCodec& v1, const MediaStreamHandlerCodec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const MediaStreamHandlerCodec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, MediaStreamHandlerCodec& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of MediaStreamHandlerCodec values.
 */
typedef QList<MediaStreamHandlerCodec> MediaStreamHandlerCodecList;

/**
 * \struct NotDelegatedMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QDBusObjectPath, NotDelegatedError>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping associating not delegated channel with an error.
 */
struct TP_QT_EXPORT NotDelegatedMap : public QMap<QDBusObjectPath, NotDelegatedError>
{
    inline NotDelegatedMap() : QMap<QDBusObjectPath, NotDelegatedError>() {}
    inline NotDelegatedMap(const QMap<QDBusObjectPath, NotDelegatedError>& a) : QMap<QDBusObjectPath, NotDelegatedError>(a) {}

    inline NotDelegatedMap& operator=(const QMap<QDBusObjectPath, NotDelegatedError>& a)
    {
        *(static_cast<QMap<QDBusObjectPath, NotDelegatedError>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct RTCPFeedbackMessageProperties
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT RTCPFeedbackMessageProperties
{
    /**
     * The minimum interval between two regular RTCP packets in milliseconds 
     * for this content. If no special value is desired, one should put 
     * MAXUINT (0xFFFFFFFF). Implementors and users of Call&apos;s 
     * RTCPFeedback should not use the MAXUINT default. Instead, in RTP/AVP, 
     * the default should be 5000 (5 seconds). If using the RTP/AVPF profile, 
     * it can be set to a lower value, the default being 0.
     */
    uint RTCPMinimumInterval;
    /**
     * The RTCP feedback messages for this codec.
     */
    RTCPFeedbackMessageList messages;
};

TP_QT_EXPORT bool operator==(const RTCPFeedbackMessageProperties& v1, const RTCPFeedbackMessageProperties& v2);
inline bool operator!=(const RTCPFeedbackMessageProperties& v1, const RTCPFeedbackMessageProperties& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const RTCPFeedbackMessageProperties& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, RTCPFeedbackMessageProperties& val);

/**
 * \struct ServicePointInfo
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 * 
 * Description of a service point and IDs which are mapped to it. An example 
 * Service Point info for GSM emergency calls (callable through 
 * &quot;911&quot; and &quot;112&quot;) could look like: ServicePointInfo = ( 
 * Service_Point: ( Service_Point_Type: 1 (Emergency), Service_Point: 
 * &quot;urn:service:sos&quot; ), Service_IDs: [ &quot;911&quot;, 
 * &quot;112&quot; ] )
 */
struct TP_QT_EXPORT ServicePointInfo
{
    /**
     * The service point.
     */
    ServicePoint servicePoint;
    /**
     * A list of IDs that are mapped to this service. This is provided as a 
     * convenience for the UIs, but the preferred method for requesting 
     * channel to a service is by setting the InitialServicePoint property in 
     * a channel request.
     */
    QStringList serviceIDs;
};

TP_QT_EXPORT bool operator==(const ServicePointInfo& v1, const ServicePointInfo& v2);
inline bool operator!=(const ServicePointInfo& v1, const ServicePointInfo& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const ServicePointInfo& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, ServicePointInfo& val);

/**
 * \ingroup list
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Array of ServicePointInfo values.
 */
typedef QList<ServicePointInfo> ServicePointInfoList;

/**
 * \struct SimpleContactPresences
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, SimplePresence>, but needed to have a discrete type in the Qt type system.
 * 
 * Mapping returned by GetPresences and signalled by PresencesChanged, 
 * indicating the presence of a number of contacts.
 */
struct TP_QT_EXPORT SimpleContactPresences : public QMap<uint, SimplePresence>
{
    inline SimpleContactPresences() : QMap<uint, SimplePresence>() {}
    inline SimpleContactPresences(const QMap<uint, SimplePresence>& a) : QMap<uint, SimplePresence>(a) {}

    inline SimpleContactPresences& operator=(const QMap<uint, SimplePresence>& a)
    {
        *(static_cast<QMap<uint, SimplePresence>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct SimpleStatusSpecMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, SimpleStatusSpec>, but needed to have a discrete type in the Qt type system.
 * 
 * A mapping describing possible statuses.
 */
struct TP_QT_EXPORT SimpleStatusSpecMap : public QMap<QString, SimpleStatusSpec>
{
    inline SimpleStatusSpecMap() : QMap<QString, SimpleStatusSpec>() {}
    inline SimpleStatusSpecMap(const QMap<QString, SimpleStatusSpec>& a) : QMap<QString, SimpleStatusSpec>(a) {}

    inline SimpleStatusSpecMap& operator=(const QMap<QString, SimpleStatusSpec>& a)
    {
        *(static_cast<QMap<QString, SimpleStatusSpec>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct StatusSpec
 * \ingroup struct
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Structure type generated from the specification.
 */
struct TP_QT_EXPORT StatusSpec
{
    uint type;
    bool maySetOnSelf;
    bool exclusive;
    StringStringMap parameterTypes;
};

TP_QT_EXPORT bool operator==(const StatusSpec& v1, const StatusSpec& v2);
inline bool operator!=(const StatusSpec& v1, const StatusSpec& v2)
{
    return !operator==(v1, v2);
}
TP_QT_EXPORT QDBusArgument& operator<<(QDBusArgument& arg, const StatusSpec& val);
TP_QT_EXPORT const QDBusArgument& operator>>(const QDBusArgument& arg, StatusSpec& val);

/**
 * \struct ContactCodecMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, CodecList>, but needed to have a discrete type in the Qt type system.
 * 
 * A map from contact to the list of codecs he or she supports.
 */
struct TP_QT_EXPORT ContactCodecMap : public QMap<uint, CodecList>
{
    inline ContactCodecMap() : QMap<uint, CodecList>() {}
    inline ContactCodecMap(const QMap<uint, CodecList>& a) : QMap<uint, CodecList>(a) {}

    inline ContactCodecMap& operator=(const QMap<uint, CodecList>& a)
    {
        *(static_cast<QMap<uint, CodecList>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct ContactPresences
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, LastActivityAndStatuses>, but needed to have a discrete type in the Qt type system.
 * 
 * Mapping returned by GetPresence and signalled by PresenceUpdate, where the 
 * keys are contacts and the values represent their presences.
 */
struct TP_QT_EXPORT ContactPresences : public QMap<uint, LastActivityAndStatuses>
{
    inline ContactPresences() : QMap<uint, LastActivityAndStatuses>() {}
    inline ContactPresences(const QMap<uint, LastActivityAndStatuses>& a) : QMap<uint, LastActivityAndStatuses>(a) {}

    inline ContactPresences& operator=(const QMap<uint, LastActivityAndStatuses>& a)
    {
        *(static_cast<QMap<uint, LastActivityAndStatuses>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct RTCPFeedbackMessageMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<uint, RTCPFeedbackMessageProperties>, but needed to have a discrete type in the Qt type system.
 * 
 * A map of codec and its feedback properties.
 */
struct TP_QT_EXPORT RTCPFeedbackMessageMap : public QMap<uint, RTCPFeedbackMessageProperties>
{
    inline RTCPFeedbackMessageMap() : QMap<uint, RTCPFeedbackMessageProperties>() {}
    inline RTCPFeedbackMessageMap(const QMap<uint, RTCPFeedbackMessageProperties>& a) : QMap<uint, RTCPFeedbackMessageProperties>(a) {}

    inline RTCPFeedbackMessageMap& operator=(const QMap<uint, RTCPFeedbackMessageProperties>& a)
    {
        *(static_cast<QMap<uint, RTCPFeedbackMessageProperties>*>(this)) = a;
        return *this;
    }
};

/**
 * \struct StatusSpecMap
 * \ingroup mapping
 * \headerfile TelepathyQt/types.h <TelepathyQt/Types>
 *
 * Mapping type generated from the specification. Convertible with
 * QMap<QString, StatusSpec>, but needed to have a discrete type in the Qt type system.
 */
struct TP_QT_EXPORT StatusSpecMap : public QMap<QString, StatusSpec>
{
    inline StatusSpecMap() : QMap<QString, StatusSpec>() {}
    inline StatusSpecMap(const QMap<QString, StatusSpec>& a) : QMap<QString, StatusSpec>(a) {}

    inline StatusSpecMap& operator=(const QMap<QString, StatusSpec>& a)
    {
        *(static_cast<QMap<QString, StatusSpec>*>(this)) = a;
        return *this;
    }
};


} // namespace Tp

Q_DECLARE_METATYPE(Tp::AccessControl)
Q_DECLARE_METATYPE(Tp::AddressingNormalizationMap)
Q_DECLARE_METATYPE(Tp::AliasMap)
Q_DECLARE_METATYPE(Tp::AliasPair)
Q_DECLARE_METATYPE(Tp::AliasPairList)
Q_DECLARE_METATYPE(Tp::Avatar)
Q_DECLARE_METATYPE(Tp::AvatarTokenMap)
Q_DECLARE_METATYPE(Tp::ByteArrayList)
Q_DECLARE_METATYPE(Tp::CallMemberMap)
Q_DECLARE_METATYPE(Tp::CallMemberMapList)
Q_DECLARE_METATYPE(Tp::CallStateReason)
Q_DECLARE_METATYPE(Tp::Candidate)
Q_DECLARE_METATYPE(Tp::CandidateInfo)
Q_DECLARE_METATYPE(Tp::CandidateList)
Q_DECLARE_METATYPE(Tp::CandidatePair)
Q_DECLARE_METATYPE(Tp::CandidatePairList)
Q_DECLARE_METATYPE(Tp::CapabilityChange)
Q_DECLARE_METATYPE(Tp::CapabilityChangeList)
Q_DECLARE_METATYPE(Tp::CapabilityPair)
Q_DECLARE_METATYPE(Tp::CapabilityPairList)
Q_DECLARE_METATYPE(Tp::CaptchaAnswers)
Q_DECLARE_METATYPE(Tp::CaptchaInfo)
Q_DECLARE_METATYPE(Tp::CaptchaInfoList)
Q_DECLARE_METATYPE(Tp::ChannelCallStateMap)
Q_DECLARE_METATYPE(Tp::ChannelClass)
Q_DECLARE_METATYPE(Tp::ChannelClassList)
Q_DECLARE_METATYPE(Tp::ChannelDetails)
Q_DECLARE_METATYPE(Tp::ChannelDetailsList)
Q_DECLARE_METATYPE(Tp::ChannelInfo)
Q_DECLARE_METATYPE(Tp::ChannelInfoList)
Q_DECLARE_METATYPE(Tp::ChannelOriginatorMap)
Q_DECLARE_METATYPE(Tp::ChatStateMap)
Q_DECLARE_METATYPE(Tp::Codec)
Q_DECLARE_METATYPE(Tp::CodecList)
Q_DECLARE_METATYPE(Tp::ComponentStateMap)
Q_DECLARE_METATYPE(Tp::ContactAttributesMap)
Q_DECLARE_METATYPE(Tp::ContactCapabilitiesMap)
Q_DECLARE_METATYPE(Tp::ContactCapabilitiesMapList)
Q_DECLARE_METATYPE(Tp::ContactCapability)
Q_DECLARE_METATYPE(Tp::ContactCapabilityList)
Q_DECLARE_METATYPE(Tp::ContactClientTypes)
Q_DECLARE_METATYPE(Tp::ContactCodecMap)
Q_DECLARE_METATYPE(Tp::ContactInfoField)
Q_DECLARE_METATYPE(Tp::ContactInfoFieldList)
Q_DECLARE_METATYPE(Tp::ContactInfoMap)
Q_DECLARE_METATYPE(Tp::ContactLocations)
Q_DECLARE_METATYPE(Tp::ContactMediaDescriptionPropertiesMap)
Q_DECLARE_METATYPE(Tp::ContactPresences)
Q_DECLARE_METATYPE(Tp::ContactSSRCsMap)
Q_DECLARE_METATYPE(Tp::ContactSearchMap)
Q_DECLARE_METATYPE(Tp::ContactSearchResultMap)
Q_DECLARE_METATYPE(Tp::ContactSendingStateMap)
Q_DECLARE_METATYPE(Tp::ContactSubscriptionMap)
Q_DECLARE_METATYPE(Tp::ContactSubscriptions)
Q_DECLARE_METATYPE(Tp::CurrencyAmount)
Q_DECLARE_METATYPE(Tp::DBusTubeMember)
Q_DECLARE_METATYPE(Tp::DBusTubeMemberList)
Q_DECLARE_METATYPE(Tp::DBusTubeParticipants)
Q_DECLARE_METATYPE(Tp::DebugMessage)
Q_DECLARE_METATYPE(Tp::DebugMessageList)
Q_DECLARE_METATYPE(Tp::FieldSpec)
Q_DECLARE_METATYPE(Tp::FieldSpecs)
Q_DECLARE_METATYPE(Tp::HTTPPostData)
Q_DECLARE_METATYPE(Tp::HTTPPostDataList)
Q_DECLARE_METATYPE(Tp::HandleIdentifierMap)
Q_DECLARE_METATYPE(Tp::HandleOwnerMap)
Q_DECLARE_METATYPE(Tp::HandlerCapabilities)
Q_DECLARE_METATYPE(Tp::HandlerCapabilitiesList)
Q_DECLARE_METATYPE(Tp::LastActivityAndStatuses)
Q_DECLARE_METATYPE(Tp::LocalPendingInfo)
Q_DECLARE_METATYPE(Tp::LocalPendingInfoList)
Q_DECLARE_METATYPE(Tp::Location)
Q_DECLARE_METATYPE(Tp::Mail)
Q_DECLARE_METATYPE(Tp::MailAddress)
Q_DECLARE_METATYPE(Tp::MailAddressList)
Q_DECLARE_METATYPE(Tp::MailList)
Q_DECLARE_METATYPE(Tp::MailURL)
Q_DECLARE_METATYPE(Tp::MediaDescriptionOffer)
Q_DECLARE_METATYPE(Tp::MediaDescriptionProperties)
Q_DECLARE_METATYPE(Tp::MediaSessionHandlerInfo)
Q_DECLARE_METATYPE(Tp::MediaSessionHandlerInfoList)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerCandidate)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerCandidateList)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerCodec)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerCodecList)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerTransport)
Q_DECLARE_METATYPE(Tp::MediaStreamHandlerTransportList)
Q_DECLARE_METATYPE(Tp::MediaStreamInfo)
Q_DECLARE_METATYPE(Tp::MediaStreamInfoList)
Q_DECLARE_METATYPE(Tp::MessagePart)
Q_DECLARE_METATYPE(Tp::MessagePartContentMap)
Q_DECLARE_METATYPE(Tp::MessagePartList)
Q_DECLARE_METATYPE(Tp::MessagePartListList)
Q_DECLARE_METATYPE(Tp::Metadata)
Q_DECLARE_METATYPE(Tp::MultipleStatusMap)
Q_DECLARE_METATYPE(Tp::NotDelegatedError)
Q_DECLARE_METATYPE(Tp::NotDelegatedMap)
Q_DECLARE_METATYPE(Tp::ObjectImmutablePropertiesMap)
Q_DECLARE_METATYPE(Tp::ObjectImmutablePropertiesMapList)
Q_DECLARE_METATYPE(Tp::ObjectPathList)
Q_DECLARE_METATYPE(Tp::ParamSpec)
Q_DECLARE_METATYPE(Tp::ParamSpecList)
Q_DECLARE_METATYPE(Tp::PendingTextMessage)
Q_DECLARE_METATYPE(Tp::PendingTextMessageList)
Q_DECLARE_METATYPE(Tp::PropertyFlagsChange)
Q_DECLARE_METATYPE(Tp::PropertyFlagsChangeList)
Q_DECLARE_METATYPE(Tp::PropertySpec)
Q_DECLARE_METATYPE(Tp::PropertySpecList)
Q_DECLARE_METATYPE(Tp::PropertyValue)
Q_DECLARE_METATYPE(Tp::PropertyValueList)
Q_DECLARE_METATYPE(Tp::ProtocolPropertiesMap)
Q_DECLARE_METATYPE(Tp::QualifiedPropertyValueMap)
Q_DECLARE_METATYPE(Tp::QualifiedPropertyValueMapList)
Q_DECLARE_METATYPE(Tp::RTCPFeedbackMessage)
Q_DECLARE_METATYPE(Tp::RTCPFeedbackMessageList)
Q_DECLARE_METATYPE(Tp::RTCPFeedbackMessageMap)
Q_DECLARE_METATYPE(Tp::RTCPFeedbackMessageProperties)
Q_DECLARE_METATYPE(Tp::RTPHeaderExtension)
Q_DECLARE_METATYPE(Tp::RTPHeaderExtensionsList)
Q_DECLARE_METATYPE(Tp::RequestableChannelClass)
Q_DECLARE_METATYPE(Tp::RequestableChannelClassList)
Q_DECLARE_METATYPE(Tp::RichPresenceAccessControl)
Q_DECLARE_METATYPE(Tp::RoomInfo)
Q_DECLARE_METATYPE(Tp::RoomInfoList)
Q_DECLARE_METATYPE(Tp::ServicePoint)
Q_DECLARE_METATYPE(Tp::ServicePointInfo)
Q_DECLARE_METATYPE(Tp::ServicePointInfoList)
Q_DECLARE_METATYPE(Tp::SimpleContactPresences)
Q_DECLARE_METATYPE(Tp::SimplePresence)
Q_DECLARE_METATYPE(Tp::SimpleStatusSpec)
Q_DECLARE_METATYPE(Tp::SimpleStatusSpecMap)
Q_DECLARE_METATYPE(Tp::SingleContactAttributesMap)
Q_DECLARE_METATYPE(Tp::SocketAddressIP)
Q_DECLARE_METATYPE(Tp::SocketAddressIPList)
Q_DECLARE_METATYPE(Tp::SocketAddressIPv4)
Q_DECLARE_METATYPE(Tp::SocketAddressIPv6)
Q_DECLARE_METATYPE(Tp::SocketNetmaskIPv4)
Q_DECLARE_METATYPE(Tp::SocketNetmaskIPv6)
Q_DECLARE_METATYPE(Tp::StatusSpec)
Q_DECLARE_METATYPE(Tp::StatusSpecMap)
Q_DECLARE_METATYPE(Tp::StreamCredentials)
Q_DECLARE_METATYPE(Tp::StringStringMap)
Q_DECLARE_METATYPE(Tp::StringStringMapList)
Q_DECLARE_METATYPE(Tp::StringVariantMap)
Q_DECLARE_METATYPE(Tp::StringVariantMapList)
Q_DECLARE_METATYPE(Tp::SupportedSocketMap)
Q_DECLARE_METATYPE(Tp::TLSCertificateRejection)
Q_DECLARE_METATYPE(Tp::TLSCertificateRejectionList)
Q_DECLARE_METATYPE(Tp::TubeInfo)
Q_DECLARE_METATYPE(Tp::TubeInfoList)
Q_DECLARE_METATYPE(Tp::UIntList)
Q_DECLARE_METATYPE(Tp::VCardFieldAddressMap)
Q_DECLARE_METATYPE(Tp::VideoResolution)
Q_DECLARE_METATYPE(Tp::VideoResolutionStruct)
