/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.toolbox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.common.ComponentType;
import org.diylc.common.IPlugInPort;
import org.diylc.core.Template;
import org.diylc.presenter.ComparatorFactory;
import org.diylc.presenter.ComponentProcessor;
import org.diylc.swing.plugins.toolbox.ComponentButtonFactory;

class ComponentTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ComponentTabbedPane.class);
    public static int SCROLL_STEP = 32 + ComponentButtonFactory.MARGIN * 2 + 2;
    private final IPlugInPort plugInPort;
    private Container recentToolbar;
    private List<String> pendingRecentComponents = null;

    public ComponentTabbedPane(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.addTab("Recently Used", this.createRecentComponentsPanel());
        Map map = iPlugInPort.getComponentTypes();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            JPanel jPanel = this.createTab((List)map.get(string));
            this.addTab(string, jPanel);
        }
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ComponentTabbedPane.this.plugInPort.setNewComponentTypeSlot(null, null);
                if (ComponentTabbedPane.this.pendingRecentComponents != null) {
                    ComponentTabbedPane.this.refreshRecentComponentsToolbar(ComponentTabbedPane.this.getRecentToolbar(), ComponentTabbedPane.this.pendingRecentComponents);
                    ComponentTabbedPane.this.getRecentToolbar().invalidate();
                    ComponentTabbedPane.this.pendingRecentComponents = null;
                }
            }
        });
    }

    private JPanel createTab(List<ComponentType> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(this.createComponentPanel(list), "Center");
        return jPanel;
    }

    public Container getRecentToolbar() {
        if (this.recentToolbar == null) {
            this.recentToolbar = new Container();
            this.recentToolbar.setLayout(new BoxLayout(this.recentToolbar, 0));
        }
        return this.recentToolbar;
    }

    private Component createComponentPanel(List<ComponentType> list) {
        Container container = new Container();
        Collections.sort(list, ComparatorFactory.getInstance().getComponentTypeComparator());
        container.setLayout(new BoxLayout(container, 0));
        for (ComponentType componentType : list) {
            JButton jButton = ComponentButtonFactory.create(this.plugInPort, componentType, this.createTemplatePopup(componentType));
            container.add(jButton);
        }
        return container;
    }

    private Component createRecentComponentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        Container container = this.getRecentToolbar();
        this.refreshRecentComponentsToolbar(container, (List)ConfigurationManager.getInstance().readObject("recentComponents", new ArrayList()));
        ConfigurationManager.getInstance().addConfigListener("recentComponents", new IConfigListener(){

            public void valueChanged(String string, Object object) {
                ComponentTabbedPane.this.pendingRecentComponents = (List)object;
            }
        });
        jPanel.add((Component)container, "Center");
        return jPanel;
    }

    private void refreshRecentComponentsToolbar(Container container, List<String> list) {
        container.removeAll();
        for (String string : list) {
            try {
                ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(Class.forName(string));
                JButton jButton = ComponentButtonFactory.create(this.plugInPort, componentType, this.createTemplatePopup(componentType));
                container.add(jButton);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.error((Object)("Could not create recent component button for " + string), (Throwable)classNotFoundException);
            }
        }
    }

    private JPopupMenu createTemplatePopup(final ComponentType componentType) {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add("Loading...");
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jPopupMenu.removeAll();
                List list = ComponentTabbedPane.this.plugInPort.getTemplatesFor(componentType.getCategory(), componentType.getName());
                if (list == null || list.isEmpty()) {
                    JMenuItem jMenuItem = new JMenuItem("<no templates>");
                    jMenuItem.setEnabled(false);
                    jPopupMenu.add(jMenuItem);
                } else {
                    for (Template template : list) {
                        JMenuItem jMenuItem = ComponentButtonFactory.createTemplateItem(ComponentTabbedPane.this.plugInPort, template, componentType);
                        jPopupMenu.add(jMenuItem);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return jPopupMenu;
    }
}

