/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.NoMatchingGraphVariantsException;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.StyledAttributeDescriber;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.IncompatibleGraphVariantFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class IncompatibleGraphVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<NoMatchingGraphVariantsException, IncompatibleGraphVariantFailure> {
    private static final String NO_MATCHING_VARIANTS_PREFIX = "No matching variant errors are explained in more detail at ";
    private static final String NO_MATCHING_VARIANTS_SECTION = "sub:variant-no-match";

    @Override
    public NoMatchingGraphVariantsException describeFailure(IncompatibleGraphVariantFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), failure.getSchema());
        String message = this.buildNoMatchingGraphVariantSelectionFailureMsg(new StyledAttributeDescriber(describer), failure);
        NoMatchingGraphVariantsException e = new NoMatchingGraphVariantsException(message);
        this.suggestReviewAlgorithm(e);
        this.suggestSpecificDocumentation(e, NO_MATCHING_VARIANTS_PREFIX, NO_MATCHING_VARIANTS_SECTION);
        return e;
    }

    protected String buildNoMatchingGraphVariantSelectionFailureMsg(StyledAttributeDescriber describer, IncompatibleGraphVariantFailure failure) {
        TreeFormatter formatter = new TreeFormatter();
        String targetVariantText = StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.getRequestedName());
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("Unable to find a matching variant of " + targetVariantText);
        } else {
            formatter.node("No matching variant of " + targetVariantText + " was found. The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap()) + " but:");
        }
        formatter.startChildren();
        if (failure.noCandidatesHaveAttributes()) {
            formatter.node("None of the variants have attributes.");
        } else {
            for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
                this.formatUnselectableVariant(candidate, formatter, failure.getTargetComponent(), describer);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatUnselectableVariant(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, ComponentGraphResolveMetadata targetComponent, AttributeDescriber describer) {
        formatter.node("Variant '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
    }
}

