/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.NamingService.NameValidator;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.IntHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class NameTransformer {
    public static final String ESCAPE = "\\";

    public NameComponent[] toName(String string) throws InvalidName {
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./\\", true);
        String[] stringArray = new String[stringTokenizer.countTokens() + 1];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        IntHolder intHolder = new IntHolder();
        NameComponent nameComponent = this.readNode(intHolder, stringArray);
        while (nameComponent != null) {
            arrayList.add(nameComponent);
            nameComponent = this.readNode(intHolder, stringArray);
        }
        NameComponent[] nameComponentArray = new NameComponent[arrayList.size()];
        int n2 = 0;
        while (n2 < nameComponentArray.length) {
            nameComponentArray[n2] = (NameComponent)arrayList.get(n2);
            ++n2;
        }
        NameValidator.check(nameComponentArray);
        return nameComponentArray;
    }

    public String toString(NameComponent[] nameComponentArray) throws InvalidName {
        NameValidator.check(nameComponentArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nameComponentArray.length) {
            NameComponent nameComponent = nameComponentArray[n];
            this.appEscaping(stringBuffer, nameComponent.id);
            if (nameComponent.kind.length() > 0) {
                stringBuffer.append('.');
                this.appEscaping(stringBuffer, nameComponent.kind);
            }
            if (n < nameComponentArray.length - 1) {
                stringBuffer.append('/');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final void appEscaping(StringBuffer stringBuffer, String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '.': 
                case '/': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
    }

    private final void assertEndOfNode(IntHolder intHolder, String[] stringArray) throws InvalidName {
        if (stringArray[intHolder.value] != null && !stringArray[intHolder.value].equals("/")) {
            throw new InvalidName("End of node expected at token " + intHolder.value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final NameComponent readNode(IntHolder intHolder, String[] stringArray) throws InvalidName {
        if (stringArray[intHolder.value] == null) {
            return null;
        }
        NameComponent nameComponent = new NameComponent();
        if (stringArray[intHolder.value].equals(".")) {
            nameComponent.id = "";
            ++intHolder.value;
            nameComponent.kind = this.readPart(intHolder, stringArray);
            this.assertEndOfNode(intHolder, stringArray);
            if (stringArray[intHolder.value] == null) return nameComponent;
            ++intHolder.value;
            return nameComponent;
        } else {
            if (stringArray[intHolder.value].equals("/")) {
                throw new InvalidName("Unexpected '/' token " + intHolder.value);
            }
            nameComponent.id = this.readPart(intHolder, stringArray);
            if (stringArray[intHolder.value] != null) {
                if (stringArray[intHolder.value].equals(".")) {
                    ++intHolder.value;
                    nameComponent.kind = this.readPart(intHolder, stringArray);
                    this.assertEndOfNode(intHolder, stringArray);
                    if (stringArray[intHolder.value] == null) return nameComponent;
                    ++intHolder.value;
                    return nameComponent;
                } else {
                    if (!stringArray[intHolder.value].equals("/")) throw new InvalidName("Unexpected '" + stringArray[intHolder.value] + "' at token " + intHolder.value);
                    nameComponent.kind = "";
                    ++intHolder.value;
                }
                return nameComponent;
            } else {
                nameComponent.kind = "";
            }
        }
        return nameComponent;
    }

    private final String readPart(IntHolder intHolder, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringArray[intHolder.value] != null && !stringArray[intHolder.value].equals(".") && !stringArray[intHolder.value].equals("/")) {
            if (stringArray[intHolder.value].equals(ESCAPE)) {
                ++intHolder.value;
                stringBuffer.append(stringArray[intHolder.value]);
            } else {
                stringBuffer.append(stringArray[intHolder.value]);
            }
            ++intHolder.value;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        NameComponent nameComponent = new NameComponent("a", "ak");
        NameComponent nameComponent2 = new NameComponent("b/z", "b.k");
        NameComponent nameComponent3 = new NameComponent("c", "");
        NameTransformer nameTransformer = new NameTransformer();
        try {
            String string = nameTransformer.toString(new NameComponent[]{nameComponent, nameComponent2, nameComponent3});
            System.out.println(string);
            NameComponent[] nameComponentArray = nameTransformer.toName(string);
            System.out.println("ToString");
            int n = 0;
            while (n < nameComponentArray.length) {
                System.out.println(nameComponentArray[n].id + ':' + nameComponentArray[n].kind);
                ++n;
            }
        }
        catch (InvalidName invalidName) {
            invalidName.printStackTrace();
        }
    }
}

