/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PasswordView
extends FieldView {
    private char[] oneCharBuffer;

    protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c) {
        this.updateMetrics();
        this.oneCharBuffer[0] = c;
        graphics.drawChars(this.oneCharBuffer, 0, 1, n, n2);
        return n + this.metrics.charWidth(c);
    }

    private final char getEchoChar() {
        char c = ((JPasswordField)this.getContainer()).getEchoChar();
        if (c == '\u0000') {
            c = '*';
        }
        return (char)c;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.updateMetrics();
        char c = this.getEchoChar();
        graphics.setColor(this.selectedColor);
        graphics.setColor(Color.BLACK);
        int n5 = n3;
        while (n5 < n4) {
            n = this.drawEchoCharacter(graphics, n, n2, c);
            ++n5;
        }
        return n;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.updateMetrics();
        char c = this.getEchoChar();
        graphics.setColor(this.unselectedColor);
        graphics.setColor(Color.BLACK);
        int n5 = n3;
        while (n5 < n4) {
            n = this.drawEchoCharacter(graphics, n, n2, c);
            ++n5;
        }
        return n;
    }

    public float getPreferredSpan(int n) {
        String string;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics();
        if (n == 1) {
            return fontMetrics.getHeight();
        }
        Element element = this.getElement();
        try {
            string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        return fontMetrics.stringWidth(string);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        this.updateMetrics();
        int n2 = this.getElement().getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape2, n2);
        Element element = this.getElement().getElement(n2);
        int n3 = element.getStartOffset();
        Segment segment = this.getLineBuffer();
        segment.array = new char[n - n3];
        char c = this.getEchoChar();
        int n4 = 0;
        while (n4 < segment.array.length) {
            segment.array[n4] = c;
            ++n4;
        }
        segment.offset = 0;
        segment.count = segment.array.length;
        n4 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, shape, biasArray);
    }

    private final /* synthetic */ void this() {
        this.oneCharBuffer = new char[1];
    }

    public PasswordView(Element element) {
        super(element);
        this.this();
    }
}

