<?PHP // tracks.php

include("config.php");

print_header();

if (isset($search)) {
    $result = search($search);
    print_heading("Search results for \"$search\"");

    if ($result["SEARCHCOUNT"] == 0) {
        echo "<P align=center>No matching tracks found</P>";
    } else {
        echo "<TABLE BORDER=0 WIDTH=100%>";
    
        for ($i=0; $i < $result["SEARCHCOUNT"]; $i++) {
            $track = $result[$i];
            $albumnum = $track["ALBUM_NO"];
            $tracknum = $track["TRACK_NO"];
            echo "<TR VALIGN=top>";
            echo "<TD><A HREF=\"tracks.php?album=$albumnum&track=$tracknum\">".$track["TRACK"]."</A>";
            echo "<TD>".$track["ARTIST"];
            echo "<TD WIDTH=10>".$track["RATING"];
            echo "<TD WIDTH=40 ALIGN=right><A TITLE=\"Queue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?album=$albumnum&track=$tracknum\"><IMG SRC=\"image/add.gif\" BORDER=0 HEIGHT=15 WIDTH=15></A>";
            echo "</TR>";
        }
        echo "</TABLE>";
    }
} 

if (isset($rate) and isset($mode)) {
    $result = rate($album, $track, $rate); 
    if ($mode == "album") {
        unset($track);
    }
}


if (isset($album)) {
    if (isset($track)) {
        $result = info($album, $track);

        echo "<TABLE WIDTH=100%>";
        echo "<TR><TD><B>".$result["TRACK"]."</B> by ".$result["ARTIST"];
        echo "    <TD ALIGN=right><A TITLE=\"Queue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?album=$album&track=$track\"><IMG SRC=\"image/add.gif\" BORDER=0 HEIGHT=15 WIDTH=15></A>";
        echo "</TABLE><TABLE BORDER=1 ALIGN=CENTER>";
        echo "<TR><TD WIDTH=100 ALIGN=right>Album:<TD><A HREF=\"tracks.php?album=$album\">".$result["ALBUM"]."</A>";
        echo "<TR><TD WIDTH=100 ALIGN=right>Year:<TD>".$result["YEAR"];
        echo "<TR><TD WIDTH=100 ALIGN=right>Rating:<TD>";
        print_rating ($result["RATING"], "track", $album, $track);
        echo "<TR><TD WIDTH=100 ALIGN=right NOWRAP>Last&nbsp;Played:<TD>".$result["LAST_PLAYED"];
        echo "<TR><TD WIDTH=100 ALIGN=right>Genre:<TD>".$result["GENRE"];
        echo "<TR><TD WIDTH=100 ALIGN=right>Filter:<TD>".$result["FILTER"];
        echo "<TR><TD WIDTH=100 ALIGN=right>Length:<TD>".$result["LENGTH"];
        echo "<TR><TD WIDTH=100 ALIGN=right>Bitrate:<TD>".$result["COMMENT"];
        echo "</TABLE>";

    } else {
        $result = tracks($album);

        print_heading($result["ALBUMNAME"], "image/add.gif", "queue.php?album=$album", "Queue this album", "mp3queue");

        echo "<TABLE BORDER=0 WIDTH=100%>";

        for ($i=0; $i < $result["TRACKCOUNT"]; $i++) {
            $track = $result[$i];
            $tracknum = $track["NUM"];
            echo "<TR valign=top>";
            echo "<TD><A HREF=\"tracks.php?album=$album&track=$tracknum\">".$track["TITLE"]."</A>";
            echo "<TD>".$track["ARTIST"];
            echo "<TD WIDTH=10>";
            print_rating ($track["RATING"], "album", $album, $tracknum);
            echo "<TD WIDTH=40 ALIGN=right><A TITLE=\"Queue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?album=$album&track=$tracknum\"><IMG SRC=\"image/add.gif\" BORDER=0 HEIGHT=15 WIDTH=15></A>";
            echo "</TR>";
        }
        echo "</TABLE>";
    }
}


?>

