// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
// $Id: gecon.cc,v 1.3 2000/08/28 15:53:51 jsiek Exp $
//


#include "mtl/mtl2lapack.h"
#include "mtl/dense1D.h"
#include "mtl/utils.h"


/*
  Sample Output

  3x3
  [
  [1,2,2],
  [2,1,2],
  [2,2,1]
  ]
  Estimated condition number: 7

 */
int
main()
{
  const int M = 3;
  const int N = 3;
  using namespace mtl;
  //begin
  double da[] = { 1, 2, 2, 2, 1, 2, 2, 2, 1};
  mtl2lapack::lapack_matrix<double, external>::type A(da, M, N);
  dense1D<int> pivot(N, 0);
  double anorm = 0;
  double cond;
  //end
  print_all_matrix(A);
  //begin
  int info = mtl2lapack::getrf(A, pivot);

  if (info == 0) {
    anorm = 5;
    mtl2lapack::gecon('1', A, anorm, cond);
    
    std::cout << "Estimated condition number: ";
    if (info == 0)
      std::cout << 1.0 / cond << std::endl;
    else
      std::cerr << "error INFO = " << info << std::endl;;
  } else {
    std::cerr << "error INFO = " << info << std::endl;
  }
  //end  
  return 0;
}
