/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public final class Replace
extends TextFunction {
    protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
        if (args.length != 4) {
            return ErrorEval.VALUE_INVALID;
        }
        String oldStr = Replace.evaluateStringArg(args[0], srcCellRow, srcCellCol);
        int startNum = Replace.evaluateIntArg(args[1], srcCellRow, srcCellCol);
        int numChars = Replace.evaluateIntArg(args[2], srcCellRow, srcCellCol);
        String newStr = Replace.evaluateStringArg(args[3], srcCellRow, srcCellCol);
        if (startNum < 1 || numChars < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        StringBuffer strBuff = new StringBuffer(oldStr);
        if (startNum <= oldStr.length() && numChars != 0) {
            strBuff.delete(startNum - 1, startNum - 1 + numChars);
        }
        if (startNum > strBuff.length()) {
            strBuff.append(newStr);
        } else {
            strBuff.insert(startNum - 1, newStr);
        }
        return new StringEval(strBuff.toString());
    }
}

