/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.NonNullApi;
import org.gradle.internal.build.event.types.DefaultInternalProblemAggregation;
import org.gradle.internal.build.event.types.DefaultInternalProblemContextDetails;
import org.gradle.internal.build.event.types.DefaultProblemAggregationDetails;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalProblemAggregationVersion3;
import org.gradle.tooling.internal.protocol.InternalProblemDefinition;
import org.gradle.tooling.internal.protocol.InternalProblemEventVersion2;
import org.gradle.tooling.internal.protocol.InternalProblemGroup;
import org.gradle.tooling.internal.protocol.InternalProblemId;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.problem.InternalProblemDetailsVersion2;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
public class AggregatingProblemConsumer {
    private final Multimap<String, InternalProblemEventVersion2> seenProblems = ArrayListMultimap.create();
    private final ProgressEventConsumer progressEventConsumer;
    private final Supplier<OperationIdentifier> operationIdentifierSupplier;
    private int thresholdForIntermediateSummary = 10000;

    AggregatingProblemConsumer(ProgressEventConsumer progressEventConsumer, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        this.progressEventConsumer = progressEventConsumer;
        this.operationIdentifierSupplier = operationIdentifierSupplier;
    }

    void setThresholdForIntermediateSummary(int thresholdForIntermediateSummary) {
        this.thresholdForIntermediateSummary = thresholdForIntermediateSummary;
    }

    void sendProblemSummaries() {
        List<InternalProblemAggregationVersion3> problemSummaries = this.createSummaries();
        if (problemSummaries.isEmpty()) {
            this.seenProblems.clear();
            return;
        }
        problemSummaries.forEach(summary -> {
            List problemContextDetails = summary.getProblemContextDetails();
            this.progressEventConsumer.progress((InternalProgressEvent)new DefaultProblemEvent((InternalProblemDescriptor)new DefaultProblemDescriptor(this.operationIdentifierSupplier.get(), CurrentBuildOperationRef.instance().getId()), (InternalProblemDetailsVersion2)new DefaultProblemAggregationDetails(summary.getProblemDefinition(), (List)problemContextDetails.stream().skip(1L).collect(ImmutableList.toImmutableList()))));
        });
        this.seenProblems.clear();
    }

    private List<InternalProblemAggregationVersion3> createSummaries() {
        return (List)this.seenProblems.asMap().values().stream().map(ImmutableList::copyOf).filter(values -> values.size() > 1).map(AggregatingProblemConsumer::createProblemAggregation).collect(ImmutableList.toImmutableList());
    }

    private static DefaultInternalProblemAggregation createProblemAggregation(List<InternalProblemEventVersion2> aggregatedEvents) {
        InternalProblemDetailsVersion2 details = aggregatedEvents.iterator().next().getDetails();
        if (!(details instanceof InternalBasicProblemDetailsVersion3)) {
            throw new UnsupportedOperationException("Unsupported problem details: " + details.getClass().getName());
        }
        InternalBasicProblemDetailsVersion3 detailsV3 = (InternalBasicProblemDetailsVersion3)details;
        List aggregatedContextDetails = (List)aggregatedEvents.stream().map(event -> {
            InternalProblemDetailsVersion2 detailsV2 = event.getDetails();
            if (detailsV2 instanceof InternalBasicProblemDetailsVersion3) {
                InternalBasicProblemDetailsVersion3 basicDetails = (InternalBasicProblemDetailsVersion3)detailsV2;
                return new DefaultInternalProblemContextDetails(basicDetails.getAdditionalData(), basicDetails.getDetails(), basicDetails.getLocations(), basicDetails.getSolutions(), basicDetails.getFailure(), basicDetails.getContextualLabel());
            }
            throw new UnsupportedOperationException("Unsupported problem details: " + detailsV2.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
        return new DefaultInternalProblemAggregation(detailsV3.getDefinition(), aggregatedContextDetails);
    }

    void emit(InternalProblemEventVersion2 problem) {
        InternalProblemDetailsVersion2 details = problem.getDetails();
        if (!(details instanceof InternalBasicProblemDetailsVersion3)) {
            throw new UnsupportedOperationException("Unsupported problem details: " + details.getClass().getName());
        }
        InternalBasicProblemDetailsVersion3 d = (InternalBasicProblemDetailsVersion3)details;
        InternalProblemDefinition definition = d.getDefinition();
        String aggregationKey = AggregatingProblemConsumer.aggregationKeyFor(definition.getId());
        this.sendProgress(problem, aggregationKey);
        if (this.seenProblems.size() > this.thresholdForIntermediateSummary) {
            this.sendProblemSummaries();
        }
    }

    private static String aggregationKeyFor(InternalProblemId id) {
        return AggregatingProblemConsumer.aggregationKeyFor(id.getGroup()) + ";" + id.getName();
    }

    private static String aggregationKeyFor(InternalProblemGroup group) {
        return group.getParent() == null ? group.getName() : AggregatingProblemConsumer.aggregationKeyFor(group.getParent()) + ";" + group.getName();
    }

    private void sendProgress(InternalProblemEventVersion2 problem, String aggregationKey) {
        Collection seenProblem = this.seenProblems.get((Object)aggregationKey);
        if (seenProblem.isEmpty()) {
            this.seenProblems.put((Object)aggregationKey, (Object)problem);
            this.progressEventConsumer.progress((InternalProgressEvent)problem);
        } else {
            seenProblem.add(problem);
        }
    }
}

