/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.IOR;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming._NamingContextStub;

public class NameParser
extends NameTransformer {
    public static final String pxCORBALOC = "corbaloc";
    public static final String pxCORBANAME = "corbaname";
    public static final String pxIOR = "ior";
    public static final String pxFILE = "file://";
    public static final String pxFTP = "ftp://";
    public static final String pxHTTP = "http://";
    public static final String IIOP = "iiop";
    public static final String RIR = "rir";
    public static final int DEFAULT_PORT = 2809;
    public static final String DEFAULT_NAME = "NameService";
    static NameTransformer converter;
    static NameParser n;
    int p;
    String[] t;

    public synchronized Object corbaloc(String string, OrbFunctional orbFunctional) throws BAD_PARAM {
        return this.corbaloc(string, orbFunctional, 0);
    }

    private final Object corbaloc(String string, OrbFunctional orbFunctional, int n) {
        boolean bl;
        if (n > 10) {
            throw new DATA_CONVERSION("More than 10 redirections");
        }
        if (string.startsWith(pxFILE)) {
            return this.corbaloc(this.readFile(string.substring(pxFILE.length())), orbFunctional, n + 1);
        }
        if (string.startsWith(pxHTTP)) {
            return this.corbaloc(this.readUrl(string), orbFunctional, n + 1);
        }
        if (string.startsWith(pxFTP)) {
            return this.corbaloc(this.readUrl(string), orbFunctional, n + 1);
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 1;
        int n3 = 0;
        int n4 = 2809;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":@/.,#", true);
        this.t = new String[stringTokenizer.countTokens()];
        int n5 = 0;
        while (n5 < this.t.length) {
            this.t[n5] = stringTokenizer.nextToken();
            ++n5;
        }
        this.p = 0;
        if (this.t[this.p].startsWith(pxCORBANAME)) {
            bl = true;
        } else if (this.t[this.p].equalsIgnoreCase(pxCORBALOC)) {
            bl = false;
        } else {
            if (this.t[this.p].equalsIgnoreCase(pxIOR)) {
                IOR iOR = IOR.parse(string);
                return orbFunctional.ior_to_object(iOR);
            }
            throw new DATA_CONVERSION("Unsupported protocol: '" + this.t[this.p] + '\'');
        }
        ++this.p;
        if (!this.t[this.p++].equals(":")) {
            throw new BAD_PARAM("Syntax (':' expected after name prefix)");
        }
        if (this.t[this.p].equals(RIR)) {
            ++this.p;
            if (!this.t[this.p++].equals(":")) {
                throw new BAD_PARAM("':' expected after 'rir'");
            }
            String string2 = this.readKey("/");
            try {
                Object object = orbFunctional.resolve_initial_references(string2);
                return bl ? this.resolve(object) : object;
            }
            catch (InvalidName invalidName) {
                throw new BAD_PARAM("Unknown initial reference '" + string2 + '\'');
            }
        }
        if (this.t[this.p].equals(IIOP) || this.t[this.p].equals(":")) {
            java.lang.Object object;
            IOR iOR = new IOR();
            while (true) {
                String string3;
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                } else {
                    ++this.p;
                    if (!this.t[this.p++].equals(":")) {
                        throw new BAD_PARAM("':' expected after 'iiop'");
                    }
                    if (this.t[this.p + 1].equals(".") && this.t[this.p + 3].equals("@")) {
                        try {
                            n2 = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + '\'');
                        }
                        ++this.p;
                        try {
                            n3 = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + '\'');
                        }
                        ++this.p;
                    }
                }
                iOR.Internet.version = new Version(n2, n3);
                object = new StringBuffer(string.length());
                while (!(this.t[this.p].equals(":") || this.t[this.p].equals("/") || this.t[this.p].equals(","))) {
                    ((StringBuffer)object).append(this.t[this.p++]);
                }
                iOR.Internet.host = string3 = ((StringBuffer)object).toString();
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                    try {
                        n4 = Integer.parseInt(this.t[this.p++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BAD_PARAM("Invalid port '" + this.t[this.p - 1] + '\'');
                    }
                }
                iOR.Internet.port = n4;
                iOR.Id = "";
                if (!this.t[this.p].equals(",")) break;
                ++this.p;
            }
            String string4 = this.readKey("/");
            iOR.key = string4.getBytes();
            object = orbFunctional.ior_to_object(iOR);
            return bl ? this.resolve((Object)object) : object;
        }
        throw new DATA_CONVERSION("Unsupported protocol '" + this.t[this.p] + '\'');
    }

    String readFile(String string) {
        java.lang.Object object;
        File file = new File(string);
        if (!file.exists()) {
            object = new DATA_CONVERSION(file.getAbsolutePath() + " does not exist.");
            object.minor = 1195573270;
        }
        try {
            object = new char[(int)file.length()];
            FileReader fileReader = new FileReader(file);
            fileReader.read((char[])object);
            fileReader.close();
            return new String((char[])object).trim();
        }
        catch (IOException iOException) {
            DATA_CONVERSION dATA_CONVERSION = new DATA_CONVERSION();
            dATA_CONVERSION.initCause(iOException);
            dATA_CONVERSION.minor = 1195573270;
            throw dATA_CONVERSION;
        }
    }

    String readUrl(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BAD_PARAM("Malformed URL: '" + string + '\'');
        }
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) > 0) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString().trim();
        }
        catch (Exception exception) {
            DATA_CONVERSION dATA_CONVERSION = new DATA_CONVERSION("Reading " + string + " failed.");
            dATA_CONVERSION.minor = 1195573270;
            throw dATA_CONVERSION;
        }
    }

    private final Object resolve(Object object) {
        NamingContext namingContext;
        String string = "?";
        try {
            if (object instanceof NamingContext) {
                namingContext = (NamingContext)object;
            } else {
                Delegate delegate = ((ObjectImpl)object)._get_delegate();
                namingContext = new _NamingContextStub(delegate);
            }
        }
        catch (Exception exception) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("The CORBANAME target " + object + " is not a NamingContext");
            bAD_PARAM.minor = 10;
            bAD_PARAM.initCause(exception);
            throw bAD_PARAM;
        }
        if (converter == null) {
            converter = new NameTransformer();
        }
        try {
            string = this.readKey("#");
            object = namingContext.resolve(converter.toName(string));
            return object;
        }
        catch (Exception exception) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("Wrong CORBANAME '" + string + '\'');
            bAD_PARAM.minor = 10;
            bAD_PARAM.initCause(exception);
            throw bAD_PARAM;
        }
    }

    private final String readKey(String string) throws BAD_PARAM {
        if (this.p < this.t.length && !this.t[this.p].equals(string)) {
            if (this.t[this.p].equals("#")) {
                return DEFAULT_NAME;
            }
            throw new BAD_PARAM("'" + string + "String' expected '" + this.t[this.p] + "' found");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ++this.p;
        while (this.p < this.t.length && !this.t[this.p].equals("#")) {
            stringBuffer.append(this.t[this.p++]);
        }
        if (stringBuffer.length() == 0) {
            return DEFAULT_NAME;
        }
        try {
            return URLDecoder.decode(stringBuffer.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Unexpected("URLDecoder does not support UTF-8", unsupportedEncodingException);
        }
    }

    static void corbalocT(String string, OrbFunctional orbFunctional) {
        System.out.println(string);
        System.out.println(n.corbaloc(string, orbFunctional));
        System.out.println();
    }

    public static void main(String[] stringArray) {
        try {
            OrbFunctional orbFunctional = (OrbFunctional)ORB.init(stringArray, null);
            NameParser.corbalocT("corbaloc:iiop:1.3@155axyz.com/Prod/aTradingService", orbFunctional);
            NameParser.corbalocT("corbaloc:iiop:2.7@255bxyz.com/Prod/bTradingService", orbFunctional);
            NameParser.corbalocT("corbaloc:iiop:355cxyz.com/Prod/cTradingService", orbFunctional);
            NameParser.corbalocT("corbaloc:iiop:2.7@255bxyz.com/Prod/bTradingService", orbFunctional);
            NameParser.corbalocT("corbaloc:iiop:355cxyz.com:7777/Prod/cTradingService", orbFunctional);
            NameParser.corbalocT("corbaloc::556xyz.com:80/Dev/NameService", orbFunctional);
            NameParser.corbalocT("corbaloc:iiop:1.2@host1:3076/0", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:/NameService", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:/", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:/NameService", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:/", orbFunctional);
            NameParser.corbalocT("corbaloc:rir:", orbFunctional);
            NameParser.corbalocT("corbaloc::555xyz.com,:556xyz.com:80/Dev/NameService", orbFunctional);
        }
        catch (BAD_PARAM bAD_PARAM) {
            bAD_PARAM.printStackTrace(System.out);
        }
    }

    static {
        n = new NameParser();
    }
}

