/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArrayReferenceCommandSet
extends CommandSet {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ThreadGroup;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeLength(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Array Reference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeLength(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws InvalidObjectException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        dataOutputStream.writeInt(Array.getLength(object));
    }

    private final void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        Class clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            dataOutputStream.writeByte(66);
        } else if (clazz == Character.TYPE) {
            dataOutputStream.writeByte(67);
        } else if (clazz == Float.TYPE) {
            dataOutputStream.writeByte(70);
        } else if (clazz == Double.TYPE) {
            dataOutputStream.writeByte(68);
        } else if (clazz == Integer.TYPE) {
            dataOutputStream.writeByte(66);
        } else if (clazz == Long.TYPE) {
            dataOutputStream.writeByte(74);
        } else if (clazz == Short.TYPE) {
            dataOutputStream.writeByte(83);
        } else if (clazz == Void.TYPE) {
            dataOutputStream.writeByte(86);
        } else if (clazz == Boolean.TYPE) {
            dataOutputStream.writeByte(90);
        } else if (clazz.isArray()) {
            dataOutputStream.writeByte(91);
        } else {
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = ArrayReferenceCommandSet.class("[Ljava.lang.String;", false);
            }
            if (clazz2.isAssignableFrom(clazz)) {
                dataOutputStream.writeByte(115);
            } else {
                Class clazz3 = class$java$lang$Thread;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Thread = ArrayReferenceCommandSet.class("[Ljava.lang.Thread;", false);
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    dataOutputStream.writeByte(116);
                } else {
                    Class clazz4 = class$java$lang$ThreadGroup;
                    if (clazz4 == null) {
                        clazz4 = class$java$lang$ThreadGroup = ArrayReferenceCommandSet.class("[Ljava.lang.ThreadGroup;", false);
                    }
                    if (clazz4.isAssignableFrom(clazz)) {
                        dataOutputStream.writeByte(103);
                    } else {
                        Class clazz5 = class$java$lang$ClassLoader;
                        if (clazz5 == null) {
                            clazz5 = class$java$lang$ClassLoader = ArrayReferenceCommandSet.class("[Ljava.lang.ClassLoader;", false);
                        }
                        if (clazz5.isAssignableFrom(clazz)) {
                            dataOutputStream.writeByte(108);
                        } else {
                            Class clazz6 = class$java$lang$Class;
                            if (clazz6 == null) {
                                clazz6 = class$java$lang$Class = ArrayReferenceCommandSet.class("[Ljava.lang.Class;", false);
                            }
                            if (clazz6.isAssignableFrom(clazz)) {
                                dataOutputStream.writeByte(99);
                            } else {
                                dataOutputStream.writeByte(76);
                            }
                        }
                    }
                }
            }
        }
        int n3 = n;
        while (n3 < n + n2) {
            Object object2 = Array.get(object, n3);
            if (clazz.isPrimitive()) {
                Value.writeUntaggedValue(dataOutputStream, object2);
            } else {
                Value.writeTaggedValue(dataOutputStream, object2);
            }
            ++n3;
        }
    }

    private final void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws IOException, JdwpException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        Class clazz = object.getClass().getComponentType();
        int n3 = n;
        while (n3 < n + n2) {
            Object object2 = Value.getUntaggedObj(byteBuffer, clazz);
            Array.set(object, n3, object2);
            ++n3;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

