/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.SecureRandomSpi;
import java.util.HashMap;

public class ARCFourRandomSpi
extends SecureRandomSpi {
    private IRandom adaptee = PRNGFactory.getInstance("arcfour");
    private boolean virgin = true;

    public byte[] engineGenerateSeed(int n) {
        if (n < 1) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    public void engineNextBytes(byte[] byArray) {
        if (this.virgin) {
            this.engineSetSeed(new byte[0]);
        }
        try {
            this.adaptee.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void engineSetSeed(byte[] byArray) {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.arcfour.key-material", byArray);
        this.adaptee.init(hashMap);
        this.virgin = false;
    }
}

