/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.DefaultExceptionListener;
import gnu.java.beans.decoder.PersistenceParser;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class XMLDecoder {
    private Object owner;
    private ExceptionListener exceptionListener;
    private InputStream inputStream;
    private boolean isStreamClosed;
    private ClassLoader classLoader;
    private Iterator iterator;

    public void close() {
        if (this.isStreamClosed) {
            return;
        }
        try {
            this.inputStream.close();
            this.isStreamClosed = true;
        }
        catch (IOException iOException) {}
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object readObject() throws ArrayIndexOutOfBoundsException {
        if (this.inputStream == null) {
            return null;
        }
        if (this.isStreamClosed) {
            throw new NoSuchElementException("Cannot read any objects - XMLDecoder was already closed.");
        }
        if (this.iterator == null) {
            this.iterator = new PersistenceParser(this.inputStream, this.exceptionListener, this.classLoader, this).iterator();
        }
        if (!this.iterator.hasNext()) {
            throw new ArrayIndexOutOfBoundsException("No more objects available from this XMLDecoder.");
        }
        return this.iterator.next();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            exceptionListener = DefaultExceptionListener.INSTANCE;
        }
        this.exceptionListener = exceptionListener;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null);
    }

    public XMLDecoder(InputStream inputStream, Object object) {
        this(inputStream, object, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener) {
        this(inputStream, object, exceptionListener, Thread.currentThread().getContextClassLoader());
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        this.inputStream = inputStream;
        this.setExceptionListener(exceptionListener);
        this.classLoader = classLoader;
        this.owner = object;
    }
}

