/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.SystemProperties;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrintStream
extends FilterOutputStream {
    private static final char[] line_separator = SystemProperties.getProperty("line.separator").toCharArray();
    private String encoding;
    private boolean error_occurred;
    private boolean auto_flush;
    private boolean defaultEncoding;

    public boolean checkError() {
        this.flush();
        return this.error_occurred;
    }

    protected void setError() {
        this.error_occurred = true;
    }

    public void close() {
        try {
            this.flush();
            this.out.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private final synchronized void print(String string, boolean bl) {
        try {
            this.writeChars(string, 0, string.length());
            if (bl) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private final synchronized void print(char[] cArray, int n, int n2, boolean bl) {
        try {
            this.writeChars(cArray, n, n2);
            if (bl) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private final void writeChars(char[] cArray, int n, int n2) throws IOException {
        try {
            byte[] byArray = new String(cArray, n, n2).getBytes(this.encoding);
            this.out.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.defaultEncoding) {
                this.encoding = "ISO8859_1";
                this.writeChars(cArray, n, n2);
            }
            throw unsupportedEncodingException;
        }
    }

    private final void writeChars(String string, int n, int n2) throws IOException {
        try {
            byte[] byArray = string.substring(n, n + n2).getBytes(this.encoding);
            this.out.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.defaultEncoding) {
                this.encoding = "ISO8859_1";
                this.writeChars(string, n, n2);
            }
            throw unsupportedEncodingException;
        }
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl), false);
    }

    public void print(int n) {
        this.print(String.valueOf(n), false);
    }

    public void print(long l) {
        this.print(String.valueOf(l), false);
    }

    public void print(float f) {
        this.print(String.valueOf(f), false);
    }

    public void print(double d) {
        this.print(String.valueOf(d), false);
    }

    public void print(Object object) {
        this.print(object == null ? "null" : object.toString(), false);
    }

    public void print(String string) {
        this.print(string == null ? "null" : string, false);
    }

    public synchronized void print(char c) {
        this.print(new char[]{c}, 0, 1, false);
    }

    public void print(char[] cArray) {
        this.print(cArray, 0, cArray.length, false);
    }

    public void println() {
        this.print(line_separator, 0, line_separator.length, false);
    }

    public void println(boolean bl) {
        this.print(String.valueOf(bl), true);
    }

    public void println(int n) {
        this.print(String.valueOf(n), true);
    }

    public void println(long l) {
        this.print(String.valueOf(l), true);
    }

    public void println(float f) {
        this.print(String.valueOf(f), true);
    }

    public void println(double d) {
        this.print(String.valueOf(d), true);
    }

    public void println(Object object) {
        this.print(object == null ? "null" : object.toString(), true);
    }

    public void println(String string) {
        this.print(string == null ? "null" : string, true);
    }

    public synchronized void println(char c) {
        this.print(new char[]{c}, 0, 1, true);
    }

    public void println(char[] cArray) {
        this.print(cArray, 0, cArray.length, true);
    }

    public void write(int n) {
        try {
            this.out.write(n & 0xFF);
            if (this.auto_flush && n == 10) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            this.out.write(byArray, n, n2);
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private final /* synthetic */ void this() {
        this.error_occurred = false;
    }

    public PrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.this();
        try {
            this.encoding = SystemProperties.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            this.encoding = "ISO8859_1";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.encoding = "ISO8859_1";
        }
        catch (NullPointerException nullPointerException) {
            this.encoding = "ISO8859_1";
        }
        this.auto_flush = bl;
        this.defaultEncoding = true;
    }

    public PrintStream(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        super(outputStream);
        this.this();
        new String(new byte[1], string);
        this.encoding = string;
        this.auto_flush = bl;
    }
}

