/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

public class DNSOutput {
    private byte[] array;
    private int pos;
    private int saved_pos;

    public int current() {
        return this.pos;
    }

    private final void check(long l, int n) {
        long l2 = 1L;
        if (l < 0L || l > (l2 <<= n)) {
            throw new IllegalArgumentException(l + " out of range for " + n + " bit value");
        }
    }

    private final void need(int n) {
        if (this.array.length - this.pos >= n) {
            return;
        }
        int n2 = this.array.length * 2;
        if (n2 < this.pos + n) {
            n2 = this.pos + n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        this.array = byArray;
    }

    public void jump(int n) {
        if (n > this.pos) {
            throw new IllegalArgumentException("cannot jump past end of data");
        }
        this.pos = n;
    }

    public void save() {
        this.saved_pos = this.pos;
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.saved_pos;
        this.saved_pos = -1;
    }

    public void writeU8(int n) {
        this.check(n, 8);
        this.need(1);
        this.array[this.pos++] = (byte)(n & 0xFF);
    }

    public void writeU16(int n) {
        this.check(n, 16);
        this.need(2);
        this.array[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n & 0xFF);
    }

    public void writeU32(long l) {
        this.check(l, 32);
        this.need(4);
        this.array[this.pos++] = (byte)(l >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(l >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(l & 0xFFL);
    }

    public void writeByteArray(byte[] byArray, int n, int n2) {
        this.need(n2);
        System.arraycopy(byArray, n, this.array, this.pos, n2);
        this.pos += n2;
    }

    public void writeByteArray(byte[] byArray) {
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public void writeCountedString(byte[] byArray) {
        if (byArray.length > 255) {
            throw new IllegalArgumentException("Invalid counted string");
        }
        this.need(1 + byArray.length);
        this.array[this.pos++] = (byte)(byArray.length & 0xFF);
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        return byArray;
    }

    public DNSOutput(int n) {
        this.array = new byte[n];
        this.pos = 0;
        this.saved_pos = -1;
    }

    public DNSOutput() {
        this(32);
    }
}

