package 
    Net::FileMaker::Error::IT::XML;

use strict;
use warnings;

=head1 NAME

Net::FileMaker::Error::EN::XML - Error strings for FileMaker Server XML interface in Italian.

=head1 INFO

The error codes supported by this module were plucked from the FileMaker documentation on XML/XSLT, and appear valid for FileMaker Server 10.

=head1 SEE ALSO

L<Net::FileMaker::Error>

=cut

my $error_codes = {
    '-1' => 'Errore sconosciuto',    
    0    => 'Nessun errore',
    1    => "Azione annullata dall'utente",
    2    => "Errore di memoria",
    3    => "Comando non disponibile (ad esempio, sistema operativo non appropriato, modo errato e così via)",    
    4    => "Comando sconosciuto",
    5    => "Comando non valido (ad esempio, un'istruzione di script Definisci il campo priva di calcolo)",
    6    => "File di sola lettura",
    7    => "Memoria esaurita",
    8    => "Risultato vuoto",
    9    => "Privilegi insufficienti",
    10   => "Dati richiesti non disponibili",
    11   => "Nome non valido",
    12   => "Il nome esiste già",
    13   => "File o oggetto in uso",
    14   => "Fuori intervallo",
    15   => "Impossibile dividere per zero",
    16   => "Operazione non riuscita, nuovo tentativo richiesta (ad esempio una query dell'utente)",
    17   => "Tentativo di convertire il set di caratteri stranieri in UTF-16 non riuscito",
    18   => "Il client deve fornire le informazioni sull'account per procedere",
    19   => "La stringa contiene caratteri diversi da A-Z, a-z, 0-9 (ASCII)",
    20   => "Comando o operazione cancellata dallo script triggerato",    
    100  => "Manca un file",
    101  => "Manca un record",
    102  => "Manca un campo",
    103  => "Manca una relazione",
    104  => "Manca uno script",
    105  => "Manca un formato",
    106  => "Manca una tabella",
    107  => "Manca un indice",
    108  => "Manca una lista valori",
    109  => "Manca un set di privilegi",
    110  => "Mancano tabelle correlate",
    111  => "Ripetizione campo non valida",
    112  => "Manca una finestra",
    113  => "Manca una funzione",
    114  => "Manca un riferimento al file",
    115  => "Il set di menu specificato non è presente",
    116  => "L'oggetto formato specificato non è presente",
    117  => "L'origine dati specificata non è presente",
    130  => "File danneggiati o non presenti; reinstallarli",
    131  => "Impossibile trovare i file del supporto per la lingua (come i file modello)",
    200  => "Accesso al record negato",
    201  => "Impossibile modificare il campo",
    202  => "Accesso al campo negato",
    203  => "Nel file non c'è nessun record da stampare o la password non consente l'accesso alla stampa",
    204  => "Nessun accesso ai campi nei criteri di ordinamento",
    205  => "L'utente non dispone dei privilegi di accesso per creare nuovi record; l'importazione sovrascriverà i dati esistenti",
    206  => "L'utente non dispone del privilegio per cambiare la password o il file non è modificabile",
    207  => "L'utente non ha privilegi sufficienti per cambiare lo schema del database, oppure il file non è modificabile",
    208  => "La password non contiene abbastanza caratteri",
    209  => "La nuova password deve essere diversa da quella esistente",
    210  => "L'account utente è inattivo",
    211  => "La password è scaduta",
    212  => "Nome utente e/o password non validi. Riprovare",
    213  => "Il nome utente e/o la password non esistono",
    214  => "Troppi tentativi di accesso",
    215  => "I privilegi di amministratore non possono essere duplicati",
    216  => "L'account Ospite non può essere duplicato",
    217  => "L'utente non dispone di privilegi sufficienti per modificare l'account Admin",
    300  => "File bloccato o in uso",
    301  => "Record usato da un altro utente",
    302  => "Tabella usata da un altro utente",
    303  => "Schema database usato da un altro utente",
    304  => "Formato usato da un altro utente",
    306  => "ID modifica del record non corrispondente",
    400  => "Criteri di ricerca vuoti",
    401  => "Nessun record soddisfa la richiesta",
    402  => "Il campo selezionato non è un campo di confronto per un riferimento",
    403  => "Limite massimo di record per la versione di prova di FileMaker Pro superato",
    404  => "Criterio di ordinamento non valido",
    405  => "Il numero di record specificato supera il numero di record che possono essere omessi",
    406  => "Criteri di sostituzione/riserializzazione non validi",
    407  => "Manca uno o entrambi i campi di confronto (relazione non valida)",
    408  => "Tipo di dati associato al campo specificato non valido per questa operazione",
    409  => "Ordine di importazione non valido",
    410  => "Ordine di esportazione non valido",
    412  => "Per recuperare il file è stata usata una versione errata di FileMaker Pro",
    413  => "Tipo di campo non valido",
    414  => "Il formato non può visualizzare il risultato",
    415  => "Uno o più record correlati richiesti non sono disponibili",
    416  => "Chiave primaria richiesta dalla tabella di origine dati",
    417  => "Il database non è supportato per le operazioni ODBC",
    500  => "Il valore della data non soddisfa le opzioni di verifica",
    501  => "Il valore dell'ora non soddisfa le opzioni di verifica",
    502  => "Il valore del numero non soddisfa le opzioni di verifica",
    503  => "Il valore nel campo non è compreso nell'intervallo specificato nelle opzioni di verifica",
    504  => "Il valore del campo non è univoco come richiesto dalle opzioni di verifica",
    505  => "Il valore del campo non esiste nel file di database come richiesto dalle opzioni di verifica",
    506  => "Il valore nel campo non è elencato nella lista di valori specificata nelle opzioni di verifica",
    507  => "Il valore nel campo non ha superato il test del calcolo dell'opzione di verifica",
    508  => "Valore non valido immesso in modo Trova",
    509  => "Il campo richiede un valore valido",
    510  => "Valore correlato vuoto o non disponibile",
    511  => "Il valore immesso nel campo supera il numero massimo di caratteri consentiti",
    512  => "Il record è già stato modificato da un altro utente",
    513  => "Il record deve comprendere almeno un valore in un campo per poter essere creato",
    600  => "Errore di stampa",
    601  => "La combinazione di intestazione e piè di pagina supera una pagina",
    602  => "Il corpo non rientra in una pagina per l'impostazione della colonna corrente",
    603  => "Connessione di stampa interrotta",
    700  => "Tipo di file errato per l'importazione",
    706  => "File EPSF privo di immagine di anteprima",
    707  => "Impossibile trovare traduttore per immagini",
    708  => "Impossibile importare il file. È necessario un computer a colori",
    709  => "Non è riuscita l'importazione del filmato QuickTime",
    710  => "Impossibile aggiornare il riferimento QuickTime. Il file di database è di sola lettura",
    711  => "Impossibile trovare il traduttore per l'importazione",
    714  => "Operazione non consentita dai privilegi della password",
    715  => "È stato specificato un foglio di lavoro di Excel o un intervallo con nome mancante",
    716  => "Una query SQL che impiega istruzioni DELETE, INSERT o UPDATE non è consentita per l'importazione ODBC",
    717  => "Informazioni XML/XSL insufficienti per procedere con l'importazione o l'esportazione",
    718  => "Errore di analisi del file XML (da Xerces)",
    719  => "Errore di conversione XML usando XSL (da Xalan)",
    720  => "Errore durante l'esportazione; il formato desiderato non supporta i campi multipli",
    721  => "Errore sconosciuto nel parser o nel convertitore",
    722  => "Impossibile importare dati in un file che non ha campi",
    723  => "Non si dispone dell'autorizzazione per aggiungere o modificare record nella tabella di destinazione",
    724  => "Non si dispone dell'autorizzazione per aggiungere record alla tabella di destinazione",
    725  => "Non si dispone dell'autorizzazione per modificare record nella tabella di destinazione",
    726  => "Vi sono più record nel file di importazione che nella tabella di destinazione. Non tutti i record sono stati importati",
    727  => "Vi sono più record nella tabella di destinazione che nel file di importazione. Non tutti i record sono stati aggiornati",
    729  => "Errori durante l'importazione. Impossibile importare i record",
    730  => "Versione Excel non supportata. (Convertire il file in formato Excel 7.0 (Excel 95), Excel 97, 2000 o XP e riprovare)",
    731  => "Il file da importare non contiene dati",
    732  => "Questo file non può essere inserito perché contiene altri file",
    733  => "Una tabella non può essere importata in se stessa",
    734  => "I file di questo tipo non possono essere visualizzati come immagine",
    735  => "I file di questo tipo non possono essere visualizzati come immagine. Verranno inseriti e visualizzati come file",
    736  => "Troppi dati da esportare in questo formato. Sarà troncato",
    800  => "Impossibile creare il file su disco",
    801  => "Impossibile creare il file temporaneo sul disco di sistema",
    802  => "Impossibile aprire il file",
    803  => "Il file è per un singolo utente oppure non è stato possibile trovare l'host",
    804  => "Impossibile aprire il file.",
    805  => "Usare il comando Recupera",
    806  => "Impossibile aprire il file con questa versione di FileMaker Pro",
    807  => "Il file non è un file FileMaker Pro oppure è gravemente danneggiato",
    808  => "Impossibile aprire il file. I privilegi di accesso sono danneggiati",
    809  => "Il disco o il volume è pieno",
    810  => "Il disco o il volume è protetto",
    811  => "Impossibile aprire il file temporaneo come file di FileMaker Pro",
    813  => "Errore di sincronizzazione del record in rete",
    814  => "Impossibile aprire i file. È già aperto il numero massimo",
    815  => "Impossibile aprire il file di riferimento",
    816  => "Impossibile convertire il file",
    817  => "Impossibile aprire il file poiché non fa parte di questa soluzione",
    819  => "Impossibile salvare una copia locale di un file remoto",
    820  => "File in fase di chiusura",
    821  => "L'host ha forzato una disconnessione",
    822  => "File FMI non trovati; reinstallare i file non presenti",
    823  => "Impossibile impostare il file su utente singolo; alcuni ospiti sono connessi",
    824  => "Il file è danneggiato o non è un file FileMaker",
    900  => "Errore generico del modulo di gestione del controllo ortografico",
    901  => "Dizionario principale non installato",
    902  => "Impossibile avviare la Guida",
    903  => "Impossibile usare il comando in un file condiviso",
    904  => "Questo comando non può essere usato in un file ospitato sotto FileMaker Server",
    905  => "Non è selezionato nessun campo attivo; il comando può essere usato solo se un campo è attivo",
    906  => "Il file corrente deve essere condiviso per usare questo comando",
    920  => "Impossibile inizializzare il modulo di gestione del controllo ortografico",
    921  => "Impossibile caricare il dizionario utente per la modifica",
    922  => "Impossibile trovare il dizionario utente",
    923  => "Il dizionario utente è di sola lettura",
    951  => "Errore imprevisto (*)",
    954  => "Grammatica XML non supportata (*)",
    955  => "Nessun nome per il database (*)",
    956  => "È stato superato il numero massimo di sessioni del database (*)",
    957  => "Conflitto tra i comandi (*)",
    958  => "Parametro mancante (*)",
    1200 => "Errore di calcolo generico",
    1201 => "Troppi pochi parametri nella funzione",
    1202 => "Troppi parametri nella funzione",
    1203 => "Fine calcolo non previsto",
    1204 => "Sono previsti un numero, una costante di testo, un nome di campo o una '('",
    1205 => "Il commento non termina con '*/'",
    1206 => "La costante di testo deve terminare con un punto interrogativo",
    1207 => "Parentesi mancante",
    1208 => "Operatore mancante, funzione non trovata o '(' non prevista",
    1209 => "Nome (come nome campo o nome formato) mancante",
    1210 => "La funzione del plug-in è già stata registrata",
    1211 => "Utilizzo della lista valori non consentito in questa funzione",
    1212 => "Qui è previsto un operatore (ad esempio, +, -, *)",
    1213 => "Questa variabile è già stata definita nella funzione Consenti",
    1214 => "MEDIO, CONTEGGIO, ESPANSO, RICAVARIPETIZIONI, MAX, MIN, VPN, DEVST, SOMMA e RICAVARIASSUNTO: espressione trovata dove è necessario un campo solo",
    1215 => "Questo parametro è un parametro non valido per la funzione Get",
    1216 => "Solo i campi Riassunto sono consentiti come primo argomento in RICAVARIASSUNTO",
    1217 => "Il campo di separazione non è valido",
    1218 => "Impossibile valutare il numero",
    1219 => "Non è possibile usare un campo nella propria formula",
    1220 => "Il campo deve essere di tipo normale o Calcolo",
    1221 => "I dati devono essere di tipo Numero, Data, Ora o Indicatore data e ora",
    1222 => "Impossibile memorizzare il calcolo",
    1223 => "La funzione non è implementata",
    1224 => "La funzione non è definita",
    1225 => "La funzione non è supportata in questo contesto",
    1300 => "Il nome specificato non può essere utilizzato",
    1400 => "Errore nell'inizializzazione del driver ODBC; assicurarsi che i driver ODBC siano installati correttamente",
    1401 => "Allocazione ambiente fallita (ODBC)",
    1402 => "Impossibile liberare l'ambiente (ODBC)",
    1403 => "Impossibile disconnettersi (ODBC)",
    1404 => "Impossibile allocare la connessione (ODBC)",
    1405 => "Impossibile liberare la connessione ( ODBC)",
    1406 => "Controllo SQL API (ODBC) fallito",
    1407 => "Impossibile allocare l'istruzione (ODBC)",
    1408 => "Errore esteso (ODBC)",
    1409 => "Errore (ODBC)",
    1410 => "Link comunicazione fallito (ODBC)",
    1411 => "Link comunicazione fallito (ODBC)",
    1412 => "Link comunicazione fallito (ODBC)",
    1413 => "Link comunicazione fallito (ODBC)",
    1450 => "L'azione richiede privilegi PHP estesi",
    1451 => "L'azione richiede che il file corrente sia remoto",
    1501 => "Autenticazione SMTP fallita",
    1502 => "Connessione rifiutata dal server SMTP",
    1503 => "Errore con SSL",
    1504 => "Il server SMTP richiede che la connessione sia cifrata",
    1505 => "L'autenticazione specificata non è supportata dal server SMTP",
    1506 => "L'Email non può essere inviata",
    1507 => "Impossibile registrare all'interno del server SMTP"
    
};

sub new
{
    my $class = shift;
    $class = ref($class) || $class;

    my $self = { };
    return bless $self, $class;
}

sub get_string
{
    my ($self, $error_code) = @_;
    return $error_codes->{$error_code};
}

1; # End of Net::FileMaker::Error::IT::XML
