package SimpleDB::Scalar;
# $Id: Scalar.pm,v 1.4 2000/12/08 17:12:39 tom Exp $
################################################################


=head1 NAME

SimpleDB::Scalar - 顼ե

=head1 SYNOPSIS

 use SimpleDB::Scalar;

 $s = new SimpleDB::Scalar;
 tie $s, 'SimpleDB::Scalar', "foo.dat";
 $s = "this is a test.";
 print $s;

=head1 DESCRIPTION

 tie $s, 'SimpleDB::Scalar', "foo.dat", 1;

Ȥ read only Ȥư

=cut

use strict;
use vars qw(@ISA);
use Fcntl ':flock';

use JConv;
use SimpleDB::Base;
@ISA = qw(SimpleDB::Base);

sub TIESCALAR ($$;$)
{
    my ($class, $filename, $readonly) = @_;
    my $self = new SimpleDB::Base($filename, $readonly);
    bless $self, $class;
}
sub FETCH ($)
{
    my $self = shift;
    $self->SUPER::FETCH;
    return $self->{content};
}
    
sub STORE ($$)
{
    my ($self, $value) = @_;

    $self->SUPER::STORE;
    $self->{content} = $value;
}
sub DESTROY ($)
{
    my $self = shift;

#    print "Scalar: DESTROY\n";
    
    return unless $self->{modified};
    return if $self->SUPER::DESTROY;

    unless (open(F, ">$self->{filename}")){
	die "cannot write : $self->{filename}";
    }
#    print $self->{filename};
    eval { flock(F, LOCK_EX) };
    print F $self->{content};
    eval { flock(F, LOCK_UN) };
    close (F);

#    print "update\n";
}
################################################################
sub Read($)
{
    my $self = shift;

#    print "reading scalar\n";
    return if $self->SUPER::Read;
    open(F, $self->{filename}) ||  return;
    eval { flock(F, LOCK_EX) };
#    local($/) = undef;
#    $self->{content} = <F>;
    my $c;
    *jconv = mkjconv('auto', 'euc');
    while (<F>){
	jconv(\$_);
	$c .= $_;
    }
    $self->{content} = $c;
    eval {flock(F, LOCK_UN)};
    close (F);
}

1;

    
    

