/* $Id: l_defs.h,v 1.1.1.1 2000/05/07 20:26:05 mauhuur Exp $ */
/*
 *
 * $Log: l_defs.h,v $
 * Revision 1.1.1.1  2000/05/07 20:26:05  mauhuur
 * Initial import
 *
 *
 *
 * */

/* This file is a part of iLisp3 package. */
/* If you made any modifications in this file, rebuild the whole library */

#ifdef _cplusplus
extern "C" {
#endif

#ifndef LDEFS_H
#define LDEFS_H
#ifndef MAXSYMNAMESIZE
/** Maximum symbol name size */
#define MAXSYMNAMESIZE 60
#endif
#ifndef LFREEMAX
/** Size of a free pending pool */
#define LFREEMAX 64
#endif
#ifndef NOSYM
/** Maximum number of symbols in a table */
#define NOSYM 10000
#endif
#ifndef LPOOLMAX
/** Maximum size of one ListsPool */
#define LPOOLMAX 400000
/* Uncomment this to use old malloc() method of LIST's allocation */
#ifndef LP_MALLOC 
#define LP_MALLOC
#endif 

#endif

/** Default return value for lisp functions */
#define dfret NIL
/* VSL's standard type definitions. */
/* FIXME: must be more portable */
#ifndef UC_ALREADY
/** unsigned byte */
typedef char uc;
/** Unsigned 4--byte integer */
typedef unsigned int ui;
/** Unsigned 2--byte integer */
typedef unsigned short int usi;
/** Information about uc, ui and usi definitions */
#define UC_ALREADY

#endif

#include <stdio.h>

extern char IL_Version[];
/** ATOM structure definition */
struct _ato { 
  /** type */
  uc f;
  /** GC information */
  usi g;
  /** ATOM value pointer */
  uc * a;
  /** Additional information */
  uc * b;
  double d;
};
/** ATOM pointer */
typedef struct _ato * ATOM;


ATOM mkatm(int l);

/** A very important union */
union _l1 {
  /** atomic part */
  ATOM a;
  /** List pointer */
  struct _list *l;
};

/** L1 definition */
typedef union _l1 L1;

/** _list definition */
struct _list {
  /** Information about type */
  uc f;
  /** GC information */
  usi g;
  /** Head and tail */
  union _l1 h,t;
};

/** LIST pointer definition */
typedef struct _list * LIST;


/* Lisp symbols */
/** NIL is a nothing */
#define NIL NULL

/** Size of list structure. Not needed. */
#define LIS sizeof(struct _list)
LIST mklist(LIST p1,LIST p2);
uc Typof(LIST l);
LIST physcopy(LIST a);
LIST aplist(LIST a, LIST b);
LIST aplist01(LIST a, LIST b);

struct _LS {
		uc f;
		L1 h;
		};

typedef struct _LS LS;

/** Symbol structure */
struct _Symbol {
		/** Name of symbol */
		uc nm[MAXSYMNAMESIZE];
		/** Type */
		uc f;
		/** Value */
		L1 v;
		};

/** Symbol definition */
typedef struct _Symbol Symbol;

int printl(LIST a);
int IReader();
LIST readl(uc *s);
LIST LRead(FILE *f);
ATOM MakeAtom(char *s);
ATOM MakeDAtom(double d);
ATOM MakeFAtom(FILE *d);
/* double GetDouble(ATOM a); */
#define GetDouble(at) ((at)->d)
int kilatom(ATOM a);
int killlist(LIST l);
int kilat(ATOM a);
int killl(LIST l);
int killtop(LIST l);
#define gcnofsym global.cnofsym
#define ERROR()  if(1) {ERRR(); return Ret;}

uc etchar(FILE *f);
int feof1(FILE *f);

struct _tree {
  ui V;
  struct _tree *l,*r;
};

typedef struct _tree lTree;

typedef lTree * LTree;

LTree mktree(ui v, LTree l,LTree r);
ui addttr(LTree t,uc *s,ui i);
ui findintree(LTree t,uc *s);
int killtree(LTree t);

/** Hash table element */
struct _hash {
  /** Value */
  usi c;
  /** Next table pointer */ 
  struct _hash *h;
};

typedef struct _hash hash;

hash *mkha();

/** Symbol table */
struct _stab {
  /** hash table for this symbol table */
  hash * t;
  /** Pointers to defined symbols */
  Symbol **Symbols;
  /** Maximum number of symbols in table */ 
  ui nofsym;
  /** Current number of symbols in table */
  ui cnofsym;
  /** Continuation */
  struct _stab *nxt;
  /** A list assigned to continuation table */
  LIST nxtp;
  /** Current LISP context */
  struct _LISPcontext *context;
};

typedef struct _stab symtab;

symtab *CreateCTX(int n);
ui symbolp(uc *n,symtab *t,ui *csym,symtab **tt);
int initglobtab(ui n);
ui lengthl(LIST a);
LIST leval(LIST l,symtab *tab);
LIST onesymeval(LIST l,symtab *tab);
int aatl(Symbol *s);
LIST  lambda(LIST ld,LIST pars,symtab *tab);
int ERRR();
void deffun(symtab *tab,char *n,LIST (*f)(symtab *tab,LIST l));
Symbol *defRet();
#define lmalloc(s) ((char *)malloc(s))
int LoadContext(uc *b);

struct _FD {
  int (*f)(void *);
};
	
typedef struct _FD FD;

#define PAR1 onesymeval(l->t.l,tab)
#define PAR2 onesymeval(l->t.l->t.l,tab)
#define PAR3 onesymeval(l->t.l->t.l->t.l,tab)
#define PAR4 onesymeval(l->t.l->t.l->t.l->t.l,tab)
#define PAR5 onesymeval(l->t.l->t.l->t.l->t.l->t.l,tab)
#define PAR6 onesymeval(l->t.l->t.l->t.l->t.l->t.l->t.l,tab)

#define IL_PARS symtab *tab,LIST l

int lisp_init(int n);
int InitLDFuns();
char* lText(ATOM a,char *TeXt);

int InitMem(unsigned short int nb);

/* There are no any ideas... */
#define l_alloc_a(l) ((char *)malloc(l))

#ifdef LP_MALLOC
#define l_free(p) free(p)
#define lp_free(p) free(p)
#define l_alloc_l() ((LIST)malloc(sizeof(struct _list)))
#else
int LP_l_free(char *p);
void LP_lp_free(void * l);
LIST LP_l_alloc_l();
#define l_free(p) LP_l_free(p)
#define lp_free(p) LP_lp_free(p)
#define l_alloc_l() LP_l_alloc_l()
#endif

int killhash(hash *h);
ui findinhash(symtab *tab,char *c);
void AddSymbol(Symbol *s,symtab *tab);
int EqAtom(ATOM a,char *s);
LIST LReadS(char *f);

#define aatl1(s) killlist(s)

struct _func_d {
  char *n; /* function name */
  char *i; /* image name */
};

typedef struct _func_d func_d;

struct _fdesc {
  char *c;
  char t; /* Element type; t==0 -- inline function,
	     t==1 -- shared function, t==2 -- Symbol */
  union {
    LIST (*f)(symtab *tab,LIST l);
    func_d *d;
    Symbol **s;
    symtab *t;
  } f;
};

typedef struct _fdesc fdesc;

typedef LIST (*LISPHOOK)(symtab *tab,LIST l);

struct _LISPcontext {
  symtab *Global;
  fdesc **SysFuns;
  hash *sfhash;
  ui noffuns;
  symtab *ctab;
  FILE *FiI;
  FILE *lOf;
  char *frm;
  ui frFp;
};

typedef struct _LISPcontext LISPcontext;

/* It's a workaround for misterious bug in Linux ELF */
symtab *ReturnGlobal();

/* Externals to be REMOVED! */

extern FILE *FiI;
extern FILE *lOf;
extern char *frm;
extern uc *qqs;
extern ui qqssz;
extern ui spo;
extern uc qqc;

/* FIXME: workaround for "global" bug */

 extern symtab l_global_symtab; 
#define global l_global_symtab 

/* extern symtab global;*/

/* END-OF-FIXME */


extern ui csym;
extern symtab *ctab;
extern int uve_inited;	
extern ui frFp;
extern char *Header;
extern char *T_OS;
extern char *T_CPU;
extern int CompileP;
extern int heSz,Pos;
extern LIST lT,lNIL;
extern int GLBargc;
extern char **GLBargv;

  void IL_init_hash();
  hash *IL_mkha();
  ui IL_find_in_hash(hash *h,ui d,uc *n);
  ui IL_put_in_hash (hash *h,ui d,uc *n,ui val);
  void IL_kill_hash (hash *h);

void IL_init_signals();

#define Typof(l) ((l==NIL)?0:(l->f)&1)



#endif

#ifdef _cplusplus
}
#endif







