/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public class MaximumInformationTrimmer
extends AbstractSingleRecordTrimmer {
    public static final int LONGEST_READ = 1000;
    public static final int MAXQUAL = 60;
    private int parLength;
    private float strictness;
    private double[] lengthScoreTmp;
    private double[] qualProbTmp;
    private long[] lengthScore;
    private long[] qualProb;

    private static double calcNormalization(double[] array, int margin) {
        double maxVal = array[0];
        for (int i = 1; i < array.length; ++i) {
            double val = Math.abs(array[i]);
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        return 9.223372036854776E18 / (maxVal * (double)margin);
    }

    private static long[] normalize(double[] array, double ratio) {
        long[] out = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = (long)(array[i] * ratio);
        }
        return out;
    }

    public MaximumInformationTrimmer(String args) {
        int i;
        String[] arg = args.split(":");
        this.parLength = Integer.parseInt(arg[0]);
        this.strictness = Float.parseFloat(arg[1]);
        this.lengthScoreTmp = new double[1000];
        for (i = 0; i < 1000; ++i) {
            double pow1 = Math.exp(this.parLength - i - 1);
            double unique = Math.log(1.0 / (1.0 + pow1));
            double coverage = Math.log(i + 1) * (double)(1.0f - this.strictness);
            this.lengthScoreTmp[i] = unique + coverage;
        }
        this.qualProbTmp = new double[61];
        for (i = 0; i < this.qualProbTmp.length; ++i) {
            this.qualProbTmp[i] = Math.log(1.0 - Math.pow(0.1, (0.5 + (double)i) / 10.0)) * (double)this.strictness;
        }
        double normRatio = Math.max(MaximumInformationTrimmer.calcNormalization(this.lengthScoreTmp, 2000), MaximumInformationTrimmer.calcNormalization(this.qualProbTmp, 2000));
        this.lengthScore = MaximumInformationTrimmer.normalize(this.lengthScoreTmp, normRatio);
        this.qualProb = MaximumInformationTrimmer.normalize(this.qualProbTmp, normRatio);
    }

    public FastqRecord processRecord(FastqRecord in) {
        int[] quals = in.getQualityAsInteger(true);
        long accumQuality = 0L;
        double maxScore = -1.7976931348623157E308;
        int maxScorePosition = 0;
        for (int i = 0; i < quals.length; ++i) {
            int q = quals[i];
            if (q < 0) {
                q = 0;
            } else if (q > 60) {
                q = 60;
            }
            long ls = this.lengthScore[i];
            long score = ls + (accumQuality += this.qualProb[q]);
            if (!((double)score >= maxScore)) continue;
            maxScore = score;
            maxScorePosition = i + 1;
        }
        if (maxScorePosition < 1 || maxScore == 0.0) {
            return null;
        }
        if (maxScorePosition < quals.length) {
            return new FastqRecord(in, 0, maxScorePosition);
        }
        return in;
    }
}

