#!/bin/sh
#
# Upgrade the database of an existing bracket
# installation to match the current version.
#

. ./bracket.conf

set -e

(
cd $results_root

for d in 2???.??.??.??.??.??
do
   if test -d $d
   then
       year=`echo $d | sed 's/^\(....\).*$/\1/'`
       mkdir -p $year
       mv $d $year/$d
   fi
done
)

rm -rf $htmldir/build

bracket update-reports

case $webserver_rsync_target in
  "") ;;
  *) echo "please remove $webserver_rsync_target/build manually" ;;
esac
