/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ThumbnailCache
implements Runnable {
    public static final String MODULE = "ThumbCache";
    boolean stillRunning = false;
    Stack toLoad = new Stack();
    HashMap thumbnails = new HashMap();

    public void run() {
        Thread.yield();
        int loaded = 0;
        GalleryRemote._().getCore().getMainStatusUpdate().startProgress(2, 0, this.toLoad.size(), GRI18n.getString(MODULE, "loadThmb"), false);
        while (!this.toLoad.isEmpty()) {
            Picture p = (Picture)this.toLoad.pop();
            Image i = null;
            if (this.thumbnails.containsKey(p)) continue;
            if (p.isOnline()) {
                Log.log(3, MODULE, "Fetching thumbnail " + p.getUrlThumbnail());
                try {
                    URLConnection conn = ImageUtils.openUrlConnection(p.getUrlThumbnail(), p);
                    conn.connect();
                    ImageReader reader = ImageIO.getImageReadersByFormatName("jpeg").next();
                    ImageInputStream inputStream = ImageIO.createImageInputStream(conn.getInputStream());
                    reader.setInput(inputStream);
                    i = reader.read(0);
                    reader.dispose();
                }
                catch (IIOException e) {
                    Log.logException(1, MODULE, e);
                }
                catch (IOException e) {
                    Log.logException(1, MODULE, e);
                }
                if (i != null) {
                    Dimension newD = ImageUtils.getSizeKeepRatio(new Dimension(((BufferedImage)i).getWidth(), ((BufferedImage)i).getHeight()), GalleryRemote._().properties.getThumbnailSize(), true);
                    if (newD != null) {
                        Image scaled = i.getScaledInstance(newD.width, newD.height, 2);
                        i.flush();
                        i = scaled;
                    }
                } else {
                    i = ImageUtils.unrecognizedThumbnail;
                }
            } else {
                i = ImageUtils.load(p.getSource().getPath(), GalleryRemote._().properties.getThumbnailSize(), 0);
            }
            this.thumbnails.put(p, i);
            Log.log(3, MODULE, "update progress " + ++loaded + "/" + (loaded + this.toLoad.size()));
            GalleryRemote._().getCore().getMainStatusUpdate().updateProgressValue(2, loaded, loaded + this.toLoad.size());
            GalleryRemote._().getCore().thumbnailLoadedNotify();
        }
        this.stillRunning = false;
        GalleryRemote._().getCore().getMainStatusUpdate().stopProgress(2, GRI18n.getString(MODULE, "thmbLoaded"));
    }

    public void preloadThumbnailFirst(Picture p) {
        Log.log(3, MODULE, "preloadThumbnailFirst " + p);
        if (!this.thumbnails.containsKey(p)) {
            this.toLoad.push(p);
            this.rerun();
        }
    }

    public void preloadThumbnails(Iterator pictures) {
        Log.log(3, MODULE, "preloadThumbnails");
        while (pictures.hasNext()) {
            Picture p = (Picture)pictures.next();
            if (this.thumbnails.containsKey(p)) continue;
            this.toLoad.add(0, p);
        }
        this.rerun();
    }

    public void reload() {
        Iterator it = ((HashMap)this.thumbnails.clone()).keySet().iterator();
        this.thumbnails.clear();
        this.preloadThumbnails(it);
    }

    public void flushMemory() {
        Iterator it = this.thumbnails.values().iterator();
        while (it.hasNext()) {
            Image i = (Image)it.next();
            if (i == null) continue;
            i.flush();
        }
        this.thumbnails.clear();
    }

    void rerun() {
        if (!this.stillRunning && GalleryRemote._().properties.getShowThumbnails()) {
            this.stillRunning = true;
            Log.log(3, MODULE, "Calling Start");
            new Thread(this).start();
        }
    }

    void cancelLoad() {
        this.toLoad.clear();
    }

    public Image getThumbnail(Picture p) {
        return (Image)this.thumbnails.get(p);
    }
}

