/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import gnu.classpath.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.spi.RegisterableService;

public class ServiceRegistry {
    final Class[] categories;
    private final LinkedList[] providers;
    private IdentityHashMap[] constraints;

    public static Iterator lookupProviders(Class clazz, ClassLoader classLoader) {
        return ServiceFactory.lookupProviders(clazz, classLoader);
    }

    public static Iterator lookupProviders(Class clazz) {
        return ServiceFactory.lookupProviders(clazz);
    }

    public Iterator getCategories() {
        return new Iterator(){
            int index;

            public final boolean hasNext() {
                boolean bl = false;
                if (this.index < ServiceRegistry.this.categories.length - 1) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ServiceRegistry.this.categories[++this.index];
            }

            public final void remove() {
                throw new UnsupportedOperationException();
            }

            private final /* synthetic */ void this() {
                this.index = -1;
            }
            {
                this.this();
            }
        };
    }

    private final synchronized boolean registerServiceProvider(Object object, int n) {
        boolean bl;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class clazz = this.categories[n];
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(clazz.getName());
        }
        LinkedList linkedList = this.providers[n];
        if (linkedList == null) {
            bl = true;
            linkedList = this.providers[n] = new LinkedList();
        } else {
            bl = false;
        }
        linkedList.add(object);
        if (object instanceof RegisterableService) {
            ((RegisterableService)object).onRegistration(this, clazz);
        }
        return bl;
    }

    public synchronized boolean registerServiceProvider(Object object, Class clazz) {
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n] == clazz) {
                return this.registerServiceProvider(object, n);
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    public synchronized void registerServiceProvider(Object object) {
        boolean bl = false;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n].isInstance(object)) {
                bl = true;
                this.registerServiceProvider(object, n);
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void registerServiceProviders(Iterator var1_1) {
        if (var1_1 != null) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            this.registerServiceProvider(var1_1.next());
lbl4:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl5:
        // 1 sources

    }

    private final synchronized boolean deregisterServiceProvider(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class clazz = this.categories[n];
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(clazz.getName());
        }
        LinkedList linkedList = this.providers[n];
        if (linkedList == null) {
            return false;
        }
        boolean bl = linkedList.remove(object);
        if (linkedList.isEmpty()) {
            this.providers[n] = null;
        }
        if (bl && object instanceof RegisterableService) {
            ((RegisterableService)object).onDeregistration(this, clazz);
        }
        return bl;
    }

    public synchronized boolean deregisterServiceProvider(Object object, Class clazz) {
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n] == clazz) {
                return this.deregisterServiceProvider(object, n);
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    public synchronized void deregisterServiceProvider(Object object) {
        boolean bl = false;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n].isInstance(object)) {
                bl = true;
                this.deregisterServiceProvider(object, n);
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void deregisterAll(Class clazz) {
        boolean bl = false;
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n] == clazz) {
                bl = true;
                while (this.providers[n] != null) {
                    this.deregisterServiceProvider(this.providers[n].get(0), n);
                }
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deregisterAll() {
        var1_1 = 0;
        ** GOTO lbl8
        {
            this.deregisterServiceProvider(this.providers[var1_1].get(0), var1_1);
            do {
                if (this.providers[var1_1] != null) continue block0;
                ++var1_1;
lbl8:
                // 2 sources

            } while (var1_1 < this.categories.length);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deregisterAll();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.providers.length) {
            LinkedList linkedList;
            if (this.categories[n].isInstance(object) && (linkedList = this.providers[n]) != null && linkedList.contains(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final int getCategoryID(Class clazz) {
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n] == clazz) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    public Iterator getServiceProviders(Class clazz, boolean bl) {
        return this.getServiceProviders(clazz, null, bl);
    }

    public synchronized Iterator getServiceProviders(Class clazz, Filter filter, boolean bl) {
        int n = this.getCategoryID(clazz);
        LinkedList linkedList = this.providers[n];
        if (linkedList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList arrayList = new ArrayList(linkedList.size());
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (filter != null && !filter.filter(object2)) continue;
            arrayList.add(object2);
        }
        if (bl && this.constraints != null && (object = this.constraints[n]) != null) {
            Collections.sort(arrayList, new Comparator((Map)object){
                final /* synthetic */ Map val$cons;

                public final int compare(Object object, Object object2) {
                    if (object == object2) {
                        return 0;
                    }
                    Set set = (Set)this.val$cons.get(object);
                    if (set != null && set.contains(object2)) {
                        return -1;
                    }
                    set = (Set)this.val$cons.get(object2);
                    if (set != null && set.contains(object)) {
                        return 1;
                    }
                    return 0;
                }
                {
                    this.val$cons = map;
                }
            });
        }
        return arrayList.iterator();
    }

    public synchronized Object getServiceProviderByClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.categories.length) {
            LinkedList linkedList;
            if (this.categories[n].isAssignableFrom(clazz) && (linkedList = this.providers[n]) != null) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!clazz.isInstance(object)) continue;
                    return object;
                }
            }
            ++n;
        }
        return null;
    }

    public synchronized boolean setOrdering(Class clazz, Object object, Object object2) {
        return this.addConstraint(this.getCategoryID(clazz), object, object2);
    }

    public synchronized boolean unsetOrdering(Class clazz, Object object, Object object2) {
        return this.removeConstraint(this.getCategoryID(clazz), object, object2);
    }

    private final boolean addConstraint(int n, Object object, Object object2) {
        Set set;
        IdentityHashMap identityHashMap;
        this.removeConstraint(n, object2, object);
        if (this.constraints == null) {
            this.constraints = new IdentityHashMap[this.categories.length];
        }
        if ((identityHashMap = this.constraints[n]) == null) {
            identityHashMap = this.constraints[n] = new IdentityHashMap();
        }
        if ((set = (Set)identityHashMap.get(object)) == null) {
            set = new HashSet();
            identityHashMap.put(object, set);
        }
        return set.add(object2);
    }

    private final boolean removeConstraint(int n, Object object, Object object2) {
        if (object == null || object2 == null || object == object2) {
            throw new IllegalArgumentException();
        }
        if (this.constraints == null) {
            return false;
        }
        IdentityHashMap identityHashMap = this.constraints[n];
        if (identityHashMap == null) {
            return false;
        }
        Collection collection = (Collection)identityHashMap.get(object);
        if (collection == null) {
            return false;
        }
        if (!collection.remove(object2)) {
            return false;
        }
        if (identityHashMap.isEmpty()) {
            this.constraints[n] = null;
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.constraints.length) {
                if (this.constraints[n2] != null) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.constraints = null;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public ServiceRegistry(Iterator var1_1) {
        super();
        var2_2 = new ArrayList(10);
        if (var1_1 != null) ** GOTO lbl10
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            var3_3 = (Class)var1_1.next();
            if (var3_3 == null) {
                throw new IllegalArgumentException();
            }
            var2_2.add(var3_3);
lbl10:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl11:
        // 1 sources

        var3_4 = var2_2.size();
        this.categories = (Class[])var2_2.toArray(new Class[var3_4]);
        this.providers = new LinkedList[var3_4];
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

