// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomAPI_HeaderFile
#define _GeomAPI_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom2d_Curve.hxx>
#include <Handle_Geom_Curve.hxx>
class Geom2d_Curve;
class Geom_Curve;
class gp_Pln;
class GeomAPI_ProjectPointOnCurve;
class GeomAPI_ProjectPointOnSurf;
class GeomAPI_ExtremaCurveCurve;
class GeomAPI_ExtremaCurveSurface;
class GeomAPI_ExtremaSurfaceSurface;
class GeomAPI_PointsToBSpline;
class GeomAPI_PointsToBSplineSurface;
class GeomAPI_Interpolate;
class GeomAPI_IntSS;
class GeomAPI_IntCS;


//! The   GeomAPI   package  provides  an  Application
//! Programming Interface for the Geometry.
//!
//! The API is a set of  classes and methods aiming to
//! provide :
//!
//! * High level and simple calls  for the most common
//! operations.
//!
//! *    Keeping   an   access  on    the    low-level
//! implementation of high-level calls.
//!
//! The API  provides classes to  call the algorithmes
//! of the Geometry
//!
//! * The  constructors  of the classes  provides  the
//! different constructions methods.
//!
//! * The  class keeps as fields the   different tools
//! used by the algorithmes
//!
//! *   The class  provides  a  casting  method to get
//! automatically the  result  with  a   function-like
//! call.
//!
//! For example to evaluate the distance <D> between a
//! point <P> and a curve <C>, one can writes :
//!
//! D = GeomAPI_ProjectPointOnCurve(P,C);
//!
//! or
//!
//! GeomAPI_ProjectPointOnCurve PonC(P,C);
//! D = PonC.LowerDistance();
class GeomAPI 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! This function builds (in the
  //! parametric space of the plane P) a 2D curve equivalent to the 3D curve
  //! C. The 3D curve C is considered to be located in the plane P.
  //! Warning
  //! The 3D curve C must be of one of the following types:
  //! -      a line
  //! -      a circle
  //! -      an ellipse
  //! -      a hyperbola
  //! -      a parabola
  //! -      a Bezier curve
  //! -      a BSpline curve
  //! Exceptions Standard_NoSuchObject if C is not a defined type curve.
  Standard_EXPORT static   Handle(Geom2d_Curve) To2d (const Handle(Geom_Curve)& C, const gp_Pln& P) ;
  
  //! Builds a 3D curve equivalent to the 2D curve C
  //! described in the parametric space defined by the local
  //! coordinate system of plane P.
  //! The resulting 3D curve is of the same nature as that of the curve C.
  Standard_EXPORT static   Handle(Geom_Curve) To3d (const Handle(Geom2d_Curve)& C, const gp_Pln& P) ;




protected:





private:




friend class GeomAPI_ProjectPointOnCurve;
friend class GeomAPI_ProjectPointOnSurf;
friend class GeomAPI_ExtremaCurveCurve;
friend class GeomAPI_ExtremaCurveSurface;
friend class GeomAPI_ExtremaSurfaceSurface;
friend class GeomAPI_PointsToBSpline;
friend class GeomAPI_PointsToBSplineSurface;
friend class GeomAPI_Interpolate;
friend class GeomAPI_IntSS;
friend class GeomAPI_IntCS;

};







#endif // _GeomAPI_HeaderFile
