/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CvsTagEntry;
import org.apache.tools.ant.util.FileUtils;

public class CvsTagDiff
extends AbstractCvsTask {
    static final String FILE_IS_NEW = " is new; current revision ";
    static final String FILE_HAS_CHANGED = " changed from revision ";
    static final String FILE_WAS_REMOVED = " is removed";
    private String m_package;
    private String m_startTag;
    private String m_endTag;
    private String m_startDate;
    private String m_endDate;
    private File m_destfile;
    private FileUtils m_fileUtils = FileUtils.newFileUtils();

    public void setPackage(String p) {
        this.m_package = p;
    }

    public void setStartTag(String s) {
        this.m_startTag = s;
    }

    public void setStartDate(String s) {
        this.m_startDate = s;
    }

    public void setEndTag(String s) {
        this.m_endTag = s;
    }

    public void setEndDate(String s) {
        this.m_endDate = s;
    }

    public void setDestFile(File f) {
        this.m_destfile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.validate();
        String rdiff = "rdiff -s " + (this.m_startTag != null ? "-r " + this.m_startTag : "-D " + this.m_startDate) + " " + (this.m_endTag != null ? "-r " + this.m_endTag : "-D " + this.m_endDate) + " " + this.m_package;
        this.log("Cvs command is " + rdiff, 3);
        this.setCommand(rdiff);
        File tmpFile = null;
        try {
            tmpFile = this.m_fileUtils.createTempFile("cvstagdiff", ".log", null);
            this.setOutput(tmpFile);
            super.execute();
            CvsTagEntry[] entries = this.parseRDiff(tmpFile);
            this.writeTagDiff(entries);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CvsTagEntry[] parseRDiff(File tmpFile) throws BuildException {
        Object[] objectArray;
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(tmpFile));
                int headerLength = 5 + this.m_package.length() + 1;
                Vector<CvsTagEntry> entries = new Vector<CvsTagEntry>();
                String line = reader.readLine();
                CvsTagEntry entry = null;
                while (null != line) {
                    String filename;
                    int index = (line = line.substring(headerLength)).indexOf(FILE_IS_NEW);
                    if (index != -1) {
                        filename = line.substring(0, index);
                        String rev = line.substring(index + FILE_IS_NEW.length());
                        entry = new CvsTagEntry(filename, rev);
                        entries.addElement(entry);
                        this.log(entry.toString(), 3);
                    } else {
                        index = line.indexOf(FILE_HAS_CHANGED);
                        if (index != -1) {
                            filename = line.substring(0, index);
                            int revSeparator = line.indexOf(" to ", index);
                            String prevRevision = line.substring(index + FILE_HAS_CHANGED.length(), revSeparator);
                            String revision = line.substring(revSeparator + 4);
                            entry = new CvsTagEntry(filename, revision, prevRevision);
                            entries.addElement(entry);
                            this.log(entry.toString(), 3);
                        } else {
                            index = line.indexOf(FILE_WAS_REMOVED);
                            if (index != -1) {
                                filename = line.substring(0, index);
                                entry = new CvsTagEntry(filename);
                                entries.addElement(entry);
                                this.log(entry.toString(), 3);
                            }
                        }
                    }
                    line = reader.readLine();
                }
                Object[] array = new CvsTagEntry[entries.size()];
                entries.copyInto(array);
                objectArray = array;
                Object var13_14 = null;
                if (reader == null) return objectArray;
            }
            catch (IOException e) {
                throw new BuildException("Error in parsing", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return objectArray;
        }
        reader.close();
        return objectArray;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeTagDiff(CvsTagEntry[] entries) throws BuildException {
        FileOutputStream output = null;
        output = new FileOutputStream(this.m_destfile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<tagdiff ");
        if (this.m_startTag != null) {
            writer.print("startTag=\"" + this.m_startTag + "\" ");
        } else {
            writer.print("startDate=\"" + this.m_startDate + "\" ");
        }
        if (this.m_endTag != null) {
            writer.print("endTag=\"" + this.m_endTag + "\" ");
        } else {
            writer.print("endDate=\"" + this.m_endDate + "\" ");
        }
        writer.println(">");
        int c = entries.length;
        for (int i = 0; i < c; ++i) {
            this.writeTagEntry(writer, entries[i]);
        }
        writer.println("</tagdiff>");
        writer.flush();
        writer.close();
        Object var7_8 = null;
        if (null == output) return;
        try {
            output.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (UnsupportedEncodingException uee) {
                this.log(uee.toString(), 0);
                Object var7_9 = null;
                if (null == output) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void writeTagEntry(PrintWriter writer, CvsTagEntry entry) {
        writer.println("\t<entry>");
        writer.println("\t\t<file>");
        writer.println("\t\t\t<name>" + entry.getFile() + "</name>");
        if (entry.getRevision() != null) {
            writer.println("\t\t\t<revision>" + entry.getRevision() + "</revision>");
        }
        if (entry.getPreviousRevision() != null) {
            writer.println("\t\t\t<prevrevision>" + entry.getPreviousRevision() + "</prevrevision>");
        }
        writer.println("\t\t</file>");
        writer.println("\t</entry>");
    }

    private void validate() throws BuildException {
        if (null == this.m_package) {
            throw new BuildException("Package/module must be set.");
        }
        if (null == this.m_destfile) {
            throw new BuildException("Destfile must be set.");
        }
        if (null == this.m_startTag && null == this.m_startDate) {
            throw new BuildException("Start tag or start date must be set.");
        }
        if (null != this.m_startTag && null != this.m_startDate) {
            throw new BuildException("Only one of start tag and start date must be set.");
        }
        if (null == this.m_endTag && null == this.m_endDate) {
            throw new BuildException("End tag or end date must be set.");
        }
        if (null != this.m_endTag && null != this.m_endDate) {
            throw new BuildException("Only one of end tag and end date must be set.");
        }
    }
}

