/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultRegionChecker;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.state.DockingState;
import org.flexdock.util.SwingUtility;

public class DockingUtility
implements DockingConstants {
    private DockingUtility() {
    }

    public static DockingPort getParentDockingPort(Dockable d) {
        return d == null ? null : DockingUtility.getParentDockingPort(d.getComponent());
    }

    public static DockingPort getParentDockingPort(Component comp) {
        DockingPort port;
        DockingPort dockingPort = comp == null ? null : (port = (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, comp)));
        if (port == null) {
            return null;
        }
        return port.isParentDockingPort(comp) ? port : null;
    }

    public static boolean isSubport(DockingPort dockingPort) {
        return dockingPort == null ? false : SwingUtilities.getAncestorOfClass(DockingPort.class, (Component)((Object)dockingPort)) != null;
    }

    public static DockingPort findDockingPort(Container container, Point location) {
        if (container == null || location == null) {
            return null;
        }
        Component deepestComponent = SwingUtilities.getDeepestComponentAt(container, location.x, location.y);
        if (deepestComponent == null) {
            return null;
        }
        if (deepestComponent instanceof DockingPort) {
            return (DockingPort)((Object)deepestComponent);
        }
        return (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, deepestComponent));
    }

    public static String translateRegionAxis(JSplitPane splitPane, String region) {
        boolean horizontal;
        if (splitPane == null || !DockingManager.isValidDockingRegion(region)) {
            return null;
        }
        boolean bl = horizontal = splitPane.getOrientation() == 1;
        if (horizontal) {
            if ("NORTH".equals(region)) {
                region = "WEST";
            } else if ("SOUTH".equals(region)) {
                region = "EAST";
            }
        } else if ("WEST".equals(region)) {
            region = "NORTH";
        } else if ("EAST".equals(region)) {
            region = "SOUTH";
        }
        return region;
    }

    public static String flipRegion(String region) {
        if (!DockingManager.isValidDockingRegion(region) || "CENTER".equals(region)) {
            return "CENTER";
        }
        if ("NORTH".equals(region)) {
            return "SOUTH";
        }
        if ("SOUTH".equals(region)) {
            return "NORTH";
        }
        if ("EAST".equals(region)) {
            return "WEST";
        }
        return "EAST";
    }

    public static boolean isAxisEquivalent(String region, String otherRegion) {
        if (!DockingManager.isValidDockingRegion(region) || !DockingManager.isValidDockingRegion(otherRegion)) {
            return false;
        }
        if (region.equals(otherRegion)) {
            return true;
        }
        if ("CENTER".equals(region)) {
            return false;
        }
        if ("NORTH".equals(region)) {
            return "WEST".equals(otherRegion);
        }
        if ("SOUTH".equals(region)) {
            return "EAST".equals(otherRegion);
        }
        if ("EAST".equals(region)) {
            return "SOUTH".equals(otherRegion);
        }
        if ("WEST".equals(region)) {
            return "NORTH".equals(otherRegion);
        }
        return false;
    }

    public static boolean isRegionTopLeft(String region) {
        return "NORTH".equals(region) || "WEST".equals(region);
    }

    public static String getRegion(int regionType) {
        switch (regionType) {
            case 2: {
                return "WEST";
            }
            case 4: {
                return "EAST";
            }
            case 1: {
                return "NORTH";
            }
            case 3: {
                return "SOUTH";
            }
            case 0: {
                return "CENTER";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isMinimized(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockingState info = DockingUtility.getDockingState(dockable);
        return info == null ? false : info.isMinimized();
    }

    public static int getMinimizedConstraint(Dockable dockable) {
        int defaultConstraint = -1;
        DockingState info = dockable == null ? null : DockingUtility.getDockingState(dockable);
        return info == null ? defaultConstraint : info.getMinimizedConstraint();
    }

    private static DockingState getDockingState(Dockable dockable) {
        return DockingManager.getLayoutManager().getDockingState(dockable);
    }

    public static boolean dockRelative(Dockable dockable, Dockable parent, String relativeRegion) {
        return DockingUtility.dockRelative(parent, dockable, relativeRegion, -1.0f);
    }

    public static boolean dockRelative(Dockable dockable, Dockable parent, String relativeRegion, float ratio) {
        if (parent == null || dockable == null || !DockingManager.isValidDockingRegion(relativeRegion)) {
            return false;
        }
        DockingUtility.setSiblingPreference(parent, relativeRegion, ratio);
        DockingPort port = parent.getDockingPort();
        if (port != null) {
            return DockingManager.dock(dockable, port, relativeRegion);
        }
        return false;
    }

    private static void setSiblingPreference(Dockable src, String region, float size) {
        if (size == -1.0f || "CENTER".equals(region) || !DockingManager.isValidDockingRegion(region)) {
            return;
        }
        size = DefaultRegionChecker.validateSiblingSize(size);
        src.getDockingProperties().setSiblingSize(region, size);
    }

    public static boolean isFloating(Dockable dockable) {
        DockingState info = DockingUtility.getDockingState(dockable);
        return info == null ? false : info.isFloating();
    }

    public static boolean isEmbedded(Dockable dockable) {
        return dockable == null ? false : DockingManager.isDocked(dockable) && !DockingUtility.isFloating(dockable);
    }

    public static void setSplitProportion(DockingPort port, float proportion) {
        if (port == null) {
            return;
        }
        Component comp = port.getDockedComponent();
        if (comp instanceof JSplitPane) {
            SwingUtility.setSplitDivider((JSplitPane)comp, proportion);
        }
    }

    public static void setSplitProportion(Dockable dockable, float proportion) {
        if (dockable == null) {
            return;
        }
        Component comp = dockable.getComponent();
        Container parent = comp.getParent();
        if (parent instanceof JTabbedPane) {
            parent = parent.getParent();
        }
        if (!(parent instanceof DockingPort)) {
            return;
        }
        Container grandParent = parent.getParent();
        if (grandParent instanceof JSplitPane) {
            SwingUtility.setSplitDivider((JSplitPane)grandParent, proportion);
        }
    }

    public static String getTabText(Dockable dockable) {
        DockablePropertySet props = dockable == null ? null : dockable.getDockingProperties();
        return props == null ? null : props.getDockableDesc();
    }

    public static boolean isDockable(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Dockable) {
            return true;
        }
        if (obj instanceof JComponent) {
            Component comp = (Component)obj;
            return SwingUtility.getClientProperty(comp, "Dockable.DOCKABLE_INDICATOR") == Boolean.TRUE;
        }
        if (obj instanceof Component) {
            Component comp = (Component)obj;
            return DockingManager.getDockable(comp) != null;
        }
        return false;
    }

    public static Dockable getAncestorDockable(Component comp) {
        if (comp == null) {
            return null;
        }
        if (DockingUtility.isDockable(comp)) {
            return DockingManager.getDockable(comp);
        }
        for (Container parent = comp.getParent(); parent != null && !(parent instanceof JRootPane); parent = parent.getParent()) {
            if (!DockingUtility.isDockable(parent)) continue;
            return DockingManager.getDockable(parent);
        }
        return null;
    }

    public static boolean isActive(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        return dockable.getDockingProperties().isActive();
    }
}

