/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.trap;

import java.awt.EventQueue;
import javax.swing.JTextArea;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.trap.TrapPanel;
import org.parosproxy.paros.extension.trap.TrapParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;
import org.parosproxy.paros.view.View;

public class ProxyListenerTrap
implements ProxyListener {
    private static Object semaphore = new Object();
    private TrapPanel trapPanel = null;
    private TrapParam trapParam = null;
    private Model model = null;

    public ProxyListenerTrap(Model model, TrapParam trapParam) {
        this.model = model;
        this.trapParam = trapParam;
    }

    public TrapPanel getTrapPanel() {
        return this.trapPanel;
    }

    public void setTrapPanel(TrapPanel trapPanel) {
        this.trapPanel = trapPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpRequestSend(HttpMessage httpMessage) {
        if (!this.getTrapPanel().getChkTrapRequest().isSelected()) {
            return;
        }
        if (this.isSkipImage(httpMessage.getRequestHeader())) {
            return;
        }
        if (this.isSkipFilter(httpMessage)) {
            return;
        }
        Object object = semaphore;
        synchronized (object) {
            this.setTrapDisplay(httpMessage, true);
            this.waitUntilContinue(httpMessage, true);
        }
    }

    private void setTrapDisplay(HttpMessage httpMessage, boolean bl) {
        this.setHttpDisplay(this.getTrapPanel(), httpMessage, bl);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    View.getSingleton().getMainFrame().toFront();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setHttpDisplay(final HttpPanel httpPanel, final HttpMessage httpMessage, final boolean bl) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    httpPanel.setMessage(httpMessage, bl);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitUntilContinue(final HttpMessage httpMessage, final boolean bl) {
        this.getTrapPanel().setContinue(false);
        while (!this.getTrapPanel().isContinue()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ProxyListenerTrap.this.getTrapPanel().getMessage(httpMessage, bl);
                    ProxyListenerTrap.this.getTrapPanel().setMessage(null, bl);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (!this.getTrapPanel().getChkTrapResponse().isSelected()) {
            return;
        }
        if (this.isSkipImage(httpMessage.getRequestHeader()) || this.isSkipImage(httpMessage.getResponseHeader())) {
            return;
        }
        if (this.isSkipFilter(httpMessage)) {
            return;
        }
        Object object = semaphore;
        synchronized (object) {
            this.setTrapDisplay(httpMessage, false);
            this.waitUntilContinue(httpMessage, false);
        }
    }

    public String getHeaderFromJTextArea(JTextArea jTextArea) {
        String string = jTextArea.getText();
        String string2 = string.replaceAll("\\n", "\r\n");
        string2 = string2.replaceAll("(\\r\\n)*\\z", "") + "\r\n\r\n";
        return string2;
    }

    public String replaceHeaderForJTextArea(String string) {
        return string.replaceAll("\\r\\n", "\n");
    }

    public boolean isSkipImage(HttpHeader httpHeader) {
        return httpHeader.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }

    private boolean isSkipFilter(HttpMessage httpMessage) {
        try {
            URI uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
            uRI.setQuery(null);
            String string = uRI.toString();
            if (this.trapParam.isExclude(string)) {
                return true;
            }
            if (!this.trapParam.isInclude(string)) {
                return true;
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return false;
    }
}

