/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.MeteredInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Properties
implements Cloneable {
    private HashMap props = new HashMap();

    public void clear() {
        this.props.clear();
    }

    public Object clone() {
        Properties properties = new Properties();
        properties.props.putAll(this.props);
        return properties;
    }

    public boolean containsKey(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.props.containsKey(this.canonicalize(string));
    }

    public boolean containsValue(String string) {
        if (string == null) {
            return false;
        }
        return this.props.containsValue(string);
    }

    public String put(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0) {
            throw new IllegalArgumentException("key nor value can be null");
        }
        return (String)this.props.put(this.canonicalize(string), string2);
    }

    public String get(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (String)this.props.get(this.canonicalize(string));
    }

    public String remove(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (String)this.props.remove(this.canonicalize(string));
    }

    public void decode(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        DataInputStream dataInputStream2 = new DataInputStream(meteredInputStream);
        while (!meteredInputStream.limitReached()) {
            String string = dataInputStream2.readUTF();
            String string2 = dataInputStream2.readUTF();
            this.put(string, string2);
        }
    }

    public void encode(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        Iterator iterator = this.props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            dataOutputStream2.writeUTF((String)entry.getKey());
            dataOutputStream2.writeUTF((String)entry.getValue());
        }
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(dataOutputStream);
    }

    public String toString() {
        return this.props.toString();
    }

    private final String canonicalize(String string) {
        return string.toLowerCase();
    }
}

