/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable {
    private static final long serialVersionUID = -3665804199014368530L;
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('Z');
    private final boolean value;

    public final boolean booleanValue() {
        return this.value;
    }

    public static final Boolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static final Boolean valueOf(String string) {
        return "true".equalsIgnoreCase(string) ? TRUE : FALSE;
    }

    public static final String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public final String toString() {
        return this.value ? "true" : "false";
    }

    public final int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Boolean && this.value == ((Boolean)object).value) {
            bl = true;
        }
        return bl;
    }

    public static final boolean getBoolean(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return "true".equalsIgnoreCase(System.getProperty(string));
    }

    public static final boolean parseBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }

    public final int compareTo(Boolean bl) {
        if (bl == null) {
            throw new NullPointerException("argument passed to compareTo(Boolean) cannot be null");
        }
        if (this.value == bl.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this.value = "true".equalsIgnoreCase(string);
    }
}

