/**
 * Controls the preference for an individual notification type on the
 * message preference page.
 *
 * @module     core_message/notification_preference
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/notification_preference",["jquery","core/ajax","core/notification","core_message/notification_processor"],(function($,Ajax,Notification,NotificationProcessor){const SELECTORS_PROCESSOR="[data-processor-name]",SELECTORS_STATE_INPUTS="[data-state] input",NotificationPreference=function(element,userId){this.root=$(element),this.userId=userId};return NotificationPreference.prototype.getPreferenceKey=function(){return this.root.attr("data-preference-key")},NotificationPreference.prototype.getEnabledPreferenceKey=function(){return this.getPreferenceKey()+"_enabled"},NotificationPreference.prototype.getProcessors=function(){return this.root.find(SELECTORS_PROCESSOR).map((function(index,element){return new NotificationProcessor($(element))}))},NotificationPreference.prototype.startLoading=function(){this.root.addClass("loading"),this.root.find(SELECTORS_STATE_INPUTS).prop("disabled",!0)},NotificationPreference.prototype.stopLoading=function(){this.root.removeClass("loading"),this.root.find(SELECTORS_STATE_INPUTS).prop("disabled",!1)},NotificationPreference.prototype.isLoading=function(){return this.root.hasClass("loading")},NotificationPreference.prototype.save=function(){if(this.isLoading())return $.Deferred().resolve();this.startLoading();let enabledValue="";this.getProcessors().each((function(index,processor){processor.isEnabled()&&(""===enabledValue?enabledValue=processor.getName():enabledValue+=","+processor.getName())})),""===enabledValue&&(enabledValue="none");const request={methodname:"core_user_update_user_preferences",args:{userid:this.userId,preferences:[{type:this.getEnabledPreferenceKey(),value:enabledValue}]}};return Ajax.call([request])[0].fail(Notification.exception).always(function(){this.stopLoading()}.bind(this))},NotificationPreference}));

//# sourceMappingURL=notification_preference.min.js.map