/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.apache.tools.ant.types.optional.imageio.Arc;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.Ellipse;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.Rectangle;
import org.apache.tools.ant.types.optional.imageio.Text;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Draw
extends TransformOperation {
    private int xloc = 0;
    private int yloc = 0;

    public void setXloc(int x) {
        this.xloc = x;
    }

    public void setYloc(int y) {
        this.yloc = y;
    }

    public void addText(Text text) {
        this.instructions.add(text);
    }

    public void addRectangle(Rectangle rect) {
        this.instructions.add(rect);
    }

    public void addEllipse(Ellipse elip) {
        this.instructions.add(elip);
    }

    public void addArc(Arc arc) {
        this.instructions.add(arc);
    }

    @Override
    public BufferedImage executeTransformOperation(BufferedImage bi) {
        Graphics2D graphics = bi.createGraphics();
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                BufferedImage op = ((DrawOperation)((Object)instr)).executeDrawOperation();
                this.log("\tDrawing to x=" + this.xloc + " y=" + this.yloc);
                graphics.drawImage(op, null, this.xloc, this.yloc);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            BufferedImage child = ((TransformOperation)instr).executeTransformOperation(null);
            this.log("\tDrawing to x=" + this.xloc + " y=" + this.yloc);
            graphics.drawImage(child, null, this.xloc, this.yloc);
        }
        return bi;
    }
}

